/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.lib.mariadb.internal.com.read.dao;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import me.lucko.luckperms.lib.mariadb.internal.com.read.dao.CmdInformation;
import me.lucko.luckperms.lib.mariadb.internal.com.read.resultset.SelectResultSet;
import me.lucko.luckperms.lib.mariadb.internal.protocol.Protocol;

public class CmdInformationMultiple
implements CmdInformation {
    private final ArrayList<Long> insertIds;
    private final ArrayList<Long> updateCounts;
    private final int expectedSize;
    private final int autoIncrement;
    private int insertIdNumber = 0;
    private int moreResults;
    private boolean hasException;
    private boolean rewritten;

    public CmdInformationMultiple(int expectedSize, int autoIncrement) {
        this.insertIds = new ArrayList(expectedSize);
        this.updateCounts = new ArrayList(expectedSize);
        this.expectedSize = expectedSize;
        this.autoIncrement = autoIncrement;
    }

    @Override
    public void addErrorStat() {
        this.hasException = true;
        this.updateCounts.add(-3L);
    }

    @Override
    public void reset() {
        this.insertIds.clear();
        this.updateCounts.clear();
        this.insertIdNumber = 0;
        this.moreResults = 0;
        this.hasException = false;
        this.rewritten = false;
    }

    @Override
    public void addResultSetStat() {
        this.updateCounts.add(-1L);
    }

    @Override
    public void addSuccessStat(long updateCount, long insertId) {
        this.insertIds.add(insertId);
        this.insertIdNumber = (int)((long)this.insertIdNumber + updateCount);
        this.updateCounts.add(updateCount);
    }

    @Override
    public int[] getServerUpdateCounts() {
        int[] ret = new int[this.updateCounts.size()];
        Iterator<Long> iterator = this.updateCounts.iterator();
        int pos = 0;
        while (iterator.hasNext()) {
            ret[pos++] = iterator.next().intValue();
        }
        return ret;
    }

    @Override
    public int[] getUpdateCounts() {
        if (this.rewritten) {
            int[] ret = new int[this.expectedSize];
            Arrays.fill(ret, this.hasException ? -3 : -2);
            return ret;
        }
        int[] ret = new int[Math.max(this.updateCounts.size(), this.expectedSize)];
        Iterator<Long> iterator = this.updateCounts.iterator();
        int pos = 0;
        while (iterator.hasNext()) {
            ret[pos++] = iterator.next().intValue();
        }
        while (pos < ret.length) {
            ret[pos++] = -3;
        }
        return ret;
    }

    @Override
    public long[] getLargeUpdateCounts() {
        if (this.rewritten) {
            long[] ret = new long[this.expectedSize];
            Arrays.fill(ret, this.hasException ? -3L : -2L);
            return ret;
        }
        long[] ret = new long[Math.max(this.updateCounts.size(), this.expectedSize)];
        Iterator<Long> iterator = this.updateCounts.iterator();
        int pos = 0;
        while (iterator.hasNext()) {
            ret[pos++] = iterator.next();
        }
        while (pos < ret.length) {
            ret[pos++] = -3L;
        }
        return ret;
    }

    @Override
    public int getUpdateCount() {
        if (this.moreResults >= this.updateCounts.size()) {
            return -1;
        }
        return this.updateCounts.get(this.moreResults).intValue();
    }

    @Override
    public long getLargeUpdateCount() {
        if (this.moreResults >= this.updateCounts.size()) {
            return -1L;
        }
        return this.updateCounts.get(this.moreResults);
    }

    @Override
    public ResultSet getBatchGeneratedKeys(Protocol protocol) {
        long[] ret = new long[this.insertIdNumber];
        int position = 0;
        Iterator<Long> idIterator = this.insertIds.iterator();
        for (Long updateCount : this.updateCounts) {
            long insertId;
            if (updateCount == -3L || updateCount == -1L || (insertId = idIterator.next().longValue()) <= 0L) continue;
            int i = 0;
            while ((long)i < updateCount) {
                ret[position++] = insertId + (long)(i * this.autoIncrement);
                ++i;
            }
        }
        return SelectResultSet.createGeneratedData(ret, protocol, true);
    }

    @Override
    public ResultSet getGeneratedKeys(Protocol protocol, String sql) {
        long[] ret = new long[this.insertIdNumber];
        int position = 0;
        Iterator<Long> idIterator = this.insertIds.iterator();
        Iterator<Long> updateIterator = this.updateCounts.iterator();
        for (int element = 0; element <= this.moreResults; ++element) {
            long insertId;
            long updateCount = updateIterator.next();
            if (updateCount == -3L || updateCount == -1L || (insertId = idIterator.next().longValue()) <= 0L || element != this.moreResults) continue;
            int i = 0;
            while ((long)i < updateCount) {
                ret[position++] = insertId + (long)(i * this.autoIncrement);
                ++i;
            }
        }
        return SelectResultSet.createGeneratedData(ret, protocol, true);
    }

    @Override
    public int getCurrentStatNumber() {
        return this.updateCounts.size();
    }

    @Override
    public boolean moreResults() {
        return this.moreResults++ < this.updateCounts.size() - 1 && this.updateCounts.get(this.moreResults) == -1L;
    }

    @Override
    public boolean isCurrentUpdateCount() {
        return this.updateCounts.get(this.moreResults) != -1L;
    }

    @Override
    public void setRewrite(boolean rewritten) {
        this.rewritten = rewritten;
    }
}

