/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.lib.mariadb.internal.com.read.dao;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import me.lucko.luckperms.lib.mariadb.internal.com.read.resultset.ColumnDefinition;
import me.lucko.luckperms.lib.mariadb.internal.util.exceptions.ExceptionFactory;

public class ColumnLabelIndexer {
    private final ColumnDefinition[] columnInfo;
    private Map<String, Integer> originalMap;
    private Map<String, Integer> aliasMap;

    public ColumnLabelIndexer(ColumnDefinition[] columnDefinitions) {
        this.columnInfo = columnDefinitions;
    }

    public int getIndex(String name) throws SQLException {
        Integer res;
        if (name == null) {
            throw new SQLException("Column name cannot be null");
        }
        String lowerName = name.toLowerCase(Locale.ROOT);
        if (this.aliasMap == null) {
            this.aliasMap = new HashMap<String, Integer>();
            int counter = 0;
            for (ColumnDefinition ci : this.columnInfo) {
                String columnAlias = ci.getName();
                if (columnAlias != null) {
                    columnAlias = columnAlias.toLowerCase(Locale.ROOT);
                    this.aliasMap.putIfAbsent(columnAlias, counter);
                    String tableName = ci.getTable();
                    if (tableName != null) {
                        this.aliasMap.putIfAbsent(tableName.toLowerCase(Locale.ROOT) + "." + columnAlias, counter);
                    }
                }
                ++counter;
            }
        }
        if ((res = this.aliasMap.get(lowerName)) != null) {
            return res;
        }
        if (this.originalMap == null) {
            this.originalMap = new HashMap<String, Integer>();
            int counter = 0;
            for (ColumnDefinition ci : this.columnInfo) {
                String columnRealName = ci.getOriginalName();
                if (columnRealName != null) {
                    columnRealName = columnRealName.toLowerCase(Locale.ROOT);
                    this.originalMap.putIfAbsent(columnRealName, counter);
                    String tableName = ci.getOriginalTable();
                    if (tableName != null) {
                        this.originalMap.putIfAbsent(tableName.toLowerCase(Locale.ROOT) + "." + columnRealName, counter);
                    }
                }
                ++counter;
            }
        }
        if ((res = this.originalMap.get(lowerName)) == null) {
            throw ExceptionFactory.INSTANCE.create("No such column: " + name, "42S22", 1054);
        }
        return res;
    }
}

