/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.lib.mariadb.internal.com.read.resultset;

import java.nio.charset.StandardCharsets;
import me.lucko.luckperms.lib.mariadb.internal.ColumnType;
import me.lucko.luckperms.lib.mariadb.internal.com.read.Buffer;

public class ColumnDefinition {
    private static final int[] maxCharlen = new int[]{0, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 2, 1, 1, 1, 0, 1, 2, 1, 1, 1, 1, 2, 1, 1, 1, 2, 1, 1, 1, 1, 3, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 4, 1, 1, 1, 1, 1, 1, 1, 4, 4, 0, 1, 1, 1, 4, 4, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 3, 2, 2, 2, 2, 2, 1, 2, 3, 1, 1, 1, 2, 2, 3, 3, 1, 0, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 3, 4, 4, 0, 0, 0, 0, 0, 0, 0, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private final Buffer buffer;
    private final short charsetNumber;
    private final long length;
    private final ColumnType type;
    private final byte decimals;
    private final short flags;

    public ColumnDefinition(ColumnDefinition other) {
        this.buffer = other.buffer;
        this.charsetNumber = other.charsetNumber;
        this.length = other.length;
        this.type = other.type;
        this.decimals = other.decimals;
        this.flags = other.flags;
    }

    public ColumnDefinition(Buffer buffer) {
        this.buffer = buffer;
        buffer.position = buffer.limit - 12;
        this.charsetNumber = buffer.readShort();
        this.length = buffer.readInt();
        this.type = ColumnType.fromServer(buffer.readByte() & 0xFF, this.charsetNumber);
        this.flags = buffer.readShort();
        this.decimals = buffer.readByte();
    }

    public static ColumnDefinition create(String name, ColumnType type) {
        int len;
        int i;
        byte[] nameBytes = name.getBytes(StandardCharsets.UTF_8);
        byte[] arr = new byte[19 + 2 * nameBytes.length];
        int pos = 0;
        for (i = 0; i < 4; ++i) {
            arr[pos++] = 0;
        }
        for (i = 0; i < 2; ++i) {
            arr[pos++] = (byte)nameBytes.length;
            System.arraycopy(nameBytes, 0, arr, pos, nameBytes.length);
            pos += nameBytes.length;
        }
        arr[pos++] = 12;
        arr[pos++] = 33;
        arr[pos++] = 0;
        switch (type.getSqlType()) {
            case 1: 
            case 12: {
                len = 192;
                break;
            }
            case 5: {
                len = 5;
                break;
            }
            case 0: {
                len = 0;
                break;
            }
            default: {
                len = 1;
            }
        }
        arr[pos] = (byte)len;
        pos += 4;
        arr[pos++] = (byte)ColumnType.toServer(type.getSqlType()).getType();
        return new ColumnDefinition(new Buffer(arr));
    }

    private String getString(int idx) {
        this.buffer.position = 0;
        for (int i = 0; i < idx; ++i) {
            this.buffer.skipLengthEncodedBytes();
        }
        return this.buffer.readStringLengthEncoded(StandardCharsets.UTF_8);
    }

    public String getDatabase() {
        return this.getString(1);
    }

    public String getTable() {
        return this.getString(2);
    }

    public String getOriginalTable() {
        return this.getString(3);
    }

    public String getName() {
        return this.getString(4);
    }

    public String getOriginalName() {
        return this.getString(5);
    }

    public short getCharsetNumber() {
        return this.charsetNumber;
    }

    public long getLength() {
        return this.length;
    }

    public long getPrecision() {
        switch (this.type) {
            case OLDDECIMAL: 
            case DECIMAL: {
                if (this.isSigned()) {
                    return this.length - (long)(this.decimals > 0 ? 2 : 1);
                }
                return this.length - (long)(this.decimals > 0 ? 1 : 0);
            }
        }
        return this.length;
    }

    public int getDisplaySize() {
        int vtype = this.type.getSqlType();
        if (vtype == 12 || vtype == 1) {
            int maxWidth = maxCharlen[this.charsetNumber & 0xFF];
            if (maxWidth == 0) {
                maxWidth = 1;
            }
            return (int)this.length / maxWidth;
        }
        return (int)this.length;
    }

    public byte getDecimals() {
        return this.decimals;
    }

    public ColumnType getColumnType() {
        return this.type;
    }

    public short getFlags() {
        return this.flags;
    }

    public boolean isSigned() {
        return (this.flags & 0x20) == 0;
    }

    public boolean isNotNull() {
        return (this.flags & 1) > 0;
    }

    public boolean isPrimaryKey() {
        return (this.flags & 2) > 0;
    }

    public boolean isUniqueKey() {
        return (this.flags & 4) > 0;
    }

    public boolean isMultipleKey() {
        return (this.flags & 8) > 0;
    }

    public boolean isBlob() {
        return (this.flags & 0x10) > 0;
    }

    public boolean isZeroFill() {
        return (this.flags & 0x40) > 0;
    }

    public boolean isBinary() {
        return this.getCharsetNumber() == 63;
    }
}

