/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.lib.mariadb.internal.com.send.authentication;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import me.lucko.luckperms.lib.mariadb.authentication.AuthenticationPlugin;
import me.lucko.luckperms.lib.mariadb.internal.com.read.Buffer;
import me.lucko.luckperms.lib.mariadb.internal.io.input.PacketInputStream;
import me.lucko.luckperms.lib.mariadb.internal.io.output.PacketOutputStream;
import me.lucko.luckperms.lib.mariadb.util.Options;

public class ClearPasswordPlugin
implements AuthenticationPlugin {
    public static final String TYPE = "mysql_clear_password";
    private String authenticationData;
    private String passwordCharacterEncoding;

    @Override
    public String name() {
        return "mysql clear password";
    }

    @Override
    public String type() {
        return TYPE;
    }

    @Override
    public boolean mustUseSsl() {
        return true;
    }

    @Override
    public void initialize(String authenticationData, byte[] authData, Options options) {
        this.authenticationData = authenticationData;
        this.passwordCharacterEncoding = options.passwordCharacterEncoding;
    }

    @Override
    public Buffer process(PacketOutputStream out, PacketInputStream in, AtomicInteger sequence) throws IOException {
        if (this.authenticationData == null || this.authenticationData.isEmpty()) {
            out.writeEmptyPacket(sequence.incrementAndGet());
        } else {
            out.startPacket(sequence.incrementAndGet());
            byte[] bytePwd = this.passwordCharacterEncoding != null && !this.passwordCharacterEncoding.isEmpty() ? this.authenticationData.getBytes(this.passwordCharacterEncoding) : this.authenticationData.getBytes();
            out.write(bytePwd);
            out.write(0);
            out.flush();
        }
        Buffer buffer = in.getPacket(true);
        sequence.set(in.getLastPacketSeq());
        return buffer;
    }
}

