/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.lib.mariadb.internal.com.send.authentication;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import me.lucko.luckperms.lib.mariadb.authentication.AuthenticationPlugin;
import me.lucko.luckperms.lib.mariadb.internal.com.read.Buffer;
import me.lucko.luckperms.lib.mariadb.internal.com.send.authentication.ed25519.math.GroupElement;
import me.lucko.luckperms.lib.mariadb.internal.com.send.authentication.ed25519.math.ed25519.ScalarOps;
import me.lucko.luckperms.lib.mariadb.internal.com.send.authentication.ed25519.spec.EdDSANamedCurveSpec;
import me.lucko.luckperms.lib.mariadb.internal.com.send.authentication.ed25519.spec.EdDSANamedCurveTable;
import me.lucko.luckperms.lib.mariadb.internal.io.input.PacketInputStream;
import me.lucko.luckperms.lib.mariadb.internal.io.output.PacketOutputStream;
import me.lucko.luckperms.lib.mariadb.util.Options;

public class Ed25519PasswordPlugin
implements AuthenticationPlugin {
    private String authenticationData;
    private String passwordCharacterEncoding;
    private byte[] seed;

    private static byte[] ed25519SignWithPassword(String password, byte[] seed, String passwordCharacterEncoding) throws SQLException {
        try {
            byte[] bytePwd = passwordCharacterEncoding != null && !passwordCharacterEncoding.isEmpty() ? password.getBytes(passwordCharacterEncoding) : password.getBytes();
            MessageDigest hash = MessageDigest.getInstance("SHA-512");
            int mlen = seed.length;
            byte[] sm = new byte[64 + mlen];
            byte[] az = hash.digest(bytePwd);
            az[0] = (byte)(az[0] & 0xF8);
            az[31] = (byte)(az[31] & 0x3F);
            az[31] = (byte)(az[31] | 0x40);
            System.arraycopy(seed, 0, sm, 64, mlen);
            System.arraycopy(az, 32, sm, 32, 32);
            byte[] buff = Arrays.copyOfRange(sm, 32, 96);
            hash.reset();
            byte[] nonce = hash.digest(buff);
            ScalarOps scalar = new ScalarOps();
            EdDSANamedCurveSpec spec = EdDSANamedCurveTable.getByName("Ed25519");
            GroupElement elementAvalue = spec.getB().scalarMultiply(az);
            byte[] elementAarray = elementAvalue.toByteArray();
            System.arraycopy(elementAarray, 0, sm, 32, elementAarray.length);
            nonce = scalar.reduce(nonce);
            GroupElement elementRvalue = spec.getB().scalarMultiply(nonce);
            byte[] elementRarray = elementRvalue.toByteArray();
            System.arraycopy(elementRarray, 0, sm, 0, elementRarray.length);
            hash.reset();
            byte[] hram = hash.digest(sm);
            hram = scalar.reduce(hram);
            byte[] tt = scalar.multiplyAndAdd(hram, az, nonce);
            System.arraycopy(tt, 0, sm, 32, tt.length);
            return Arrays.copyOfRange(sm, 0, 64);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SQLException("Could not use SHA-512, failing", e);
        }
        catch (UnsupportedEncodingException use) {
            throw new SQLException("Unsupported encoding '" + passwordCharacterEncoding + "' (option passwordCharacterEncoding)", use);
        }
    }

    @Override
    public String name() {
        return "Ed25519 authentication plugin";
    }

    @Override
    public String type() {
        return "client_ed25519";
    }

    @Override
    public void initialize(String authenticationData, byte[] seed, Options options) {
        this.seed = seed;
        this.authenticationData = authenticationData;
        this.passwordCharacterEncoding = options.passwordCharacterEncoding;
    }

    @Override
    public Buffer process(PacketOutputStream out, PacketInputStream in, AtomicInteger sequence) throws IOException, SQLException {
        if (this.authenticationData == null || this.authenticationData.isEmpty()) {
            out.writeEmptyPacket(sequence.incrementAndGet());
        } else {
            out.startPacket(sequence.incrementAndGet());
            out.write(Ed25519PasswordPlugin.ed25519SignWithPassword(this.authenticationData, this.seed, this.passwordCharacterEncoding));
            out.flush();
        }
        Buffer buffer = in.getPacket(true);
        sequence.set(in.getLastPacketSeq());
        return buffer;
    }
}

