/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.lib.mariadb.internal.com.send.authentication;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicInteger;
import me.lucko.luckperms.lib.mariadb.authentication.AuthenticationPlugin;
import me.lucko.luckperms.lib.mariadb.internal.com.read.Buffer;
import me.lucko.luckperms.lib.mariadb.internal.com.send.authentication.gssapi.GssUtility;
import me.lucko.luckperms.lib.mariadb.internal.com.send.authentication.gssapi.GssapiAuth;
import me.lucko.luckperms.lib.mariadb.internal.com.send.authentication.gssapi.StandardGssapiAuthentication;
import me.lucko.luckperms.lib.mariadb.internal.io.input.PacketInputStream;
import me.lucko.luckperms.lib.mariadb.internal.io.output.PacketOutputStream;
import me.lucko.luckperms.lib.mariadb.util.Options;

public class SendGssApiAuthPacket
implements AuthenticationPlugin {
    private static final GssapiAuth gssapiAuth;
    private byte[] seed;
    private String optionServicePrincipalName;

    @Override
    public String name() {
        return "GSSAPI client authentication";
    }

    @Override
    public String type() {
        return "auth_gssapi_client";
    }

    @Override
    public void initialize(String authenticationData, byte[] seed, Options options) {
        this.seed = seed;
        this.optionServicePrincipalName = options.servicePrincipalName;
    }

    @Override
    public Buffer process(PacketOutputStream out, PacketInputStream in, AtomicInteger sequence) throws IOException, SQLException {
        Buffer buffer = new Buffer(this.seed);
        String serverSpn = buffer.readStringNullEnd(StandardCharsets.UTF_8);
        String servicePrincipalName = this.optionServicePrincipalName != null && !this.optionServicePrincipalName.isEmpty() ? this.optionServicePrincipalName : serverSpn;
        String mechanisms = buffer.readStringNullEnd(StandardCharsets.UTF_8);
        if (mechanisms.isEmpty()) {
            mechanisms = "Kerberos";
        }
        gssapiAuth.authenticate(out, in, sequence, servicePrincipalName, mechanisms);
        buffer = in.getPacket(true);
        sequence.set(in.getLastPacketSeq());
        return buffer;
    }

    static {
        GssapiAuth init;
        try {
            init = GssUtility.getAuthenticationMethod();
        }
        catch (Throwable t) {
            init = new StandardGssapiAuthentication();
        }
        gssapiAuth = init;
    }
}

