/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.lib.mariadb.internal.protocol;

import java.sql.SQLException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLTransientConnectionException;
import java.util.List;
import java.util.concurrent.Callable;
import me.lucko.luckperms.lib.mariadb.internal.com.read.dao.Results;
import me.lucko.luckperms.lib.mariadb.internal.com.send.ComStmtPrepare;
import me.lucko.luckperms.lib.mariadb.internal.com.send.parameters.ParameterHolder;
import me.lucko.luckperms.lib.mariadb.internal.protocol.AbstractMultiSend;
import me.lucko.luckperms.lib.mariadb.internal.protocol.AsyncMultiReadResult;
import me.lucko.luckperms.lib.mariadb.internal.protocol.Protocol;
import me.lucko.luckperms.lib.mariadb.internal.util.BulkStatus;
import me.lucko.luckperms.lib.mariadb.internal.util.SqlStates;
import me.lucko.luckperms.lib.mariadb.internal.util.dao.PrepareResult;

public class AsyncMultiRead
implements Callable<AsyncMultiReadResult> {
    private final ComStmtPrepare comStmtPrepare;
    private final BulkStatus status;
    private final int sendCmdInitialCounter;
    private final Protocol protocol;
    private final boolean readPrepareStmtResult;
    private final AbstractMultiSend bulkSend;
    private final List<ParameterHolder[]> parametersList;
    private final List<String> queries;
    private final Results results;
    private final int paramCount;
    private final AsyncMultiReadResult asyncMultiReadResult;

    public AsyncMultiRead(ComStmtPrepare comStmtPrepare, BulkStatus status, Protocol protocol, boolean readPrepareStmtResult, AbstractMultiSend bulkSend, int paramCount, Results results, List<ParameterHolder[]> parametersList, List<String> queries, PrepareResult prepareResult) {
        this.comStmtPrepare = comStmtPrepare;
        this.status = status;
        this.sendCmdInitialCounter = status.sendCmdCounter - 1;
        this.protocol = protocol;
        this.readPrepareStmtResult = readPrepareStmtResult;
        this.bulkSend = bulkSend;
        this.paramCount = paramCount;
        this.results = results;
        this.parametersList = parametersList;
        this.queries = queries;
        this.asyncMultiReadResult = new AsyncMultiReadResult(prepareResult);
    }

    @Override
    public AsyncMultiReadResult call() throws Exception {
        int initialTimeout = this.protocol.getTimeout();
        if (initialTimeout != 0) {
            this.protocol.changeSocketSoTimeout(0);
        }
        if (this.readPrepareStmtResult) {
            try {
                this.asyncMultiReadResult.setPrepareResult(this.comStmtPrepare.read(this.protocol.getReader(), this.protocol.isEofDeprecated()));
            }
            catch (SQLException queryException) {
                this.asyncMultiReadResult.setException(queryException);
            }
        }
        int counter = 0;
        block4: while (!this.status.sendEnded || counter < this.status.sendSubCmdCounter) {
            while (counter < this.status.sendSubCmdCounter) {
                block10: {
                    try {
                        this.protocol.getResult(this.results);
                    }
                    catch (SQLException qex) {
                        if (qex instanceof SQLNonTransientConnectionException || qex instanceof SQLTransientConnectionException) {
                            this.asyncMultiReadResult.setException(qex);
                            break block4;
                        }
                        if (this.asyncMultiReadResult.getException() != null) break block10;
                        this.asyncMultiReadResult.setException(this.bulkSend.handleResultException(qex, this.results, this.parametersList, this.queries, counter, this.sendCmdInitialCounter, this.paramCount, this.asyncMultiReadResult.getPrepareResult()));
                    }
                }
                ++counter;
                if (!Thread.currentThread().isInterrupted()) continue;
                this.asyncMultiReadResult.setException(new SQLException("Interrupted reading responses ", SqlStates.INTERRUPTED_EXCEPTION.getSqlState(), -1));
                continue block4;
            }
        }
        if (initialTimeout != 0) {
            this.protocol.changeSocketSoTimeout(initialTimeout);
        }
        return this.asyncMultiReadResult;
    }
}

