/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.lib.mariadb.internal.protocol;

import java.io.Closeable;
import java.sql.SQLException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import me.lucko.luckperms.lib.mariadb.HostAddress;
import me.lucko.luckperms.lib.mariadb.UrlParser;
import me.lucko.luckperms.lib.mariadb.internal.failover.FailoverProxy;
import me.lucko.luckperms.lib.mariadb.internal.failover.Listener;
import me.lucko.luckperms.lib.mariadb.internal.failover.tools.SearchFilter;
import me.lucko.luckperms.lib.mariadb.internal.io.LruTraceCache;
import me.lucko.luckperms.lib.mariadb.internal.protocol.AbstractQueryProtocol;
import me.lucko.luckperms.lib.mariadb.internal.util.pool.GlobalStateInfo;

public class MasterProtocol
extends AbstractQueryProtocol
implements Closeable {
    public MasterProtocol(UrlParser urlParser, GlobalStateInfo globalInfo, ReentrantLock lock, LruTraceCache traceCache) {
        super(urlParser, globalInfo, lock, traceCache);
    }

    private static MasterProtocol getNewProtocol(FailoverProxy proxy, GlobalStateInfo globalInfo, UrlParser urlParser) {
        MasterProtocol newProtocol = new MasterProtocol(urlParser, globalInfo, proxy.lock, proxy.traceCache);
        newProtocol.setProxy(proxy);
        return newProtocol;
    }

    public static void loop(Listener listener, GlobalStateInfo globalInfo, List<HostAddress> addresses, SearchFilter searchFilter) throws SQLException {
        ArrayDeque<HostAddress> loopAddresses = new ArrayDeque<HostAddress>(addresses);
        if (loopAddresses.isEmpty()) {
            MasterProtocol.resetHostList(listener, loopAddresses);
        }
        int maxConnectionTry = listener.getRetriesAllDown();
        boolean firstLoop = true;
        Throwable lastQueryException = null;
        while (!loopAddresses.isEmpty() || !searchFilter.isFailoverLoop() && maxConnectionTry > 0) {
            MasterProtocol protocol = MasterProtocol.getNewProtocol(listener.getProxy(), globalInfo, listener.getUrlParser());
            if (listener.isExplicitClosed()) {
                return;
            }
            --maxConnectionTry;
            try {
                HostAddress host = loopAddresses.pollFirst();
                if (host == null) {
                    loopAddresses.addAll(listener.getUrlParser().getHostAddresses());
                    host = loopAddresses.pollFirst();
                }
                protocol.setHostAddress(host);
                protocol.connect();
                if (listener.isExplicitClosed()) {
                    protocol.close();
                    return;
                }
                listener.removeFromBlacklist(protocol.getHostAddress());
                listener.foundActiveMaster(protocol);
                return;
            }
            catch (SQLException e) {
                listener.addToBlacklist(protocol.getHostAddress());
                lastQueryException = e;
                if (!loopAddresses.isEmpty() || searchFilter.isFailoverLoop() || maxConnectionTry <= 0) continue;
                MasterProtocol.resetHostList(listener, loopAddresses);
                if (firstLoop) {
                    firstLoop = false;
                    continue;
                }
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (lastQueryException != null) {
            throw new SQLException("No active connection found for master : " + lastQueryException.getMessage(), ((SQLException)lastQueryException).getSQLState(), ((SQLException)lastQueryException).getErrorCode(), lastQueryException);
        }
        throw new SQLException("No active connection found for master");
    }

    private static void resetHostList(Listener listener, Deque<HostAddress> loopAddresses) {
        ArrayList<HostAddress> servers = new ArrayList<HostAddress>();
        servers.addAll(listener.getUrlParser().getHostAddresses());
        Collections.shuffle(servers);
        loopAddresses.clear();
        loopAddresses.addAll(servers);
    }
}

