/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.lib.mariadb.internal.util;

import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;
import me.lucko.luckperms.lib.mariadb.internal.protocol.Protocol;
import me.lucko.luckperms.lib.mariadb.internal.util.dao.ServerPrepareResult;

public final class ServerPrepareStatementCache
extends LinkedHashMap<String, ServerPrepareResult> {
    private final int maxSize;
    private final Protocol protocol;

    private ServerPrepareStatementCache(int size, Protocol protocol) {
        super(size, 0.75f, true);
        this.maxSize = size;
        this.protocol = protocol;
    }

    public static ServerPrepareStatementCache newInstance(int size, Protocol protocol) {
        return new ServerPrepareStatementCache(size, protocol);
    }

    @Override
    public boolean removeEldestEntry(Map.Entry eldest) {
        boolean mustBeRemoved;
        boolean bl = mustBeRemoved = this.size() > this.maxSize;
        if (mustBeRemoved) {
            ServerPrepareResult serverPrepareResult = (ServerPrepareResult)eldest.getValue();
            serverPrepareResult.setRemoveFromCache();
            if (serverPrepareResult.canBeDeallocate()) {
                try {
                    this.protocol.forceReleasePrepareStatement(serverPrepareResult.getStatementId());
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
        return mustBeRemoved;
    }

    @Override
    public synchronized ServerPrepareResult put(String key, ServerPrepareResult result) {
        ServerPrepareResult cachedServerPrepareResult = (ServerPrepareResult)super.get(key);
        if (cachedServerPrepareResult != null && cachedServerPrepareResult.incrementShareCounter()) {
            return cachedServerPrepareResult;
        }
        result.setAddToCache();
        super.put(key, result);
        return null;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("ServerPrepareStatementCache.map[");
        for (Map.Entry entry : this.entrySet()) {
            stringBuilder.append("\n").append((String)entry.getKey()).append("-").append(((ServerPrepareResult)entry.getValue()).getShareCounter());
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

