#!/bin/sh

ServerName="Omnifactory"
CPUMask="0x30"

export PUBLIC_IP=`dig @resolver4.opendns.com myip.opendns.com +short`
export PORT_NUM=9011

echo ${PUBLIC_IP}
echo ${PORT_NUM}

# Run the server with the specified affinity
taskset -a "${CPUMask}" java \
    -Xms4G -Xmx15G -XX:+UseG1GC -XX:+UnlockExperimentalVMOptions -XX:MaxGCPauseMillis=100 -XX:+DisableExplicitGC \
    -XX:TargetSurvivorRatio=90 -XX:G1NewSizePercent=50 -XX:G1MaxNewSizePercent=80 \
    -XX:G1MixedGCLiveThresholdPercent=35 -XX:+AlwaysPreTouch -XX:+ParallelRefProcEnabled -Dfml.doNotBackup=true \
    -Dusing.aikars.flags=mcflags.emc.gs -XX:G1MixedGCLiveThresholdPercent=50 -XX:+AggressiveOpts \
    -XX:+UseLargePagesInMetaspace -jar "${ServerName}.jar" nogui

#java \
#    -Xms8G -Xmx16G -XX:+UseG1GC -XX:+ParallelRefProcEnabled -XX:MaxGCPauseMillis=200 -XX:+UnlockExperimentalVMOptions \
#    -XX:+DisableExplicitGC -XX:+AlwaysPreTouch -XX:G1NewSizePercent=40 -XX:G1MaxNewSizePercent=50 -Dlog4j2.formatMsgNoLookups=true \
#    -XX:G1HeapRegionSize=16M -XX:G1ReservePercent=15 -XX:G1HeapWastePercent=5 -XX:G1MixedGCCountTarget=4 \
#    -XX:InitiatingHeapOccupancyPercent=20 -XX:G1MixedGCLiveThresholdPercent=90 -XX:G1RSetUpdatingPauseTimePercent=5 \
#    -XX:SurvivorRatio=32 -XX:+PerfDisableSharedMem -XX:MaxTenuringThreshold=1 -Dusing.aikars.flags=https://mcflags.emc.gs -Daikars.new.flags=true \
#     -jar "${ServerName}.jar" nogui
