/*
 Highcharts JS v7.1.2 (2019-06-03)

 Highmaps as a plugin for Highcharts or Highstock.

 (c) 2011-2019 Torstein Honsi

 License: www.highcharts.com/license
*/
(function(h){"object"===typeof module&&module.exports?(h["default"]=h,module.exports=h):"function"===typeof define&&define.amd?define("highcharts/modules/map",["highcharts"],function(z){h(z);h.Highcharts=z;return h}):h("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(h){function z(a,h,k,r){a.hasOwnProperty(h)||(a[h]=r.apply(null,k))}h=h?h._modules:{};z(h,"parts-map/MapAxis.js",[h["parts/Globals.js"]],function(a){var h=a.addEvent,k=a.Axis,r=a.pick;h(k,"getSeriesExtremes",function(){var a=
[];this.isXAxis&&(this.series.forEach(function(f,q){f.useMapGeometry&&(a[q]=f.xData,f.xData=[])}),this.seriesXData=a)});h(k,"afterGetSeriesExtremes",function(){var a=this.seriesXData,f,u,k;this.isXAxis&&(f=r(this.dataMin,Number.MAX_VALUE),u=r(this.dataMax,-Number.MAX_VALUE),this.series.forEach(function(e,b){e.useMapGeometry&&(f=Math.min(f,r(e.minX,f)),u=Math.max(u,r(e.maxX,u)),e.xData=a[b],k=!0)}),k&&(this.dataMin=f,this.dataMax=u),delete this.seriesXData)});h(k,"afterSetAxisTranslation",function(){var a=
this.chart,f;f=a.plotWidth/a.plotHeight;var a=a.xAxis[0],k;"yAxis"===this.coll&&void 0!==a.transA&&this.series.forEach(function(a){a.preserveAspectRatio&&(k=!0)});if(k&&(this.transA=a.transA=Math.min(this.transA,a.transA),f/=(a.max-a.min)/(this.max-this.min),f=1>f?this:a,a=(f.max-f.min)*f.transA,f.pixelPadding=f.len-a,f.minPixelPadding=f.pixelPadding/2,a=f.fixTo)){a=a[1]-f.toValue(a[0],!0);a*=f.transA;if(Math.abs(a)>f.minPixelPadding||f.min===f.dataMin&&f.max===f.dataMax)a=0;f.minPixelPadding-=a}});
h(k,"render",function(){this.fixTo=null})});z(h,"parts-map/ColorAxis.js",[h["parts/Globals.js"]],function(a){var h=a.addEvent,k=a.Axis,r=a.Chart,q=a.color,f,u=a.extend,x=a.isNumber,e=a.Legend,b=a.LegendSymbolMixin,d=a.noop,y=a.merge,p=a.pick;f=a.ColorAxis=function(){this.init.apply(this,arguments)};u(f.prototype,k.prototype);u(f.prototype,{defaultColorAxisOptions:{lineWidth:0,minPadding:0,maxPadding:0,gridLineWidth:1,tickPixelInterval:72,startOnTick:!0,endOnTick:!0,offset:0,marker:{animation:{duration:50},
width:.01,color:"#999999"},labels:{overflow:"justify",rotation:0},minColor:"#e6ebf5",maxColor:"#003399",tickLength:5,showInLegend:!0},keepProps:["legendGroup","legendItemHeight","legendItemWidth","legendItem","legendSymbol"].concat(k.prototype.keepProps),init:function(c,g){var m="vertical"!==c.options.legend.layout,a;this.coll="colorAxis";a=this.buildOptions.call(c,this.defaultColorAxisOptions,g);k.prototype.init.call(this,c,a);g.dataClasses&&this.initDataClasses(g);this.initStops();this.horiz=m;
this.zoomEnabled=!1;this.defaultLegendLength=200},initDataClasses:function(c){var g=this.chart,m,a=0,l=g.options.chart.colorCount,n=this.options,b=c.dataClasses.length;this.dataClasses=m=[];this.legendItems=[];c.dataClasses.forEach(function(c,w){c=y(c);m.push(c);if(g.styledMode||!c.color)"category"===n.dataClassColor?(g.styledMode||(w=g.options.colors,l=w.length,c.color=w[a]),c.colorIndex=a,a++,a===l&&(a=0)):c.color=q(n.minColor).tweenTo(q(n.maxColor),2>b?.5:w/(b-1))})},hasData:function(){return!(!this.tickPositions||
!this.tickPositions.length)},setTickPositions:function(){if(!this.dataClasses)return k.prototype.setTickPositions.call(this)},initStops:function(){this.stops=this.options.stops||[[0,this.options.minColor],[1,this.options.maxColor]];this.stops.forEach(function(c){c.color=q(c[1])})},buildOptions:function(c,g){var a=this.options.legend,b="vertical"!==a.layout;return y(c,{side:b?2:1,reversed:!b},g,{opposite:!b,showEmpty:!1,title:null,visible:a.enabled})},setOptions:function(c){k.prototype.setOptions.call(this,
c);this.options.crosshair=this.options.marker},setAxisSize:function(){var c=this.legendSymbol,g=this.chart,a=g.options.legend||{},b,l;c?(this.left=a=c.attr("x"),this.top=b=c.attr("y"),this.width=l=c.attr("width"),this.height=c=c.attr("height"),this.right=g.chartWidth-a-l,this.bottom=g.chartHeight-b-c,this.len=this.horiz?l:c,this.pos=this.horiz?a:b):this.len=(this.horiz?a.symbolWidth:a.symbolHeight)||this.defaultLegendLength},normalizedValue:function(c){this.isLog&&(c=this.val2lin(c));return 1-(this.max-
c)/(this.max-this.min||1)},toColor:function(c,g){var a=this.stops,b,l,n=this.dataClasses,w,d;if(n)for(d=n.length;d--;){if(w=n[d],b=w.from,a=w.to,(void 0===b||c>=b)&&(void 0===a||c<=a)){l=w.color;g&&(g.dataClass=d,g.colorIndex=w.colorIndex);break}}else{c=this.normalizedValue(c);for(d=a.length;d--&&!(c>a[d][0]););b=a[d]||a[d+1];a=a[d+1]||b;c=1-(a[0]-c)/(a[0]-b[0]||1);l=b.color.tweenTo(a.color,c)}return l},getOffset:function(){var c=this.legendGroup,g=this.chart.axisOffset[this.side];c&&(this.axisParent=
c,k.prototype.getOffset.call(this),this.added||(this.added=!0,this.labelLeft=0,this.labelRight=this.width),this.chart.axisOffset[this.side]=g)},setLegendColor:function(){var c,g=this.reversed;c=g?1:0;g=g?0:1;c=this.horiz?[c,0,g,0]:[0,g,0,c];this.legendColor={linearGradient:{x1:c[0],y1:c[1],x2:c[2],y2:c[3]},stops:this.stops}},drawLegendSymbol:function(c,g){var a=c.padding,b=c.options,l=this.horiz,n=p(b.symbolWidth,l?this.defaultLegendLength:12),w=p(b.symbolHeight,l?12:this.defaultLegendLength),d=p(b.labelPadding,
l?16:30),b=p(b.itemDistance,10);this.setLegendColor();g.legendSymbol=this.chart.renderer.rect(0,c.baseline-11,n,w).attr({zIndex:1}).add(g.legendGroup);this.legendItemWidth=n+a+(l?b:d);this.legendItemHeight=w+a+(l?d:0)},setState:function(c){this.series.forEach(function(g){g.setState(c)})},visible:!0,setVisible:d,getSeriesExtremes:function(){var c=this.series,g=c.length;this.dataMin=Infinity;for(this.dataMax=-Infinity;g--;)c[g].getExtremes(),void 0!==c[g].valueMin&&(this.dataMin=Math.min(this.dataMin,
c[g].valueMin),this.dataMax=Math.max(this.dataMax,c[g].valueMax))},drawCrosshair:function(c,g){var a=g&&g.plotX,b=g&&g.plotY,l,n=this.pos,w=this.len;g&&(l=this.toPixels(g[g.series.colorKey]),l<n?l=n-2:l>n+w&&(l=n+w+2),g.plotX=l,g.plotY=this.len-l,k.prototype.drawCrosshair.call(this,c,g),g.plotX=a,g.plotY=b,this.cross&&!this.cross.addedToColorAxis&&this.legendGroup&&(this.cross.addClass("highcharts-coloraxis-marker").add(this.legendGroup),this.cross.addedToColorAxis=!0,this.chart.styledMode||this.cross.attr({fill:this.crosshair.color})))},
getPlotLinePath:function(c){var g=c.translatedValue;return x(g)?this.horiz?["M",g-4,this.top-6,"L",g+4,this.top-6,g,this.top,"Z"]:["M",this.left,g,"L",this.left-6,g+6,this.left-6,g-6,"Z"]:k.prototype.getPlotLinePath.apply(this,arguments)},update:function(c,g){var a=this.chart,b=a.legend,l=this.buildOptions.call(a,{},c);this.series.forEach(function(c){c.isDirtyData=!0});c.dataClasses&&b.allItems&&(b.allItems.forEach(function(c){c.isDataClass&&c.legendGroup&&c.legendGroup.destroy()}),a.isDirtyLegend=
!0);a.options[this.coll]=y(this.userOptions,l);k.prototype.update.call(this,l,g);this.legendItem&&(this.setLegendColor(),b.colorizeItem(this,!0))},remove:function(){this.legendItem&&this.chart.legend.destroyItem(this);k.prototype.remove.call(this)},getDataClassLegendSymbols:function(){var c=this,g=this.chart,m=this.legendItems,e=g.options.legend,l=e.valueDecimals,n=e.valueSuffix||"",w;m.length||this.dataClasses.forEach(function(e,v){var A=!0,f=e.from,t=e.to;w="";void 0===f?w="\x3c ":void 0===t&&(w=
"\x3e ");void 0!==f&&(w+=a.numberFormat(f,l)+n);void 0!==f&&void 0!==t&&(w+=" - ");void 0!==t&&(w+=a.numberFormat(t,l)+n);m.push(u({chart:g,name:w,options:{},drawLegendSymbol:b.drawRectangle,visible:!0,setState:d,isDataClass:!0,setVisible:function(){A=this.visible=!A;c.series.forEach(function(c){c.points.forEach(function(c){c.dataClass===v&&c.setVisible(A)})});g.legend.colorizeItem(this,A)}},e))});return m},name:""});["fill","stroke"].forEach(function(c){a.Fx.prototype[c+"Setter"]=function(){this.elem.attr(c,
q(this.start).tweenTo(q(this.end),this.pos),null,!0)}});h(r,"afterGetAxes",function(){var c=this.options.colorAxis;this.colorAxis=[];c&&new f(this,c)});h(e,"afterGetAllItems",function(c){var g=[],b=this.chart.colorAxis[0];b&&b.options&&b.options.showInLegend&&(b.options.dataClasses?g=b.getDataClassLegendSymbols():g.push(b),b.series.forEach(function(g){a.erase(c.allItems,g)}));for(b=g.length;b--;)c.allItems.unshift(g[b])});h(e,"afterColorizeItem",function(c){c.visible&&c.item.legendColor&&c.item.legendSymbol.attr({fill:c.item.legendColor})});
h(e,"afterUpdate",function(c,a,b){this.chart.colorAxis[0]&&this.chart.colorAxis[0].update({},b)})});z(h,"parts-map/ColorSeriesMixin.js",[h["parts/Globals.js"]],function(a){var h=a.defined,k=a.noop,r=a.seriesTypes;a.colorPointMixin={dataLabelOnNull:!0,isValid:function(){return null!==this.value&&Infinity!==this.value&&-Infinity!==this.value},setVisible:function(a){var f=this,q=a?"show":"hide";f.visible=!!a;["graphic","dataLabel"].forEach(function(a){if(f[a])f[a][q]()})},setState:function(q){a.Point.prototype.setState.call(this,
q);this.graphic&&this.graphic.attr({zIndex:"hover"===q?1:0})}};a.colorSeriesMixin={pointArrayMap:["value"],axisTypes:["xAxis","yAxis","colorAxis"],optionalAxis:"colorAxis",trackerGroups:["group","markerGroup","dataLabelsGroup"],getSymbol:k,parallelArrays:["x","y","value"],colorKey:"value",pointAttribs:r.column.prototype.pointAttribs,translateColors:function(){var a=this,f=this.options.nullColor,k=this.colorAxis,h=this.colorKey;this.data.forEach(function(e){var b=e[h];if(b=e.options.color||(e.isNull?
f:k&&void 0!==b?k.toColor(b,e):e.color||a.color))e.color=b})},colorAttribs:function(a){var f={};h(a.color)&&(f[this.colorProp||"fill"]=a.color);return f}}});z(h,"parts-map/MapNavigation.js",[h["parts/Globals.js"]],function(a){function h(a){a&&(a.preventDefault&&a.preventDefault(),a.stopPropagation&&a.stopPropagation(),a.cancelBubble=!0)}function k(a){this.init(a)}var r=a.addEvent,q=a.Chart,f=a.doc,u=a.extend,x=a.merge,e=a.pick;k.prototype.init=function(a){this.chart=a;a.mapNavButtons=[]};k.prototype.update=
function(b){var d=this.chart,f=d.options.mapNavigation,p,c,g,m,t,l=function(c){this.handler.call(d,c);h(c)},n=d.mapNavButtons;b&&(f=d.options.mapNavigation=x(d.options.mapNavigation,b));for(;n.length;)n.pop().destroy();e(f.enableButtons,f.enabled)&&!d.renderer.forExport&&a.objectEach(f.buttons,function(a,b){p=x(f.buttonOptions,a);d.styledMode||(c=p.theme,c.style=x(p.theme.style,p.style),m=(g=c.states)&&g.hover,t=g&&g.select);a=d.renderer.button(p.text,0,0,l,c,m,t,0,"zoomIn"===b?"topbutton":"bottombutton").addClass("highcharts-map-navigation highcharts-"+
{zoomIn:"zoom-in",zoomOut:"zoom-out"}[b]).attr({width:p.width,height:p.height,title:d.options.lang[b],padding:p.padding,zIndex:5}).add();a.handler=p.onclick;a.align(u(p,{width:a.width,height:2*a.height}),null,p.alignTo);r(a.element,"dblclick",h);n.push(a)});this.updateEvents(f)};k.prototype.updateEvents=function(a){var b=this.chart;e(a.enableDoubleClickZoom,a.enabled)||a.enableDoubleClickZoomTo?this.unbindDblClick=this.unbindDblClick||r(b.container,"dblclick",function(a){b.pointer.onContainerDblClick(a)}):
this.unbindDblClick&&(this.unbindDblClick=this.unbindDblClick());e(a.enableMouseWheelZoom,a.enabled)?this.unbindMouseWheel=this.unbindMouseWheel||r(b.container,void 0===f.onmousewheel?"DOMMouseScroll":"mousewheel",function(a){b.pointer.onContainerMouseWheel(a);h(a);return!1}):this.unbindMouseWheel&&(this.unbindMouseWheel=this.unbindMouseWheel())};u(q.prototype,{fitToBox:function(a,d){[["x","width"],["y","height"]].forEach(function(b){var e=b[0];b=b[1];a[e]+a[b]>d[e]+d[b]&&(a[b]>d[b]?(a[b]=d[b],a[e]=
d[e]):a[e]=d[e]+d[b]-a[b]);a[b]>d[b]&&(a[b]=d[b]);a[e]<d[e]&&(a[e]=d[e])});return a},mapZoom:function(a,d,f,q,c){var g=this.xAxis[0],b=g.max-g.min,t=e(d,g.min+b/2),l=b*a,b=this.yAxis[0],n=b.max-b.min,w=e(f,b.min+n/2),n=n*a,t=this.fitToBox({x:t-l*(q?(q-g.pos)/g.len:.5),y:w-n*(c?(c-b.pos)/b.len:.5),width:l,height:n},{x:g.dataMin,y:b.dataMin,width:g.dataMax-g.dataMin,height:b.dataMax-b.dataMin}),l=t.x<=g.dataMin&&t.width>=g.dataMax-g.dataMin&&t.y<=b.dataMin&&t.height>=b.dataMax-b.dataMin;q&&(g.fixTo=
[q-g.pos,d]);c&&(b.fixTo=[c-b.pos,f]);void 0===a||l?(g.setExtremes(void 0,void 0,!1),b.setExtremes(void 0,void 0,!1)):(g.setExtremes(t.x,t.x+t.width,!1),b.setExtremes(t.y,t.y+t.height,!1));this.redraw()}});r(q,"beforeRender",function(){this.mapNavigation=new k(this);this.mapNavigation.update()});a.MapNavigation=k});z(h,"parts-map/MapPointer.js",[h["parts/Globals.js"]],function(a){var h=a.extend,k=a.pick,r=a.Pointer;a=a.wrap;h(r.prototype,{onContainerDblClick:function(a){var f=this.chart;a=this.normalize(a);
f.options.mapNavigation.enableDoubleClickZoomTo?f.pointer.inClass(a.target,"highcharts-tracker")&&f.hoverPoint&&f.hoverPoint.zoomTo():f.isInsidePlot(a.chartX-f.plotLeft,a.chartY-f.plotTop)&&f.mapZoom(.5,f.xAxis[0].toValue(a.chartX),f.yAxis[0].toValue(a.chartY),a.chartX,a.chartY)},onContainerMouseWheel:function(a){var f=this.chart,h;a=this.normalize(a);h=a.detail||-(a.wheelDelta/120);f.isInsidePlot(a.chartX-f.plotLeft,a.chartY-f.plotTop)&&f.mapZoom(Math.pow(f.options.mapNavigation.mouseWheelSensitivity,
h),f.xAxis[0].toValue(a.chartX),f.yAxis[0].toValue(a.chartY),a.chartX,a.chartY)}});a(r.prototype,"zoomOption",function(a){var f=this.chart.options.mapNavigation;k(f.enableTouchZoom,f.enabled)&&(this.chart.options.chart.pinchType="xy");a.apply(this,[].slice.call(arguments,1))});a(r.prototype,"pinchTranslate",function(a,f,h,k,e,b,d){a.call(this,f,h,k,e,b,d);"map"===this.chart.options.chart.type&&this.hasZoom&&(a=k.scaleX>k.scaleY,this.pinchTranslateDirection(!a,f,h,k,e,b,d,a?k.scaleX:k.scaleY))})});
z(h,"parts-map/MapSeries.js",[h["parts/Globals.js"]],function(a){var h=a.colorPointMixin,k=a.extend,r=a.isNumber,q=a.merge,f=a.noop,u=a.pick,x=a.isArray,e=a.Point,b=a.Series,d=a.seriesType,y=a.seriesTypes,p=a.splat;d("map","scatter",{animation:!1,dataLabels:{crop:!1,formatter:function(){return this.point.value},inside:!0,overflow:!1,padding:0,verticalAlign:"middle"},marker:null,nullColor:"#f7f7f7",stickyTracking:!1,tooltip:{followPointer:!0,pointFormat:"{point.name}: {point.value}\x3cbr/\x3e"},turboThreshold:0,
allAreas:!0,borderColor:"#cccccc",borderWidth:1,joinBy:"hc-key",states:{hover:{halo:null,brightness:.2},normal:{animation:!0},select:{color:"#cccccc"},inactive:{opacity:1}}},q(a.colorSeriesMixin,{type:"map",getExtremesFromAll:!0,useMapGeometry:!0,forceDL:!0,searchPoint:f,directTouch:!0,preserveAspectRatio:!0,pointArrayMap:["value"],setOptions:function(a){a=b.prototype.setOptions.call(this,a);var c=a.joinBy;null===c&&(c="_i");c=this.joinBy=p(c);c[1]||(c[1]=c[0]);return a},getBox:function(c){var b=
Number.MAX_VALUE,d=-b,e=b,l=-b,n=b,w=b,f=this.xAxis,v=this.yAxis,h;(c||[]).forEach(function(c){if(c.path){"string"===typeof c.path&&(c.path=a.splitPath(c.path));var g=c.path||[],m=g.length,f=!1,v=-b,A=b,t=-b,k=b,B=c.properties;if(!c._foundBox){for(;m--;)r(g[m])&&(f?(v=Math.max(v,g[m]),A=Math.min(A,g[m])):(t=Math.max(t,g[m]),k=Math.min(k,g[m])),f=!f);c._midX=A+(v-A)*u(c.middleX,B&&B["hc-middle-x"],.5);c._midY=k+(t-k)*u(c.middleY,B&&B["hc-middle-y"],.5);c._maxX=v;c._minX=A;c._maxY=t;c._minY=k;c.labelrank=
u(c.labelrank,(v-A)*(t-k));c._foundBox=!0}d=Math.max(d,c._maxX);e=Math.min(e,c._minX);l=Math.max(l,c._maxY);n=Math.min(n,c._minY);w=Math.min(c._maxX-c._minX,c._maxY-c._minY,w);h=!0}});h&&(this.minY=Math.min(n,u(this.minY,b)),this.maxY=Math.max(l,u(this.maxY,-b)),this.minX=Math.min(e,u(this.minX,b)),this.maxX=Math.max(d,u(this.maxX,-b)),f&&void 0===f.options.minRange&&(f.minRange=Math.min(5*w,(this.maxX-this.minX)/5,f.minRange||b)),v&&void 0===v.options.minRange&&(v.minRange=Math.min(5*w,(this.maxY-
this.minY)/5,v.minRange||b)))},hasData:function(){return!!this.processedXData.length},getExtremes:function(){b.prototype.getExtremes.call(this,this.valueData);this.chart.hasRendered&&this.isDirtyData&&this.getBox(this.options.data);this.valueMin=this.dataMin;this.valueMax=this.dataMax;this.dataMin=this.minY;this.dataMax=this.maxY},translatePath:function(a){var c=!1,b=this.xAxis,d=this.yAxis,l=b.min,n=b.transA,b=b.minPixelPadding,w=d.min,e=d.transA,d=d.minPixelPadding,f,k=[];if(a)for(f=a.length;f--;)r(a[f])?
(k[f]=c?(a[f]-l)*n+b:(a[f]-w)*e+d,c=!c):k[f]=a[f];return k},setData:function(c,g,d,f){var l=this.options,n=this.chart.options.chart,e=n&&n.map,m=l.mapData,v=this.joinBy,t=l.keys||this.pointArrayMap,k=[],h={},p=this.chart.mapTransforms;!m&&e&&(m="string"===typeof e?a.maps[e]:e);c&&c.forEach(function(b,g){var n=0;if(r(b))c[g]={value:b};else if(x(b)){c[g]={};!l.keys&&b.length>t.length&&"string"===typeof b[0]&&(c[g]["hc-key"]=b[0],++n);for(var d=0;d<t.length;++d,++n)t[d]&&void 0!==b[n]&&(0<t[d].indexOf(".")?
a.Point.prototype.setNestedProperty(c[g],b[n],t[d]):c[g][t[d]]=b[n])}v&&"_i"===v[0]&&(c[g]._i=g)});this.getBox(c);(this.chart.mapTransforms=p=n&&n.mapTransforms||m&&m["hc-transform"]||p)&&a.objectEach(p,function(a){a.rotation&&(a.cosAngle=Math.cos(a.rotation),a.sinAngle=Math.sin(a.rotation))});if(m){"FeatureCollection"===m.type&&(this.mapTitle=m.title,m=a.geojson(m,this.type,this));this.mapData=m;this.mapMap={};for(p=0;p<m.length;p++)n=m[p],e=n.properties,n._i=p,v[0]&&e&&e[v[0]]&&(n[v[0]]=e[v[0]]),
h[n[v[0]]]=n;this.mapMap=h;c&&v[1]&&c.forEach(function(a){h[a[v[1]]]&&k.push(h[a[v[1]]])});l.allAreas?(this.getBox(m),c=c||[],v[1]&&c.forEach(function(a){k.push(a[v[1]])}),k="|"+k.map(function(a){return a&&a[v[0]]}).join("|")+"|",m.forEach(function(a){v[0]&&-1!==k.indexOf("|"+a[v[0]]+"|")||(c.push(q(a,{value:null})),f=!1)})):this.getBox(k)}b.prototype.setData.call(this,c,g,d,f)},drawGraph:f,drawDataLabels:f,doFullTranslate:function(){return this.isDirtyData||this.chart.isResizing||this.chart.renderer.isVML||
!this.baseTrans},translate:function(){var a=this,b=a.xAxis,d=a.yAxis,e=a.doFullTranslate();a.generatePoints();a.data.forEach(function(c){c.plotX=b.toPixels(c._midX,!0);c.plotY=d.toPixels(c._midY,!0);e&&(c.shapeType="path",c.shapeArgs={d:a.translatePath(c.path)})});a.translateColors()},pointAttribs:function(a,b){b=a.series.chart.styledMode?this.colorAttribs(a):y.column.prototype.pointAttribs.call(this,a,b);b["stroke-width"]=u(a.options[this.pointAttrToOptions&&this.pointAttrToOptions["stroke-width"]||
"borderWidth"],"inherit");return b},drawPoints:function(){var a=this,b=a.xAxis,d=a.yAxis,e=a.group,l=a.chart,n=l.renderer,f,A,v,k,h=this.baseTrans,p,r,q,x,G;a.transformGroup||(a.transformGroup=n.g().attr({scaleX:1,scaleY:1}).add(e),a.transformGroup.survive=!0);a.doFullTranslate()?(l.hasRendered&&!l.styledMode&&a.points.forEach(function(c){c.shapeArgs&&(c.shapeArgs.fill=a.pointAttribs(c,c.state).fill)}),a.group=a.transformGroup,y.column.prototype.drawPoints.apply(a),a.group=e,a.points.forEach(function(c){if(c.graphic){var b=
"";c.name&&(b+="highcharts-name-"+c.name.replace(/ /g,"-").toLowerCase());c.properties&&c.properties["hc-key"]&&(b+=" highcharts-key-"+c.properties["hc-key"].toLowerCase());b&&c.graphic.addClass(b);l.styledMode&&c.graphic.css(a.pointAttribs(c,c.selected&&"select"))}}),this.baseTrans={originX:b.min-b.minPixelPadding/b.transA,originY:d.min-d.minPixelPadding/d.transA+(d.reversed?0:d.len/d.transA),transAX:b.transA,transAY:d.transA},this.transformGroup.animate({translateX:0,translateY:0,scaleX:1,scaleY:1})):
(f=b.transA/h.transAX,A=d.transA/h.transAY,v=b.toPixels(h.originX,!0),k=d.toPixels(h.originY,!0),.99<f&&1.01>f&&.99<A&&1.01>A&&(A=f=1,v=Math.round(v),k=Math.round(k)),p=this.transformGroup,l.renderer.globalAnimation?(r=p.attr("translateX"),q=p.attr("translateY"),x=p.attr("scaleX"),G=p.attr("scaleY"),p.attr({animator:0}).animate({animator:1},{step:function(a,c){p.attr({translateX:r+(v-r)*c.pos,translateY:q+(k-q)*c.pos,scaleX:x+(f-x)*c.pos,scaleY:G+(A-G)*c.pos})}})):p.attr({translateX:v,translateY:k,
scaleX:f,scaleY:A}));l.styledMode||e.element.setAttribute("stroke-width",u(a.options[a.pointAttrToOptions&&a.pointAttrToOptions["stroke-width"]||"borderWidth"],1)/(f||1));this.drawMapDataLabels()},drawMapDataLabels:function(){b.prototype.drawDataLabels.call(this);this.dataLabelsGroup&&this.dataLabelsGroup.clip(this.chart.clipRect)},render:function(){var a=this,g=b.prototype.render;a.chart.renderer.isVML&&3E3<a.data.length?setTimeout(function(){g.call(a)}):g.call(a)},animate:function(a){var c=this.options.animation,
b=this.group,d=this.xAxis,l=this.yAxis,n=d.pos,e=l.pos;this.chart.renderer.isSVG&&(!0===c&&(c={duration:1E3}),a?b.attr({translateX:n+d.len/2,translateY:e+l.len/2,scaleX:.001,scaleY:.001}):(b.animate({translateX:n,translateY:e,scaleX:1,scaleY:1},c),this.animate=null))},animateDrilldown:function(a){var c=this.chart.plotBox,b=this.chart.drilldownLevels[this.chart.drilldownLevels.length-1],d=b.bBox,l=this.chart.options.drilldown.animation;a||(a=Math.min(d.width/c.width,d.height/c.height),b.shapeArgs=
{scaleX:a,scaleY:a,translateX:d.x,translateY:d.y},this.points.forEach(function(a){a.graphic&&a.graphic.attr(b.shapeArgs).animate({scaleX:1,scaleY:1,translateX:0,translateY:0},l)}),this.animate=null)},drawLegendSymbol:a.LegendSymbolMixin.drawRectangle,animateDrillupFrom:function(a){y.column.prototype.animateDrillupFrom.call(this,a)},animateDrillupTo:function(a){y.column.prototype.animateDrillupTo.call(this,a)}}),k({applyOptions:function(a,b){a=e.prototype.applyOptions.call(this,a,b);b=this.series;
var c=b.joinBy;b.mapData&&((c=void 0!==a[c[1]]&&b.mapMap[a[c[1]]])?(b.xyFromShape&&(a.x=c._midX,a.y=c._midY),k(a,c)):a.value=a.value||null);return a},onMouseOver:function(c){a.clearTimeout(this.colorInterval);if(null!==this.value||this.series.options.nullInteraction)e.prototype.onMouseOver.call(this,c);else this.series.onMouseOut(c)},zoomTo:function(){var a=this.series;a.xAxis.setExtremes(this._minX,this._maxX,!1);a.yAxis.setExtremes(this._minY,this._maxY,!1);a.chart.redraw()}},h))});z(h,"parts-map/MapLineSeries.js",
[h["parts/Globals.js"]],function(a){var h=a.seriesType,k=a.seriesTypes;h("mapline","map",{lineWidth:1,fillColor:"none"},{type:"mapline",colorProp:"stroke",pointAttrToOptions:{stroke:"color","stroke-width":"lineWidth"},pointAttribs:function(a,h){a=k.map.prototype.pointAttribs.call(this,a,h);a.fill=this.options.fillColor;return a},drawLegendSymbol:k.line.prototype.drawLegendSymbol})});z(h,"parts-map/MapPointSeries.js",[h["parts/Globals.js"]],function(a){var h=a.merge,k=a.Point;a=a.seriesType;a("mappoint",
"scatter",{dataLabels:{crop:!1,defer:!1,enabled:!0,formatter:function(){return this.point.name},overflow:!1,style:{color:"#000000"}}},{type:"mappoint",forceDL:!0},{applyOptions:function(a,q){a=void 0!==a.lat&&void 0!==a.lon?h(a,this.series.chart.fromLatLonToPoint(a)):a;return k.prototype.applyOptions.call(this,a,q)}})});z(h,"parts-more/BubbleLegend.js",[h["parts/Globals.js"]],function(a){var h=a.Series,k=a.Legend,r=a.Chart,q=a.addEvent,f=a.wrap,u=a.color,x=a.isNumber,e=a.numberFormat,b=a.objectEach,
d=a.merge,y=a.noop,p=a.pick,c=a.stableSort,g=a.setOptions,m=a.arrayMin,t=a.arrayMax;g({legend:{bubbleLegend:{borderColor:void 0,borderWidth:2,className:void 0,color:void 0,connectorClassName:void 0,connectorColor:void 0,connectorDistance:60,connectorWidth:1,enabled:!1,labels:{className:void 0,allowOverlap:!1,format:"",formatter:void 0,align:"right",style:{fontSize:10,color:void 0},x:0,y:0},maxSize:60,minSize:10,legendIndex:0,ranges:{value:void 0,borderColor:void 0,color:void 0,connectorColor:void 0},
sizeBy:"area",sizeByAbsoluteValue:!1,zIndex:1,zThreshold:0}}});a.BubbleLegend=function(a,b){this.init(a,b)};a.BubbleLegend.prototype={init:function(a,b){this.options=a;this.visible=!0;this.chart=b.chart;this.legend=b},setState:y,addToLegend:function(a){a.splice(this.options.legendIndex,0,this)},drawLegendSymbol:function(a){var b=this.chart,l=this.options,g=p(a.options.itemDistance,20),d,e=l.ranges;d=l.connectorDistance;this.fontMetrics=b.renderer.fontMetrics(l.labels.style.fontSize.toString()+"px");
e&&e.length&&x(e[0].value)?(c(e,function(a,b){return b.value-a.value}),this.ranges=e,this.setOptions(),this.render(),b=this.getMaxLabelSize(),e=this.ranges[0].radius,a=2*e,d=d-e+b.width,d=0<d?d:0,this.maxLabel=b,this.movementX="left"===l.labels.align?d:0,this.legendItemWidth=a+d+g,this.legendItemHeight=a+this.fontMetrics.h/2):a.options.bubbleLegend.autoRanges=!0},setOptions:function(){var a=this.ranges,b=this.options,c=this.chart.series[b.seriesIndex],g=this.legend.baseline,e={"z-index":b.zIndex,
"stroke-width":b.borderWidth},f={"z-index":b.zIndex,"stroke-width":b.connectorWidth},m=this.getLabelStyles(),k=c.options.marker.fillOpacity,h=this.chart.styledMode;a.forEach(function(l,n){h||(e.stroke=p(l.borderColor,b.borderColor,c.color),e.fill=p(l.color,b.color,1!==k?u(c.color).setOpacity(k).get("rgba"):c.color),f.stroke=p(l.connectorColor,b.connectorColor,c.color));a[n].radius=this.getRangeRadius(l.value);a[n]=d(a[n],{center:a[0].radius-a[n].radius+g});h||d(!0,a[n],{bubbleStyle:d(!1,e),connectorStyle:d(!1,
f),labelStyle:m})},this)},getLabelStyles:function(){var a=this.options,c={},g="left"===a.labels.align,e=this.legend.options.rtl;b(a.labels.style,function(a,b){"color"!==b&&"fontSize"!==b&&"z-index"!==b&&(c[b]=a)});return d(!1,c,{"font-size":a.labels.style.fontSize,fill:p(a.labels.style.color,"#000000"),"z-index":a.zIndex,align:e||g?"right":"left"})},getRangeRadius:function(a){var b=this.options;return this.chart.series[this.options.seriesIndex].getRadius.call(this,b.ranges[b.ranges.length-1].value,
b.ranges[0].value,b.minSize,b.maxSize,a)},render:function(){var a=this.chart.renderer,b=this.options.zThreshold;this.symbols||(this.symbols={connectors:[],bubbleItems:[],labels:[]});this.legendSymbol=a.g("bubble-legend");this.legendItem=a.g("bubble-legend-item");this.legendSymbol.translateX=0;this.legendSymbol.translateY=0;this.ranges.forEach(function(a){a.value>=b&&this.renderRange(a)},this);this.legendSymbol.add(this.legendItem);this.legendItem.add(this.legendGroup);this.hideOverlappingLabels()},
renderRange:function(a){var b=this.options,c=b.labels,g=this.chart.renderer,d=this.symbols,l=d.labels,e=a.center,f=Math.abs(a.radius),m=b.connectorDistance,k=c.align,h=c.style.fontSize,m=this.legend.options.rtl||"left"===k?-m:m,c=b.connectorWidth,t=this.ranges[0].radius,p=e-f-b.borderWidth/2+c/2,y,h=h/2-(this.fontMetrics.h-h)/2,q=g.styledMode;"center"===k&&(m=0,b.connectorDistance=0,a.labelStyle.align="center");k=p+b.labels.y;y=t+m+b.labels.x;d.bubbleItems.push(g.circle(t,e+((p%1?1:.5)-(c%2?0:.5)),
f).attr(q?{}:a.bubbleStyle).addClass((q?"highcharts-color-"+this.options.seriesIndex+" ":"")+"highcharts-bubble-legend-symbol "+(b.className||"")).add(this.legendSymbol));d.connectors.push(g.path(g.crispLine(["M",t,p,"L",t+m,p],b.connectorWidth)).attr(q?{}:a.connectorStyle).addClass((q?"highcharts-color-"+this.options.seriesIndex+" ":"")+"highcharts-bubble-legend-connectors "+(b.connectorClassName||"")).add(this.legendSymbol));a=g.text(this.formatLabel(a),y,k+h).attr(q?{}:a.labelStyle).addClass("highcharts-bubble-legend-labels "+
(b.labels.className||"")).add(this.legendSymbol);l.push(a);a.placed=!0;a.alignAttr={x:y,y:k+h}},getMaxLabelSize:function(){var a,b;this.symbols.labels.forEach(function(c){b=c.getBBox(!0);a=a?b.width>a.width?b:a:b});return a||{}},formatLabel:function(b){var c=this.options,g=c.labels.formatter;return(c=c.labels.format)?a.format(c,b):g?g.call(b):e(b.value,1)},hideOverlappingLabels:function(){var a=this.chart,b=this.symbols;!this.options.labels.allowOverlap&&b&&(a.hideOverlappingLabels(b.labels),b.labels.forEach(function(a,
c){a.newOpacity?a.newOpacity!==a.oldOpacity&&b.connectors[c].show():b.connectors[c].hide()}))},getRanges:function(){var a=this.legend.bubbleLegend,b,c=a.options.ranges,g,e=Number.MAX_VALUE,f=-Number.MAX_VALUE;a.chart.series.forEach(function(a){a.isBubble&&!a.ignoreSeries&&(g=a.zData.filter(x),g.length&&(e=p(a.options.zMin,Math.min(e,Math.max(m(g),!1===a.options.displayNegative?a.options.zThreshold:-Number.MAX_VALUE))),f=p(a.options.zMax,Math.max(f,t(g)))))});b=e===f?[{value:f}]:[{value:e},{value:(e+
f)/2},{value:f,autoRanges:!0}];c.length&&c[0].radius&&b.reverse();b.forEach(function(a,g){c&&c[g]&&(b[g]=d(!1,c[g],a))});return b},predictBubbleSizes:function(){var a=this.chart,b=this.fontMetrics,c=a.legend.options,g="horizontal"===c.layout,d=g?a.legend.lastLineHeight:0,e=a.plotSizeX,f=a.plotSizeY,m=a.series[this.options.seriesIndex],a=Math.ceil(m.minPxSize),k=Math.ceil(m.maxPxSize),m=m.options.maxSize,h=Math.min(f,e);if(c.floating||!/%$/.test(m))b=k;else if(m=parseFloat(m),b=(h+d-b.h/2)*m/100/(m/
100+1),g&&f-b>=e||!g&&e-b>=f)b=k;return[a,Math.ceil(b)]},updateRanges:function(a,b){var c=this.legend.options.bubbleLegend;c.minSize=a;c.maxSize=b;c.ranges=this.getRanges()},correctSizes:function(){var a=this.legend,b=this.chart.series[this.options.seriesIndex];1<Math.abs(Math.ceil(b.maxPxSize)-this.options.maxSize)&&(this.updateRanges(this.options.minSize,b.maxPxSize),a.render())}};q(a.Legend,"afterGetAllItems",function(b){var c=this.bubbleLegend,g=this.options,d=g.bubbleLegend,e=this.chart.getVisibleBubbleSeriesIndex();
c&&c.ranges&&c.ranges.length&&(d.ranges.length&&(d.autoRanges=!!d.ranges[0].autoRanges),this.destroyItem(c));0<=e&&g.enabled&&d.enabled&&(d.seriesIndex=e,this.bubbleLegend=new a.BubbleLegend(d,this),this.bubbleLegend.addToLegend(b.allItems))});r.prototype.getVisibleBubbleSeriesIndex=function(){for(var a=this.series,b=0;b<a.length;){if(a[b]&&a[b].isBubble&&a[b].visible&&a[b].zData.length)return b;b++}return-1};k.prototype.getLinesHeights=function(){var a=this.allItems,b=[],c,g=a.length,d,e=0;for(d=
0;d<g;d++)if(a[d].legendItemHeight&&(a[d].itemHeight=a[d].legendItemHeight),a[d]===a[g-1]||a[d+1]&&a[d]._legendItemPos[1]!==a[d+1]._legendItemPos[1]){b.push({height:0});c=b[b.length-1];for(e;e<=d;e++)a[e].itemHeight>c.height&&(c.height=a[e].itemHeight);c.step=d}return b};k.prototype.retranslateItems=function(a){var b,c,g,d=this.options.rtl,e=0;this.allItems.forEach(function(f,m){b=f.legendGroup.translateX;c=f._legendItemPos[1];if((g=f.movementX)||d&&f.ranges)g=d?b-f.options.maxSize/2:b+g,f.legendGroup.attr({translateX:g});
m>a[e].step&&e++;f.legendGroup.attr({translateY:Math.round(c+a[e].height/2)});f._legendItemPos[1]=c+a[e].height/2})};q(h,"legendItemClick",function(){var a=this.chart,b=this.visible,c=this.chart.legend;c&&c.bubbleLegend&&(this.visible=!b,this.ignoreSeries=b,a=0<=a.getVisibleBubbleSeriesIndex(),c.bubbleLegend.visible!==a&&(c.update({bubbleLegend:{enabled:a}}),c.bubbleLegend.visible=a),this.visible=b)});f(r.prototype,"drawChartBox",function(a,c,g){var d=this.legend,e=0<=this.getVisibleBubbleSeriesIndex(),
f;d&&d.options.enabled&&d.bubbleLegend&&d.options.bubbleLegend.autoRanges&&e?(f=d.bubbleLegend.options,e=d.bubbleLegend.predictBubbleSizes(),d.bubbleLegend.updateRanges(e[0],e[1]),f.placed||(d.group.placed=!1,d.allItems.forEach(function(a){a.legendGroup.translateY=null})),d.render(),this.getMargins(),this.axes.forEach(function(a){a.render();f.placed||(a.setScale(),a.updateNames(),b(a.ticks,function(a){a.isNew=!0;a.isNewLabel=!0}))}),f.placed=!0,this.getMargins(),a.call(this,c,g),d.bubbleLegend.correctSizes(),
d.retranslateItems(d.getLinesHeights())):(a.call(this,c,g),d&&d.options.enabled&&d.bubbleLegend&&(d.render(),d.retranslateItems(d.getLinesHeights())))})});z(h,"parts-more/BubbleSeries.js",[h["parts/Globals.js"]],function(a){var h=a.arrayMax,k=a.arrayMin,r=a.Axis,q=a.color,f=a.isNumber,u=a.noop,x=a.pick,e=a.pInt,b=a.Point,d=a.Series,y=a.seriesType,p=a.seriesTypes;y("bubble","scatter",{dataLabels:{formatter:function(){return this.point.z},inside:!0,verticalAlign:"middle"},animationLimit:250,marker:{lineColor:null,
lineWidth:1,fillOpacity:.5,radius:null,states:{hover:{radiusPlus:0}},symbol:"circle"},minSize:8,maxSize:"20%",softThreshold:!1,states:{hover:{halo:{size:5}}},tooltip:{pointFormat:"({point.x}, {point.y}), Size: {point.z}"},turboThreshold:0,zThreshold:0,zoneAxis:"z"},{pointArrayMap:["y","z"],parallelArrays:["x","y","z"],trackerGroups:["group","dataLabelsGroup"],specialGroup:"group",bubblePadding:!0,zoneAxis:"z",directTouch:!0,isBubble:!0,pointAttribs:function(a,b){var c=this.options.marker.fillOpacity;
a=d.prototype.pointAttribs.call(this,a,b);1!==c&&(a.fill=q(a.fill).setOpacity(c).get("rgba"));return a},getRadii:function(a,b,d){var c,g=this.zData,e=d.minPxSize,f=d.maxPxSize,m=[],h;c=0;for(d=g.length;c<d;c++)h=g[c],m.push(this.getRadius(a,b,e,f,h));this.radii=m},getRadius:function(a,b,d,e,h){var c=this.options,g="width"!==c.sizeBy,m=c.zThreshold,k=b-a;c.sizeByAbsoluteValue&&null!==h&&(h=Math.abs(h-m),k=Math.max(b-m,Math.abs(a-m)),a=0);f(h)?h<a?d=d/2-1:(a=0<k?(h-a)/k:.5,g&&0<=a&&(a=Math.sqrt(a)),
d=Math.ceil(d+a*(e-d))/2):d=null;return d},animate:function(a){!a&&this.points.length<this.options.animationLimit&&(this.points.forEach(function(a){var b=a.graphic,c;b&&b.width&&(c={x:b.x,y:b.y,width:b.width,height:b.height},b.attr({x:a.plotX,y:a.plotY,width:1,height:1}),b.animate(c,this.options.animation))},this),this.animate=null)},hasData:function(){return!!this.processedXData.length},translate:function(){var b,d=this.data,e,h,k=this.radii;p.scatter.prototype.translate.call(this);for(b=d.length;b--;)e=
d[b],h=k?k[b]:0,f(h)&&h>=this.minPxSize/2?(e.marker=a.extend(e.marker,{radius:h,width:2*h,height:2*h}),e.dlBox={x:e.plotX-h,y:e.plotY-h,width:2*h,height:2*h}):e.shapeArgs=e.plotY=e.dlBox=void 0},alignDataLabel:p.column.prototype.alignDataLabel,buildKDTree:u,applyZones:u},{haloPath:function(a){return b.prototype.haloPath.call(this,0===a?0:(this.marker?this.marker.radius||0:0)+a)},ttBelow:!1});r.prototype.beforePadding=function(){var b=this,d=this.len,m=this.chart,p=0,l=d,n=this.isXAxis,y=n?"xData":
"yData",q=this.min,r={},u=Math.min(m.plotWidth,m.plotHeight),z=Number.MAX_VALUE,D=-Number.MAX_VALUE,E=this.max-q,C=d/E,F=[];this.series.forEach(function(c){var d=c.options;!c.bubblePadding||!c.visible&&m.options.chart.ignoreHiddenSeries||(b.allowZoomOutside=!0,F.push(c),n&&(["minSize","maxSize"].forEach(function(a){var b=d[a],c=/%$/.test(b),b=e(b);r[a]=c?u*b/100:b}),c.minPxSize=r.minSize,c.maxPxSize=Math.max(r.maxSize,r.minSize),c=c.zData.filter(a.isNumber),c.length&&(z=x(d.zMin,Math.min(z,Math.max(k(c),
!1===d.displayNegative?d.zThreshold:-Number.MAX_VALUE))),D=x(d.zMax,Math.max(D,h(c))))))});F.forEach(function(a){var c=a[y],d=c.length,e;n&&a.getRadii(z,D,a);if(0<E)for(;d--;)f(c[d])&&b.dataMin<=c[d]&&c[d]<=b.dataMax&&(e=a.radii[d],p=Math.min((c[d]-q)*C-e,p),l=Math.max((c[d]-q)*C+e,l))});F.length&&0<E&&!this.isLog&&(l-=d,C*=(d+Math.max(0,p)-Math.min(l,d))/d,[["min","userMin",p],["max","userMax",l]].forEach(function(a){void 0===x(b.options[a[0]],b[a[1]])&&(b[a[0]]+=a[2]/C)}))}});z(h,"parts-map/MapBubbleSeries.js",
[h["parts/Globals.js"]],function(a){var h=a.merge,k=a.Point,r=a.seriesType,q=a.seriesTypes;q.bubble&&r("mapbubble","bubble",{animationLimit:500,tooltip:{pointFormat:"{point.name}: {point.z}"}},{xyFromShape:!0,type:"mapbubble",pointArrayMap:["z"],getMapData:q.map.prototype.getMapData,getBox:q.map.prototype.getBox,setData:q.map.prototype.setData,setOptions:q.map.prototype.setOptions},{applyOptions:function(a,r){return a&&void 0!==a.lat&&void 0!==a.lon?k.prototype.applyOptions.call(this,h(a,this.series.chart.fromLatLonToPoint(a)),
r):q.map.prototype.pointClass.prototype.applyOptions.call(this,a,r)},isValid:function(){return"number"===typeof this.z},ttBelow:!1})});z(h,"parts-map/HeatmapSeries.js",[h["parts/Globals.js"]],function(a){var h=a.colorPointMixin,k=a.merge,r=a.noop,q=a.pick,f=a.Series,u=a.seriesType,x=a.seriesTypes;u("heatmap","scatter",{animation:!1,borderWidth:0,nullColor:"#f7f7f7",dataLabels:{formatter:function(){return this.point.value},inside:!0,verticalAlign:"middle",crop:!1,overflow:!1,padding:0},marker:null,
pointRange:null,tooltip:{pointFormat:"{point.x}, {point.y}: {point.value}\x3cbr/\x3e"},states:{hover:{halo:!1,brightness:.2}}},k(a.colorSeriesMixin,{pointArrayMap:["y","value"],hasPointSpecificOptions:!0,getExtremesFromAll:!0,directTouch:!0,init:function(){var a;x.scatter.prototype.init.apply(this,arguments);a=this.options;a.pointRange=q(a.pointRange,a.colsize||1);this.yAxis.axisPointRange=a.rowsize||1},translate:function(){var a=this.options,b=this.xAxis,d=this.yAxis,f=a.pointPadding||0,h=function(a,
b,c){return Math.min(Math.max(b,a),c)},c=this.pointPlacementToXValue();this.generatePoints();this.points.forEach(function(g){var e=(a.colsize||1)/2,k=(a.rowsize||1)/2,l=h(Math.round(b.len-b.translate(g.x-e,0,1,0,1,-c)),-b.len,2*b.len),e=h(Math.round(b.len-b.translate(g.x+e,0,1,0,1,-c)),-b.len,2*b.len),p=h(Math.round(d.translate(g.y-k,0,1,0,1)),-d.len,2*d.len),k=h(Math.round(d.translate(g.y+k,0,1,0,1)),-d.len,2*d.len),y=q(g.pointPadding,f);g.plotX=g.clientX=(l+e)/2;g.plotY=(p+k)/2;g.shapeType="rect";
g.shapeArgs={x:Math.min(l,e)+y,y:Math.min(p,k)+y,width:Math.abs(e-l)-2*y,height:Math.abs(k-p)-2*y}});this.translateColors()},drawPoints:function(){var a=this.chart.styledMode?"css":"attr";x.column.prototype.drawPoints.call(this);this.points.forEach(function(b){b.graphic[a](this.colorAttribs(b))},this)},hasData:function(){return!!this.processedXData.length},getValidPoints:function(a,b){return f.prototype.getValidPoints.call(this,a,b,!0)},animate:r,getBox:r,drawLegendSymbol:a.LegendSymbolMixin.drawRectangle,
alignDataLabel:x.column.prototype.alignDataLabel,getExtremes:function(){f.prototype.getExtremes.call(this,this.valueData);this.valueMin=this.dataMin;this.valueMax=this.dataMax;f.prototype.getExtremes.call(this)}}),a.extend({haloPath:function(a){if(!a)return[];var b=this.shapeArgs;return["M",b.x-a,b.y-a,"L",b.x-a,b.y+b.height+a,b.x+b.width+a,b.y+b.height+a,b.x+b.width+a,b.y-a,"Z"]}},h))});z(h,"parts-map/GeoJSON.js",[h["parts/Globals.js"]],function(a){function h(a,b){var d,e,f,c=!1,g=a.x,h=a.y;a=0;
for(d=b.length-1;a<b.length;d=a++)e=b[a][1]>h,f=b[d][1]>h,e!==f&&g<(b[d][0]-b[a][0])*(h-b[a][1])/(b[d][1]-b[a][1])+b[a][0]&&(c=!c);return c}var k=a.Chart,r=a.extend,q=a.format,f=a.merge,u=a.win,x=a.wrap;k.prototype.transformFromLatLon=function(e,b){if(void 0===u.proj4)return a.error(21,!1,this),{x:0,y:null};e=u.proj4(b.crs,[e.lon,e.lat]);var d=b.cosAngle||b.rotation&&Math.cos(b.rotation),f=b.sinAngle||b.rotation&&Math.sin(b.rotation);e=b.rotation?[e[0]*d+e[1]*f,-e[0]*f+e[1]*d]:e;return{x:((e[0]-(b.xoffset||
0))*(b.scale||1)+(b.xpan||0))*(b.jsonres||1)+(b.jsonmarginX||0),y:(((b.yoffset||0)-e[1])*(b.scale||1)+(b.ypan||0))*(b.jsonres||1)-(b.jsonmarginY||0)}};k.prototype.transformToLatLon=function(e,b){if(void 0===u.proj4)a.error(21,!1,this);else{e={x:((e.x-(b.jsonmarginX||0))/(b.jsonres||1)-(b.xpan||0))/(b.scale||1)+(b.xoffset||0),y:((-e.y-(b.jsonmarginY||0))/(b.jsonres||1)+(b.ypan||0))/(b.scale||1)+(b.yoffset||0)};var d=b.cosAngle||b.rotation&&Math.cos(b.rotation),f=b.sinAngle||b.rotation&&Math.sin(b.rotation);
b=u.proj4(b.crs,"WGS84",b.rotation?{x:e.x*d+e.y*-f,y:e.x*f+e.y*d}:e);return{lat:b.y,lon:b.x}}};k.prototype.fromPointToLatLon=function(e){var b=this.mapTransforms,d;if(b){for(d in b)if(b.hasOwnProperty(d)&&b[d].hitZone&&h({x:e.x,y:-e.y},b[d].hitZone.coordinates[0]))return this.transformToLatLon(e,b[d]);return this.transformToLatLon(e,b["default"])}a.error(22,!1,this)};k.prototype.fromLatLonToPoint=function(e){var b=this.mapTransforms,d,f;if(!b)return a.error(22,!1,this),{x:0,y:null};for(d in b)if(b.hasOwnProperty(d)&&
b[d].hitZone&&(f=this.transformFromLatLon(e,b[d]),h({x:f.x,y:-f.y},b[d].hitZone.coordinates[0])))return f;return this.transformFromLatLon(e,b["default"])};a.geojson=function(a,b,d){var f=[],e=[],c=function(a){var b,c=a.length;e.push("M");for(b=0;b<c;b++)1===b&&e.push("L"),e.push(a[b][0],-a[b][1])};b=b||"map";a.features.forEach(function(a){var d=a.geometry,g=d.type,d=d.coordinates;a=a.properties;var h;e=[];"map"===b||"mapbubble"===b?("Polygon"===g?(d.forEach(c),e.push("Z")):"MultiPolygon"===g&&(d.forEach(function(a){a.forEach(c)}),
e.push("Z")),e.length&&(h={path:e})):"mapline"===b?("LineString"===g?c(d):"MultiLineString"===g&&d.forEach(c),e.length&&(h={path:e})):"mappoint"===b&&"Point"===g&&(h={x:d[0],y:-d[1]});h&&f.push(r(h,{name:a.name||a.NAME,properties:a}))});d&&a.copyrightShort&&(d.chart.mapCredits=q(d.chart.options.credits.mapText,{geojson:a}),d.chart.mapCreditsFull=q(d.chart.options.credits.mapTextFull,{geojson:a}));return f};x(k.prototype,"addCredits",function(a,b){b=f(!0,this.options.credits,b);this.mapCredits&&(b.href=
null);a.call(this,b);this.credits&&this.mapCreditsFull&&this.credits.attr({title:this.mapCreditsFull})})});z(h,"parts-map/Map.js",[h["parts/Globals.js"]],function(a){function h(a,b,e,c,g,f,h,k){return["M",a+g,b,"L",a+e-f,b,"C",a+e-f/2,b,a+e,b+f/2,a+e,b+f,"L",a+e,b+c-h,"C",a+e,b+c-h/2,a+e-h/2,b+c,a+e-h,b+c,"L",a+k,b+c,"C",a+k/2,b+c,a,b+c-k/2,a,b+c-k,"L",a,b+g,"C",a,b+g/2,a+g/2,b,a+g,b,"Z"]}var k=a.Chart,r=a.defaultOptions,q=a.extend,f=a.merge,u=a.pick,x=a.Renderer,e=a.SVGRenderer,b=a.VMLRenderer;q(r.lang,
{zoomIn:"Zoom in",zoomOut:"Zoom out"});r.mapNavigation={buttonOptions:{alignTo:"plotBox",align:"left",verticalAlign:"top",x:0,width:18,height:18,padding:5,style:{fontSize:"15px",fontWeight:"bold"},theme:{"stroke-width":1,"text-align":"center"}},buttons:{zoomIn:{onclick:function(){this.mapZoom(.5)},text:"+",y:0},zoomOut:{onclick:function(){this.mapZoom(2)},text:"-",y:28}},mouseWheelSensitivity:1.1};a.splitPath=function(a){var b;a=a.replace(/([A-Za-z])/g," $1 ");a=a.replace(/^\s*/,"").replace(/\s*$/,
"");a=a.split(/[ ,]+/);for(b=0;b<a.length;b++)/[a-zA-Z]/.test(a[b])||(a[b]=parseFloat(a[b]));return a};a.maps={};e.prototype.symbols.topbutton=function(a,b,e,c,g){return h(a-1,b-1,e,c,g.r,g.r,0,0)};e.prototype.symbols.bottombutton=function(a,b,e,c,g){return h(a-1,b-1,e,c,0,0,g.r,g.r)};x===b&&["topbutton","bottombutton"].forEach(function(a){b.prototype.symbols[a]=e.prototype.symbols[a]});a.Map=a.mapChart=function(b,e,h){var c="string"===typeof b||b.nodeName,d=arguments[c?1:0],m=d,p={endOnTick:!1,visible:!1,
minPadding:0,maxPadding:0,startOnTick:!1},l,n=a.getOptions().credits;l=d.series;d.series=null;d=f({chart:{panning:"xy",type:"map"},credits:{mapText:u(n.mapText,' \u00a9 \x3ca href\x3d"{geojson.copyrightUrl}"\x3e{geojson.copyrightShort}\x3c/a\x3e'),mapTextFull:u(n.mapTextFull,"{geojson.copyright}")},tooltip:{followTouchMove:!1},xAxis:p,yAxis:f(p,{reversed:!0})},d,{chart:{inverted:!1,alignTicks:!1}});d.series=m.series=l;return c?new k(b,d,h):new k(d,e)}});z(h,"masters/modules/map.src.js",[],function(){})});
//# sourceMappingURL=map.js.map
