/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import java.util.List;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.client.sounds.GCSounds;
import micdoodle8.mods.galacticraft.core.tile.AirLockProtocol;
import micdoodle8.mods.galacticraft.core.tile.TileEntityAirLock;
import micdoodle8.mods.galacticraft.core.util.PlayerUtil;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;

public class TileEntityAirLockController
extends TileEntityAirLock {
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean redstoneActivation;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean playerDistanceActivation = true;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int playerDistanceSelection;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean playerNameMatches;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public String playerToOpenFor = "";
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean invertSelection;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean horizontalModeEnabled;
    public boolean lastHorizontalModeEnabled;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public String ownerName = "";
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean active;
    public boolean lastActive;
    private int otherAirLocks;
    private int lastOtherAirLocks;
    private AirLockProtocol protocol;
    private AirLockProtocol lastProtocol = this.protocol;

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            this.active = false;
            if (this.redstoneActivation) {
                boolean bl = this.active = this.field_145850_b.func_175687_A(this.func_174877_v()) > 0;
            }
            if ((this.active || !this.redstoneActivation) && this.playerDistanceActivation) {
                double distance = 0.0;
                switch (this.playerDistanceSelection) {
                    case 0: {
                        distance = 1.0;
                        break;
                    }
                    case 1: {
                        distance = 2.0;
                        break;
                    }
                    case 2: {
                        distance = 5.0;
                        break;
                    }
                    case 3: {
                        distance = 10.0;
                    }
                }
                Vector3 minPos = new Vector3(this).translate(0.5 - distance);
                Vector3 maxPos = new Vector3(this).translate(0.5 + distance);
                AxisAlignedBB matchingRegion = new AxisAlignedBB(minPos.x, minPos.y, minPos.z, maxPos.x, maxPos.y, maxPos.z);
                List playersWithin = this.field_145850_b.func_72872_a(EntityPlayer.class, matchingRegion);
                if (this.playerNameMatches) {
                    boolean foundPlayer = false;
                    for (EntityPlayer p : playersWithin) {
                        if (!PlayerUtil.getName(p).equalsIgnoreCase(this.playerToOpenFor)) continue;
                        foundPlayer = true;
                        break;
                    }
                    this.active = foundPlayer;
                } else {
                    boolean bl = this.active = !playersWithin.isEmpty();
                }
            }
            if (!this.invertSelection) {
                boolean bl = this.active = !this.active;
            }
            if (this.protocol == null) {
                this.protocol = this.lastProtocol = new AirLockProtocol(this);
            }
            if (this.ticks % 5 == 0) {
                if (this.horizontalModeEnabled != this.lastHorizontalModeEnabled) {
                    this.unsealAirLock();
                } else if (this.active || this.lastActive) {
                    this.lastOtherAirLocks = this.otherAirLocks;
                    this.otherAirLocks = this.protocol.calculate(this.horizontalModeEnabled);
                    if (this.active) {
                        if (this.otherAirLocks != this.lastOtherAirLocks || !this.lastActive) {
                            this.unsealAirLock();
                            if (this.otherAirLocks >= 0) {
                                this.sealAirLock();
                            }
                        }
                    } else if (this.lastActive) {
                        this.unsealAirLock();
                    }
                }
                if (this.active != this.lastActive) {
                    IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
                    this.field_145850_b.func_184138_a(this.func_174877_v(), state, state, 3);
                }
                this.lastActive = this.active;
                this.lastProtocol = this.protocol;
                this.lastHorizontalModeEnabled = this.horizontalModeEnabled;
            }
        }
    }

    private void sealAirLock() {
        block11: {
            int z;
            int y;
            int x;
            block10: {
                x = (this.lastProtocol.maxX + this.lastProtocol.minX) / 2;
                y = (this.lastProtocol.maxY + this.lastProtocol.minY) / 2;
                z = (this.lastProtocol.maxZ + this.lastProtocol.minZ) / 2;
                if (this.field_145850_b.func_180495_p(new BlockPos(x, y, z)).func_177230_c() != GCBlocks.airLockSeal) {
                    this.field_145850_b.func_184148_a(null, (double)x, (double)y, (double)z, GCSounds.openAirLock, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
                if (!this.horizontalModeEnabled) break block10;
                if (this.protocol.minY != this.protocol.maxY || this.protocol.minX == this.protocol.maxX || this.protocol.minZ == this.protocol.maxZ) break block11;
                for (x = this.protocol.minX + 1; x <= this.protocol.maxX - 1; ++x) {
                    for (z = this.protocol.minZ + 1; z <= this.protocol.maxZ - 1; ++z) {
                        BlockPos pos = new BlockPos(x, y, z);
                        if (!this.field_145850_b.func_180495_p(pos).func_177230_c().isAir(this.field_145850_b.func_180495_p(pos), (IBlockAccess)this.field_145850_b, pos)) continue;
                        this.field_145850_b.func_180501_a(pos, GCBlocks.airLockSeal.func_176223_P(), 3);
                    }
                }
                break block11;
            }
            if (this.protocol.minX != this.protocol.maxX) {
                for (x = this.protocol.minX + 1; x <= this.protocol.maxX - 1; ++x) {
                    for (y = this.protocol.minY + 1; y <= this.protocol.maxY - 1; ++y) {
                        BlockPos pos = new BlockPos(x, y, z);
                        if (!this.field_145850_b.func_180495_p(pos).func_177230_c().isAir(this.field_145850_b.func_180495_p(pos), (IBlockAccess)this.field_145850_b, pos)) continue;
                        this.field_145850_b.func_180501_a(pos, GCBlocks.airLockSeal.func_176223_P(), 3);
                    }
                }
            } else if (this.protocol.minZ != this.protocol.maxZ) {
                for (z = this.protocol.minZ + 1; z <= this.protocol.maxZ - 1; ++z) {
                    for (y = this.protocol.minY + 1; y <= this.protocol.maxY - 1; ++y) {
                        BlockPos pos = new BlockPos(x, y, z);
                        if (!this.field_145850_b.func_180495_p(pos).func_177230_c().isAir(this.field_145850_b.func_180495_p(pos), (IBlockAccess)this.field_145850_b, pos)) continue;
                        this.field_145850_b.func_180501_a(pos, GCBlocks.airLockSeal.func_176223_P(), 3);
                    }
                }
            }
        }
    }

    public void unsealAirLock() {
        block12: {
            BlockPos pos;
            int z;
            int y;
            int x;
            block11: {
                if (this.lastProtocol == null) {
                    return;
                }
                x = this.lastProtocol.minX + (this.lastProtocol.maxX - this.lastProtocol.minX) / 2;
                y = this.lastProtocol.minY + (this.lastProtocol.maxY - this.lastProtocol.minY) / 2;
                z = this.lastProtocol.minZ + (this.lastProtocol.maxZ - this.lastProtocol.minZ) / 2;
                pos = new BlockPos(x, y, z);
                IBlockState state = this.field_145850_b.func_180495_p(pos);
                if (state.func_185904_a() != Material.field_151579_a) {
                    this.field_145850_b.func_184148_a(null, (double)x, (double)y, (double)z, GCSounds.closeAirLock, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
                if (!this.lastHorizontalModeEnabled) break block11;
                if (this.protocol.minY != this.protocol.maxY || this.protocol.minX == this.protocol.maxX || this.protocol.minZ == this.protocol.maxZ) break block12;
                for (x = this.protocol.minX + 1; x <= this.protocol.maxX - 1; ++x) {
                    for (z = this.protocol.minZ + 1; z <= this.protocol.maxZ - 1; ++z) {
                        pos = new BlockPos(x, y, z);
                        if (this.field_145850_b.func_180495_p(pos).func_177230_c() != GCBlocks.airLockSeal) continue;
                        this.field_145850_b.func_175698_g(pos);
                    }
                }
                break block12;
            }
            if (this.lastProtocol.minX != this.lastProtocol.maxX) {
                for (x = this.lastProtocol.minX + 1; x <= this.lastProtocol.maxX - 1; ++x) {
                    for (y = this.lastProtocol.minY + 1; y <= this.lastProtocol.maxY - 1; ++y) {
                        pos = new BlockPos(x, y, z);
                        if (this.field_145850_b.func_180495_p(pos).func_177230_c() != GCBlocks.airLockSeal) continue;
                        this.field_145850_b.func_175698_g(pos);
                    }
                }
            } else if (this.lastProtocol.minZ != this.lastProtocol.maxZ) {
                for (z = this.lastProtocol.minZ + 1; z <= this.lastProtocol.maxZ - 1; ++z) {
                    for (y = this.lastProtocol.minY + 1; y <= this.lastProtocol.maxY - 1; ++y) {
                        pos = new BlockPos(x, y, z);
                        if (this.field_145850_b.func_180495_p(pos).func_177230_c() != GCBlocks.airLockSeal) continue;
                        this.field_145850_b.func_175698_g(pos);
                    }
                }
            }
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.ownerName = nbt.func_74779_i("OwnerName");
        this.redstoneActivation = nbt.func_74767_n("RedstoneActivation");
        this.playerDistanceActivation = nbt.func_74767_n("PlayerDistanceActivation");
        this.playerDistanceSelection = nbt.func_74762_e("PlayerDistanceSelection");
        this.playerNameMatches = nbt.func_74767_n("PlayerNameMatches");
        this.playerToOpenFor = nbt.func_74779_i("PlayerToOpenFor");
        this.invertSelection = nbt.func_74767_n("InvertSelection");
        this.active = nbt.func_74767_n("active");
        this.lastActive = nbt.func_74767_n("lastActive");
        this.horizontalModeEnabled = nbt.func_74767_n("HorizontalModeEnabled");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74778_a("OwnerName", this.ownerName);
        nbt.func_74757_a("RedstoneActivation", this.redstoneActivation);
        nbt.func_74757_a("PlayerDistanceActivation", this.playerDistanceActivation);
        nbt.func_74768_a("PlayerDistanceSelection", this.playerDistanceSelection);
        nbt.func_74757_a("PlayerNameMatches", this.playerNameMatches);
        nbt.func_74778_a("PlayerToOpenFor", this.playerToOpenFor);
        nbt.func_74757_a("InvertSelection", this.invertSelection);
        nbt.func_74757_a("active", this.active);
        nbt.func_74757_a("lastActive", this.lastActive);
        nbt.func_74757_a("HorizontalModeEnabled", this.horizontalModeEnabled);
        return nbt;
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Override
    public double getPacketRange() {
        return 20.0;
    }

    @Override
    public int getPacketCooldown() {
        return 3;
    }

    @Override
    public boolean isNetworkedTile() {
        return true;
    }
}

