/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.trentech.pjp.commands.home;

import com.gmail.trentech.pjc.core.ConfigManager;
import com.gmail.trentech.pjc.help.Help;
import com.gmail.trentech.pjp.Main;
import com.gmail.trentech.pjp.data.Keys;
import com.gmail.trentech.pjp.data.mutable.HomeData;
import com.gmail.trentech.pjp.portal.Portal;
import com.gmail.trentech.pjp.portal.features.Coordinate;
import com.gmail.trentech.pjp.rotation.Rotation;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class CMDCreate
implements CommandExecutor {
    public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
        Help help = (Help)Help.get((String)"home create").get();
        if (args.hasAny("help")) {
            help.execute(src);
            return CommandResult.empty();
        }
        if (!(src instanceof Player)) {
            throw new CommandException(Text.of((Object[])new Object[]{TextColors.RED, "Must be a player"}), false);
        }
        Player player = (Player)src;
        if (!args.hasAny("name")) {
            throw new CommandException(Text.builder().onClick((ClickAction)TextActions.executeCallback((Consumer)help.execute())).append(new Text[]{help.getUsageText()}).build(), false);
        }
        String name = ((String)args.getOne("name").get()).toLowerCase();
        Map<String, Portal> list = new HashMap();
        Optional optionalList = player.get(Keys.PORTALS);
        if (optionalList.isPresent()) {
            list = (Map)optionalList.get();
        }
        int defaultAmount = ConfigManager.get((PluginContainer)Main.getPlugin()).getConfig().getNode(new Object[]{"options", "homes"}).getInt();
        int amount = list.size();
        int extra = 0;
        for (int i = 1; i <= 100; ++i) {
            if (!player.hasPermission("pjp.homes." + i)) continue;
            extra = i;
            break;
        }
        if (!player.hasPermission("pjp.homes.unlimited")) {
            if (amount >= defaultAmount + extra) {
                throw new CommandException(Text.of((Object[])new Object[]{TextColors.RED, "You have reached the maximum number of homes you can have"}), false);
            }
            ++amount;
        }
        if (list.containsKey(name)) {
            throw new CommandException(Text.of((Object[])new Object[]{TextColors.RED, name, " already exists."}), false);
        }
        Location location = player.getLocation();
        boolean force = false;
        if (args.hasAny("f")) {
            force = true;
        }
        Portal.Local portal = new Portal.Local(Portal.PortalType.HOME, Rotation.getClosest(player.getRotation().getFloorY()), 0.0, force);
        portal.setCoordinate(new Coordinate((Location<World>)location));
        list.put(name, portal);
        DataTransactionResult result = player.offer((ValueContainer)new HomeData(list));
        if (!result.isSuccessful()) {
            throw new CommandException(Text.of((Object[])new Object[]{TextColors.RED, "Could not create ", name}), false);
        }
        player.sendMessage(Text.of((Object[])new Object[]{TextColors.DARK_GREEN, "Home ", name, " create"}));
        return CommandResult.success();
    }
}

