/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.trentech.pjp.commands.home;

import com.flowpowered.math.vector.Vector3d;
import com.gmail.trentech.pjc.help.Help;
import com.gmail.trentech.pjp.data.Keys;
import com.gmail.trentech.pjp.portal.Portal;
import com.gmail.trentech.pjp.portal.features.Coordinate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.service.pagination.PaginationList;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class CMDList
implements CommandExecutor {
    public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
        Help help = (Help)Help.get((String)"home list").get();
        if (args.hasAny("help")) {
            help.execute(src);
            return CommandResult.empty();
        }
        if (!(src instanceof Player)) {
            throw new CommandException(Text.of((Object[])new Object[]{TextColors.RED, "Must be a player"}), false);
        }
        Player player = (Player)src;
        Map list = new HashMap();
        Optional optionalHomeList = player.get(Keys.PORTALS);
        if (optionalHomeList.isPresent()) {
            list = (Map)optionalHomeList.get();
        }
        ArrayList<Text> pages = new ArrayList<Text>();
        for (Map.Entry entry : list.entrySet()) {
            String name = ((String)entry.getKey()).toString();
            Portal.Local local = (Portal.Local)entry.getValue();
            Text.Builder builder = Text.builder().onHover((HoverAction)TextActions.showText((Text)Text.of((Object[])new Object[]{TextColors.WHITE, "Click to teleport to home"})));
            Optional<Coordinate> optionalCoordinate = local.getCoordinate();
            if (optionalCoordinate.isPresent()) {
                Coordinate coordinate = optionalCoordinate.get();
                String worldName = coordinate.getWorld().getName();
                if (coordinate.getPreset().equals((Object)Coordinate.Preset.BED)) {
                    builder.onClick((ClickAction)TextActions.runCommand((String)("/home " + name))).append(new Text[]{Text.of((Object[])new Object[]{TextColors.GREEN, "Name: ", TextColors.WHITE, name, TextColors.GREEN, " Destination: ", TextColors.WHITE, worldName, ", bed"})});
                } else if (coordinate.getPreset().equals((Object)Coordinate.Preset.RANDOM)) {
                    builder.onClick((ClickAction)TextActions.runCommand((String)("/home " + name))).append(new Text[]{Text.of((Object[])new Object[]{TextColors.GREEN, "Name: ", TextColors.WHITE, name, TextColors.GREEN, " Destination: ", TextColors.WHITE, worldName, ", random"})});
                } else {
                    Optional<Location<World>> optionalLocation = coordinate.getLocation();
                    if (optionalLocation.isPresent()) {
                        Location<World> location = optionalLocation.get();
                        Vector3d vector3d = location.getPosition();
                        builder.onClick((ClickAction)TextActions.runCommand((String)("/home " + name))).append(new Text[]{Text.of((Object[])new Object[]{TextColors.GREEN, "Name: ", TextColors.WHITE, name, TextColors.GREEN, " Destination: ", TextColors.WHITE, worldName, ", ", vector3d.getFloorX(), ", ", vector3d.getFloorY(), ", ", vector3d.getFloorZ()})});
                    } else {
                        builder.onClick((ClickAction)TextActions.runCommand((String)("/home " + name))).append(new Text[]{Text.of((Object[])new Object[]{TextColors.GREEN, "Name: ", TextColors.WHITE, name, TextColors.RED, " - DESTINATION ERROR"})});
                    }
                }
            } else {
                builder.onClick((ClickAction)TextActions.runCommand((String)("/home " + name))).append(new Text[]{Text.of((Object[])new Object[]{TextColors.GREEN, "Name: ", TextColors.WHITE, name, TextColors.RED, " - DESTINATION ERROR"})});
            }
            pages.add(builder.build());
        }
        if (pages.isEmpty()) {
            pages.add(Text.of((Object[])new Object[]{TextColors.YELLOW, " No saved homes"}));
        }
        PaginationList.Builder paginationList = PaginationList.builder();
        paginationList.title(Text.builder().color(TextColors.DARK_GREEN).append(new Text[]{Text.of((Object[])new Object[]{TextColors.GREEN, "Homes"})}).build());
        paginationList.contents(pages);
        paginationList.sendTo((MessageReceiver)src);
        return CommandResult.success();
    }
}

