/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.trentech.pjp.listeners;

import com.gmail.trentech.pjp.portal.LegacyBuilder;
import com.gmail.trentech.pjp.portal.Portal;
import com.gmail.trentech.pjp.portal.PortalService;
import com.gmail.trentech.pjp.utils.Timings;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.block.ChangeBlockEvent;
import org.spongepowered.api.event.filter.cause.Root;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class LegacyListener {
    public static ConcurrentHashMap<UUID, LegacyBuilder> builders = new ConcurrentHashMap();
    private Timings timings;

    public LegacyListener(Timings timings) {
        this.timings = timings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Listener
    public void onChangeBlockEventPlace(ChangeBlockEvent.Place event, @Root Player player) {
        this.timings.onChangeBlockEventPlace().startTiming();
        try {
            if (!builders.containsKey(player.getUniqueId())) {
                for (Transaction transaction : event.getTransactions()) {
                    Location location = (Location)((BlockSnapshot)transaction.getFinal()).getLocation().get();
                    if (!((PortalService)Sponge.getServiceManager().provide(PortalService.class).get()).get((Location<World>)location, Portal.PortalType.PORTAL).isPresent()) continue;
                    event.setCancelled(true);
                    break;
                }
                return;
            }
            LegacyBuilder builder = builders.get(player.getUniqueId());
            for (Transaction transaction : event.getTransactions()) {
                if (((BlockSnapshot)transaction.getFinal()).getState().getType().equals(BlockTypes.FIRE)) {
                    event.setCancelled(true);
                    break;
                }
                Location location = (Location)((BlockSnapshot)transaction.getFinal()).getLocation().get();
                if (builder.isFill()) {
                    builder.addFill((Location<World>)location);
                    continue;
                }
                builder.addFrame((Location<World>)location);
            }
        }
        finally {
            this.timings.onChangeBlockEventPlace().stopTiming();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Listener
    public void onChangeBlockEventBreak(ChangeBlockEvent.Break event, @Root Player player) {
        this.timings.onChangeBlockEventBreak().startTiming();
        try {
            if (!builders.containsKey(player.getUniqueId())) {
                for (Transaction transaction : event.getTransactions()) {
                    Location location = (Location)((BlockSnapshot)transaction.getFinal()).getLocation().get();
                    if (!((PortalService)Sponge.getServiceManager().provide(PortalService.class).get()).get((Location<World>)location, Portal.PortalType.PORTAL).isPresent()) continue;
                    event.setCancelled(true);
                    break;
                }
                return;
            }
            LegacyBuilder builder = builders.get(player.getUniqueId());
            for (Transaction transaction : event.getTransactions()) {
                Location location = (Location)((BlockSnapshot)transaction.getFinal()).getLocation().get();
                if (builder.isFill()) {
                    builder.removeFill((Location<World>)location);
                    continue;
                }
                builder.removeFrame((Location<World>)location);
            }
        }
        finally {
            this.timings.onChangeBlockEventBreak().stopTiming();
        }
    }
}

