/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.trentech.pjp.portal;

import com.gmail.trentech.pjp.effects.Particle;
import com.gmail.trentech.pjp.effects.ParticleColor;
import com.gmail.trentech.pjp.effects.Particles;
import com.gmail.trentech.pjp.events.ConstructPortalEvent;
import com.gmail.trentech.pjp.portal.Portal;
import com.gmail.trentech.pjp.portal.PortalService;
import java.util.ArrayList;
import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.util.Direction;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class PortalBuilder {
    private boolean valid = false;
    private Portal portal;

    public PortalBuilder(Portal portal, Location<World> location, Direction direction) {
        if (portal.getProperties().isPresent()) {
            this.portal = portal;
            if (direction.equals((Object)Direction.NORTH)) {
                direction = Direction.EAST;
            } else if (direction.equals((Object)Direction.EAST)) {
                direction = Direction.SOUTH;
            } else if (direction.equals((Object)Direction.SOUTH)) {
                direction = Direction.WEST;
            } else if (direction.equals((Object)Direction.WEST)) {
                direction = Direction.NORTH;
            }
            this.findPortal(location, direction, Direction.UP);
            if (!this.isValid()) {
                portal.getProperties().get().getFill().clear();
                portal.getProperties().get().getFrame().clear();
                if (direction.equals((Object)Direction.NORTH) || direction.equals((Object)Direction.SOUTH)) {
                    this.findPortal(location, direction, Direction.EAST);
                    if (!this.isValid()) {
                        portal.getProperties().get().getFill().clear();
                        portal.getProperties().get().getFrame().clear();
                        this.findPortal(location, direction, Direction.WEST);
                    }
                } else {
                    this.findPortal(location, direction, Direction.NORTH);
                    if (!this.isValid()) {
                        portal.getProperties().get().getFill().clear();
                        portal.getProperties().get().getFrame().clear();
                        this.findPortal(location, direction, Direction.SOUTH);
                    }
                }
            }
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean spawnPortal(Cause cause) {
        if (this.isValid() && !Sponge.getEventManager().post((Event)new ConstructPortalEvent(this.portal.getProperties().get().getFrame(), this.portal.getProperties().get().getFill(), cause))) {
            Particle effect = Particles.getDefaultEffect("creation");
            Optional<ParticleColor> effectColor = Particles.getDefaultColor("creation", this.portal.getProperties().get().getParticle().isColorable());
            for (Location<World> location : this.portal.getProperties().get().getFill()) {
                effect.spawnParticle(location, false, effectColor);
            }
            this.portal.setProperties(this.portal.getProperties().get());
            ((PortalService)Sponge.getServiceManager().provide(PortalService.class).get()).create(this.portal, this.portal.getName());
            return true;
        }
        return false;
    }

    private void findPortal(Location<World> location, Direction horizonal, Direction vertical) {
        this.scanEdge(location, horizonal, vertical, false);
        for (int i = 1; i < 50 && this.scanLine((Location<World>)(location = location.getRelative(vertical)), horizonal, vertical, i == 1); ++i) {
        }
        if (this.isValid()) {
            this.scanEdge((Location<World>)location, horizonal, vertical, true);
            block1: for (Location<World> loc : this.portal.getProperties().get().getFill()) {
                ArrayList<Location> list = new ArrayList<Location>();
                list.add(loc.getRelative(vertical));
                list.add(loc.getRelative(vertical.getOpposite()));
                list.add(loc.getRelative(horizonal));
                list.add(loc.getRelative(horizonal.getOpposite()));
                for (Location loc2 : list) {
                    BlockState state = loc2.getBlock();
                    if (!state.getType().equals(BlockTypes.AIR) || this.portal.getProperties().get().getFill().contains(loc2)) continue;
                    this.valid = false;
                    continue block1;
                }
            }
        }
    }

    private void scanEdge(Location<World> location, Direction direction, Direction vertical, boolean top) {
        BlockType blockType;
        int i;
        Location loc = location;
        if (top) {
            vertical = vertical.getOpposite();
        }
        for (i = 1; i < 25 && !(blockType = loc.getBlock().getType()).equals(BlockTypes.AIR); ++i) {
            if (!this.portal.getProperties().get().getFrame().contains(loc)) {
                this.portal.getProperties().get().getFrame().add(loc);
            }
            if (!loc.getRelative(vertical).getBlock().getType().equals(BlockTypes.AIR)) break;
            loc = loc.getRelative(direction);
        }
        loc = location;
        for (i = 1; i < 25 && !(blockType = loc.getBlock().getType()).equals(BlockTypes.AIR); ++i) {
            if (!this.portal.getProperties().get().getFrame().contains(loc)) {
                this.portal.getProperties().get().getFrame().add((Location<World>)loc);
            }
            if (!loc.getRelative(vertical).getBlock().getType().equals(BlockTypes.AIR)) break;
            loc = loc.getRelative(direction.getOpposite());
        }
    }

    private boolean scanDirection(Location<World> location, Direction direction, Direction vertical, boolean first) {
        boolean valid = true;
        for (int i = 1; i < 25; ++i) {
            BlockState state = location.getBlock();
            if (state.getType().equals(BlockTypes.AIR)) {
                if (!this.portal.getProperties().get().getFill().contains(location)) {
                    this.portal.getProperties().get().getFill().add(location);
                }
                if (first) {
                    if (location.getRelative(vertical.getOpposite()).getBlock().getType().equals(BlockTypes.AIR)) {
                        this.valid = false;
                        return false;
                    }
                } else if (location.getRelative(vertical).getBlock().getType().equals(BlockTypes.AIR)) {
                    valid = false;
                }
            } else {
                if (i != 1) {
                    if (this.portal.getProperties().get().getFrame().contains(location)) break;
                    this.portal.getProperties().get().getFrame().add(location);
                    break;
                }
                return false;
            }
            location = location.getRelative(direction);
        }
        this.valid = valid;
        return true;
    }

    private boolean scanLine(Location<World> location, Direction direction, Direction vertical, boolean first) {
        if (this.scanDirection(location, direction.getOpposite(), vertical, first)) {
            if (!this.isValid()) {
                if (this.scanDirection(location, direction, vertical, first)) {
                    this.valid = false;
                    return true;
                }
                this.valid = false;
            } else if (this.scanDirection(location, direction, vertical, first)) {
                return true;
            }
        }
        return false;
    }
}

