/*
 * Decompiled with CFR 0.152.
 */
package nc.block.property;

import nc.block.property.PropertySidedEnum;
import nc.tile.fluid.ITileFluid;
import nc.tile.internal.fluid.FluidConnection;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public interface ISidedFluid {
    public static final PropertySidedEnum<FluidConnection> FLUID_UP = ISidedFluid.fluidSide("up", EnumFacing.UP);
    public static final PropertySidedEnum<FluidConnection> FLUID_DOWN = ISidedFluid.fluidSide("down", EnumFacing.DOWN);
    public static final PropertySidedEnum<FluidConnection> FLUID_NORTH = ISidedFluid.fluidSide("north", EnumFacing.NORTH);
    public static final PropertySidedEnum<FluidConnection> FLUID_SOUTH = ISidedFluid.fluidSide("south", EnumFacing.SOUTH);
    public static final PropertySidedEnum<FluidConnection> FLUID_WEST = ISidedFluid.fluidSide("west", EnumFacing.WEST);
    public static final PropertySidedEnum<FluidConnection> FLUID_EAST = ISidedFluid.fluidSide("east", EnumFacing.EAST);

    public static PropertySidedEnum<FluidConnection> fluidSide(String name, EnumFacing facing) {
        return PropertySidedEnum.create(name, FluidConnection.class, facing);
    }

    default public IBlockState getActualFluidState(IBlockState state, IBlockAccess world, BlockPos pos) {
        return state.func_177226_a(FLUID_NORTH, (Comparable)((Object)this.getFluidConnection(world, pos, EnumFacing.NORTH))).func_177226_a(FLUID_SOUTH, (Comparable)((Object)this.getFluidConnection(world, pos, EnumFacing.SOUTH))).func_177226_a(FLUID_WEST, (Comparable)((Object)this.getFluidConnection(world, pos, EnumFacing.WEST))).func_177226_a(FLUID_EAST, (Comparable)((Object)this.getFluidConnection(world, pos, EnumFacing.EAST))).func_177226_a(FLUID_UP, (Comparable)((Object)this.getFluidConnection(world, pos, EnumFacing.UP))).func_177226_a(FLUID_DOWN, (Comparable)((Object)this.getFluidConnection(world, pos, EnumFacing.DOWN)));
    }

    default public FluidConnection getFluidConnection(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        if (world.func_175625_s(pos) instanceof ITileFluid) {
            return ((ITileFluid)world.func_175625_s(pos)).getFluidConnection(facing);
        }
        return FluidConnection.NON;
    }

    default public BlockStateContainer createFluidBlockState(Block block) {
        return new BlockStateContainer(block, new IProperty[]{FLUID_NORTH, FLUID_EAST, FLUID_SOUTH, FLUID_WEST, FLUID_DOWN, FLUID_UP});
    }
}

