/*
 * Decompiled with CFR 0.152.
 */
package nc.init;

import java.util.ArrayList;
import java.util.List;
import nc.NuclearCraft;
import nc.block.fluid.BlockFluidBase;
import nc.block.fluid.BlockFluidFission;
import nc.config.NCConfig;
import nc.fluid.FluidFission;
import net.minecraft.block.Block;
import net.minecraft.item.ItemBlock;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class NCFissionFluids {
    public static List<FluidFission> fluidList = new ArrayList<FluidFission>();

    public static void register() {
        for (FluidFission fluid : fluidList) {
            boolean defaultFluid = FluidRegistry.registerFluid((Fluid)fluid);
            if (!defaultFluid) {
                Fluid fluidDefault = FluidRegistry.getFluid((String)fluid.getName());
                FluidRegistry.addBucketForFluid((Fluid)fluidDefault);
                if (!NCConfig.register_fission_fluid_blocks) continue;
                NCFissionFluids.registerBlock(new BlockFluidFission(fluidDefault));
                continue;
            }
            FluidRegistry.addBucketForFluid((Fluid)fluid);
            if (!NCConfig.register_fission_fluid_blocks) continue;
            NCFissionFluids.registerBlock(new BlockFluidFission(fluid));
        }
    }

    public static void registerBlock(BlockFluidBase block) {
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)block);
        ForgeRegistries.ITEMS.register(new ItemBlock((Block)block).setRegistryName(block.getRegistryName()));
        NuclearCraft.proxy.registerFluidBlockRendering((Block)block, "fluid_molten_colored");
    }

    public static List<FluidFission> fissionFluids(String name, int color) {
        ArrayList<FluidFission> fluidList = new ArrayList<FluidFission>();
        fluidList.add(new FluidFission(name, color));
        fluidList.add(new FluidFission(name + "_fluoride", FluidFission.getFluorideColor(color)));
        fluidList.add(new FluidFission(name + "_fluoride_flibe", FluidFission.getFLIBEColor(color)));
        return fluidList;
    }

    static {
        fluidList.addAll(NCFissionFluids.fissionFluids("thorium", 0x242424));
        fluidList.addAll(NCFissionFluids.fissionFluids("uranium", 3626039));
        fluidList.addAll(NCFissionFluids.fissionFluids("plutonium", 0xDBDBDB));
        fluidList.addAll(NCFissionFluids.fissionFluids("thorium_230", 0x383838));
        fluidList.addAll(NCFissionFluids.fissionFluids("thorium_232", 0x303030));
        fluidList.addAll(NCFissionFluids.fissionFluids("uranium_233", 2174496));
        fluidList.addAll(NCFissionFluids.fissionFluids("uranium_235", 1060112));
        fluidList.addAll(NCFissionFluids.fissionFluids("uranium_238", 0x333E32));
        fluidList.addAll(NCFissionFluids.fissionFluids("neptunium_236", 2702912));
        fluidList.addAll(NCFissionFluids.fissionFluids("neptunium_237", 3029570));
        fluidList.addAll(NCFissionFluids.fissionFluids("plutonium_238", 0x999999));
        fluidList.addAll(NCFissionFluids.fissionFluids("plutonium_239", 0x9E9E9E));
        fluidList.addAll(NCFissionFluids.fissionFluids("plutonium_241", 0x909090));
        fluidList.addAll(NCFissionFluids.fissionFluids("plutonium_242", 0xABABAB));
        fluidList.addAll(NCFissionFluids.fissionFluids("americium_241", 3749669));
        fluidList.addAll(NCFissionFluids.fissionFluids("americium_242", 3353882));
        fluidList.addAll(NCFissionFluids.fissionFluids("americium_243", 2893836));
        fluidList.addAll(NCFissionFluids.fissionFluids("curium_243", 0x311137));
        fluidList.addAll(NCFissionFluids.fissionFluids("curium_245", 2953261));
        fluidList.addAll(NCFissionFluids.fissionFluids("curium_246", 4138050));
        fluidList.addAll(NCFissionFluids.fissionFluids("curium_247", 3282485));
        fluidList.addAll(NCFissionFluids.fissionFluids("berkelium_247", 5907201));
        fluidList.addAll(NCFissionFluids.fissionFluids("berkelium_248", 6300930));
        fluidList.addAll(NCFissionFluids.fissionFluids("californium_249", 4590866));
        fluidList.addAll(NCFissionFluids.fissionFluids("californium_250", 4066324));
        fluidList.addAll(NCFissionFluids.fissionFluids("californium_251", 3869462));
        fluidList.addAll(NCFissionFluids.fissionFluids("californium_252", 4393742));
        fluidList.addAll(NCFissionFluids.fissionFluids("fuel_tbu", 0x272727));
        fluidList.addAll(NCFissionFluids.fissionFluids("fuel_leu_233", 1913371));
        fluidList.addAll(NCFissionFluids.fissionFluids("fuel_heu_233", 1194765));
        fluidList.addAll(NCFissionFluids.fissionFluids("fuel_leu_235", 1913371));
        fluidList.addAll(NCFissionFluids.fissionFluids("fuel_heu_235", 1194765));
        fluidList.addAll(NCFissionFluids.fissionFluids("fuel_len_236", 1782066));
        fluidList.addAll(NCFissionFluids.fissionFluids("fuel_hen_236", 866619));
        fluidList.addAll(NCFissionFluids.fissionFluids("fuel_lep_239", 0x949494));
        fluidList.addAll(NCFissionFluids.fissionFluids("fuel_hep_239", 0x8A8A8A));
        fluidList.addAll(NCFissionFluids.fissionFluids("fuel_lep_241", 0x969696));
        fluidList.addAll(NCFissionFluids.fissionFluids("fuel_hep_241", 0x8C8C8C));
        fluidList.addAll(NCFissionFluids.fissionFluids("fuel_lea_242", 3288091));
        fluidList.addAll(NCFissionFluids.fissionFluids("fuel_hea_242", 3878669));
        fluidList.addAll(NCFissionFluids.fissionFluids("fuel_lecm_243", 3152690));
        fluidList.addAll(NCFissionFluids.fissionFluids("fuel_hecm_243", 3542331));
        fluidList.addAll(NCFissionFluids.fissionFluids("fuel_lecm_245", 2955821));
        fluidList.addAll(NCFissionFluids.fissionFluids("fuel_hecm_245", 3410734));
        fluidList.addAll(NCFissionFluids.fissionFluids("fuel_lecm_247", 3350325));
        fluidList.addAll(NCFissionFluids.fissionFluids("fuel_hecm_247", 3739710));
        fluidList.addAll(NCFissionFluids.fissionFluids("fuel_leb_248", 4856580));
        fluidList.addAll(NCFissionFluids.fissionFluids("fuel_heb_248", 5708544));
        fluidList.addAll(NCFissionFluids.fissionFluids("fuel_lecf_249", 3998480));
        fluidList.addAll(NCFissionFluids.fissionFluids("fuel_hecf_249", 4850194));
        fluidList.addAll(NCFissionFluids.fissionFluids("fuel_lecf_251", 3801875));
        fluidList.addAll(NCFissionFluids.fissionFluids("fuel_hecf_251", 4588053));
        fluidList.addAll(NCFissionFluids.fissionFluids("depleted_fuel_tbu", 1914918));
        fluidList.addAll(NCFissionFluids.fissionFluids("depleted_fuel_leu_233", 0x5C5C53));
        fluidList.addAll(NCFissionFluids.fissionFluids("depleted_fuel_heu_233", 3426379));
        fluidList.addAll(NCFissionFluids.fissionFluids("depleted_fuel_leu_235", 3819837));
        fluidList.addAll(NCFissionFluids.fissionFluids("depleted_fuel_heu_235", 5067602));
        fluidList.addAll(NCFissionFluids.fissionFluids("depleted_fuel_len_236", 0x4E4E46));
        fluidList.addAll(NCFissionFluids.fissionFluids("depleted_fuel_hen_236", 0x646663));
        fluidList.addAll(NCFissionFluids.fissionFluids("depleted_fuel_lep_239", 6050909));
        fluidList.addAll(NCFissionFluids.fissionFluids("depleted_fuel_hep_239", 3747119));
        fluidList.addAll(NCFissionFluids.fissionFluids("depleted_fuel_lep_241", 4666433));
        fluidList.addAll(NCFissionFluids.fissionFluids("depleted_fuel_hep_241", 4202810));
        fluidList.addAll(NCFissionFluids.fissionFluids("depleted_fuel_lea_242", 3217456));
        fluidList.addAll(NCFissionFluids.fissionFluids("depleted_fuel_hea_242", 3742760));
        fluidList.addAll(NCFissionFluids.fissionFluids("depleted_fuel_lecm_243", 0x441F1F));
        fluidList.addAll(NCFissionFluids.fissionFluids("depleted_fuel_hecm_243", 4200736));
        fluidList.addAll(NCFissionFluids.fissionFluids("depleted_fuel_lecm_245", 4792858));
        fluidList.addAll(NCFissionFluids.fissionFluids("depleted_fuel_hecm_245", 4595993));
        fluidList.addAll(NCFissionFluids.fissionFluids("depleted_fuel_lecm_247", 4396306));
        fluidList.addAll(NCFissionFluids.fissionFluids("depleted_fuel_hecm_247", 0x441415));
        fluidList.addAll(NCFissionFluids.fissionFluids("depleted_fuel_leb_248", 4660002));
        fluidList.addAll(NCFissionFluids.fissionFluids("depleted_fuel_heb_248", 4726566));
        fluidList.addAll(NCFissionFluids.fissionFluids("depleted_fuel_lecf_249", 4922147));
        fluidList.addAll(NCFissionFluids.fissionFluids("depleted_fuel_hecf_249", 4790818));
        fluidList.addAll(NCFissionFluids.fissionFluids("depleted_fuel_lecf_251", 4856611));
        fluidList.addAll(NCFissionFluids.fissionFluids("depleted_fuel_hecf_251", 4922147));
    }
}

