/*
 * Decompiled with CFR 0.152.
 */
package nc.integration.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IIngredient;
import java.util.ArrayList;
import java.util.List;
import nc.integration.crafttweaker.CTMethods;
import nc.recipe.NCRecipes;
import nc.recipe.ProcessorRecipe;
import nc.recipe.ProcessorRecipeHandler;
import nc.recipe.ingredient.ChanceFluidIngredient;
import nc.recipe.ingredient.ChanceItemIngredient;
import nc.recipe.ingredient.EmptyFluidIngredient;
import nc.recipe.ingredient.EmptyItemIngredient;
import nc.recipe.ingredient.IFluidIngredient;
import nc.recipe.ingredient.IItemIngredient;
import nc.util.RecipeHelper;

public class AddProcessorRecipe
implements IAction {
    public static boolean hasErrored = false;
    public List<IItemIngredient> itemIngredients;
    public List<IFluidIngredient> fluidIngredients;
    public List<IItemIngredient> itemProducts;
    public List<IFluidIngredient> fluidProducts;
    public List extras;
    public ProcessorRecipe recipe;
    public boolean wasNull;
    public boolean wrongSize;
    public final NCRecipes.Type recipeType;

    public AddProcessorRecipe(NCRecipes.Type recipeType, List<Object> objects) {
        this.recipeType = recipeType;
        ProcessorRecipeHandler recipeHandler = recipeType.getRecipeHandler();
        int listCount = 0;
        int ingredientCount = 0;
        ArrayList<IItemIngredient> itemIngredients = new ArrayList<IItemIngredient>();
        ArrayList<IFluidIngredient> fluidIngredients = new ArrayList<IFluidIngredient>();
        ArrayList<IItemIngredient> itemProducts = new ArrayList<IItemIngredient>();
        ArrayList<IFluidIngredient> fluidProducts = new ArrayList<IFluidIngredient>();
        ArrayList<Object> extras = new ArrayList<Object>();
        while (listCount < objects.size()) {
            int chancePercent;
            Object ingredient;
            Object nextNextNextObject;
            Object object = objects.get(listCount);
            Object nextObject = listCount + 1 < objects.size() ? objects.get(listCount + 1) : null;
            Object nextNextObject = listCount + 2 < objects.size() ? objects.get(listCount + 2) : null;
            Object object2 = nextNextNextObject = listCount + 3 < objects.size() ? objects.get(listCount + 3) : null;
            if (ingredientCount < recipeHandler.itemInputSize) {
                if (object != null && !(object instanceof IIngredient)) {
                    this.wasNull = true;
                    return;
                }
                ingredient = CTMethods.buildAdditionItemIngredient(object, recipeType);
                if (ingredient == null) {
                    this.wasNull = true;
                    return;
                }
                itemIngredients.add((IItemIngredient)ingredient);
            } else if (ingredientCount < recipeHandler.itemInputSize + recipeHandler.fluidInputSize) {
                if (object != null && !(object instanceof IIngredient)) {
                    this.wasNull = true;
                    return;
                }
                ingredient = CTMethods.buildAdditionFluidIngredient(object, recipeType);
                if (ingredient == null) {
                    this.wasNull = true;
                    return;
                }
                fluidIngredients.add((IFluidIngredient)ingredient);
            } else if (ingredientCount < recipeHandler.itemInputSize + recipeHandler.fluidInputSize + recipeHandler.itemOutputSize) {
                if (object != null && !(object instanceof IIngredient)) {
                    this.wasNull = true;
                    return;
                }
                ingredient = CTMethods.buildAdditionItemIngredient(object, recipeType);
                if (ingredient == null) {
                    this.wasNull = true;
                    return;
                }
                if (nextObject instanceof Integer && nextNextObject instanceof Integer) {
                    chancePercent = (Integer)nextObject;
                    int minStackSize = (Integer)nextNextObject;
                    if (chancePercent <= 0) {
                        ingredient = new EmptyItemIngredient();
                    } else if (chancePercent < 100) {
                        ingredient = new ChanceItemIngredient((IItemIngredient)ingredient, chancePercent, minStackSize);
                    }
                    listCount += 2;
                } else if (nextObject instanceof Integer) {
                    chancePercent = (Integer)nextObject;
                    if (chancePercent <= 0) {
                        ingredient = new EmptyItemIngredient();
                    } else if (chancePercent < 100) {
                        ingredient = new ChanceItemIngredient((IItemIngredient)ingredient, chancePercent);
                    }
                    ++listCount;
                }
                itemProducts.add((IItemIngredient)ingredient);
            } else if (ingredientCount < recipeHandler.itemInputSize + recipeHandler.fluidInputSize + recipeHandler.itemOutputSize + recipeHandler.fluidOutputSize) {
                int stackDiff;
                if (object != null && !(object instanceof IIngredient)) {
                    this.wasNull = true;
                    return;
                }
                ingredient = CTMethods.buildAdditionFluidIngredient(object, recipeType);
                if (ingredient == null) {
                    this.wasNull = true;
                    return;
                }
                if (nextObject instanceof Integer && nextNextObject instanceof Integer && nextNextNextObject instanceof Integer) {
                    chancePercent = (Integer)nextObject;
                    stackDiff = (Integer)nextNextObject;
                    int minStackSize = (Integer)nextNextNextObject;
                    if (chancePercent <= 0) {
                        ingredient = new EmptyFluidIngredient();
                    } else if (chancePercent < 100) {
                        ingredient = new ChanceFluidIngredient((IFluidIngredient)ingredient, chancePercent, stackDiff, minStackSize);
                    }
                    listCount += 3;
                } else if (nextObject instanceof Integer && nextNextObject instanceof Integer) {
                    chancePercent = (Integer)nextObject;
                    stackDiff = (Integer)nextNextObject;
                    if (chancePercent <= 0) {
                        ingredient = new EmptyFluidIngredient();
                    } else if (chancePercent < 100) {
                        ingredient = new ChanceFluidIngredient((IFluidIngredient)ingredient, chancePercent, stackDiff);
                    }
                    listCount += 2;
                }
                fluidProducts.add((IFluidIngredient)ingredient);
            } else {
                extras.add(object);
            }
            ++listCount;
            ++ingredientCount;
        }
        if (itemIngredients.size() != recipeHandler.itemInputSize || fluidIngredients.size() != recipeHandler.fluidInputSize || itemProducts.size() != recipeHandler.itemOutputSize || fluidProducts.size() != recipeHandler.fluidOutputSize) {
            CraftTweakerAPI.logError((String)("A " + recipeType.getRecipeName() + " recipe was the wrong size"));
            this.wrongSize = true;
            return;
        }
        this.itemIngredients = itemIngredients;
        this.fluidIngredients = fluidIngredients;
        this.itemProducts = itemProducts;
        this.fluidProducts = fluidProducts;
        this.extras = extras;
        this.recipe = recipeType.getRecipeHandler().buildRecipe(itemIngredients, fluidIngredients, itemProducts, fluidProducts, extras, recipeType.getRecipeHandler().shapeless);
        if (this.recipe == null) {
            this.wasNull = true;
        }
    }

    public void apply() {
        boolean added;
        if (!this.wasNull && !this.wrongSize && (added = this.recipeType.getRecipeHandler().addRecipe(this.recipe))) {
            return;
        }
        AddProcessorRecipe.callError();
    }

    public String describe() {
        if (this.wasNull || this.wrongSize) {
            return String.format("Error: Failed to add %s recipe: %s", this.recipeType.getRecipeName(), RecipeHelper.getRecipeString(this.itemIngredients, this.fluidIngredients, this.itemProducts, this.fluidProducts));
        }
        return String.format("Adding %s recipe: %s", this.recipeType.getRecipeName(), RecipeHelper.getRecipeString(this.itemIngredients, this.fluidIngredients, this.itemProducts, this.fluidProducts));
    }

    public static void callError() {
        if (!hasErrored) {
            CraftTweakerAPI.logError((String)"At least one NuclearCraft CraftTweaker recipe addition method has errored - check the CraftTweaker log for more details");
        }
        hasErrored = true;
    }
}

