/*
 * Decompiled with CFR 0.152.
 */
package nc.item;

import nc.capability.radiation.IEntityRads;
import nc.config.NCConfig;
import nc.handler.SoundHandler;
import nc.item.NCItem;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;

public class ItemRadaway
extends NCItem {
    public ItemRadaway(String nameIn, String ... tooltip) {
        super(nameIn, tooltip);
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityLivingBase entity) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (!player.hasCapability(IEntityRads.CAPABILITY_ENTITY_RADS, null)) {
                return stack;
            }
            IEntityRads playerRads = (IEntityRads)player.getCapability(IEntityRads.CAPABILITY_ENTITY_RADS, null);
            if (playerRads == null) {
                return stack;
            }
            if (playerRads.canConsumeRadaway()) {
                world.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundHandler.radaway, SoundCategory.PLAYERS, 0.5f, 1.0f);
                this.onRadawayConsumed(stack, world, player);
                player.func_71029_a(StatList.func_188057_b((Item)this));
                if (player instanceof EntityPlayerMP) {
                    CriteriaTriggers.field_193138_y.func_193148_a((EntityPlayerMP)player, stack);
                }
                stack.func_190918_g(1);
                playerRads.setConsumedMedicine(true);
                playerRads.setRadawayCooldown(NCConfig.radiation_radaway_cooldown);
            } else {
                playerRads.setConsumedMedicine(false);
            }
        }
        return stack;
    }

    private void onRadawayConsumed(ItemStack stack, World world, EntityPlayer player) {
        if (world.field_72995_K || !player.hasCapability(IEntityRads.CAPABILITY_ENTITY_RADS, null)) {
            return;
        }
        IEntityRads playerRads = (IEntityRads)player.getCapability(IEntityRads.CAPABILITY_ENTITY_RADS, null);
        if (playerRads == null) {
            return;
        }
        playerRads.setRadawayBuffer(playerRads.getRadawayBuffer() + NCConfig.radiation_radaway_amount);
    }

    public int func_77626_a(ItemStack stack) {
        return 16;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!player.hasCapability(IEntityRads.CAPABILITY_ENTITY_RADS, null)) {
            return this.actionResult(false, stack);
        }
        IEntityRads playerRads = (IEntityRads)player.getCapability(IEntityRads.CAPABILITY_ENTITY_RADS, null);
        if (playerRads == null) {
            return this.actionResult(false, stack);
        }
        if (!playerRads.canConsumeRadaway()) {
            playerRads.setConsumedMedicine(false);
            return this.actionResult(false, stack);
        }
        if (!playerRads.isTotalRadsNegligible()) {
            player.func_184598_c(hand);
            return this.actionResult(true, stack);
        }
        return this.actionResult(false, stack);
    }
}

