/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock;

import javax.annotation.Nullable;
import nc.block.tile.IActivatable;
import nc.capability.radiation.IRadiationSource;
import nc.capability.radiation.RadiationSource;
import nc.multiblock.WorldHelper;
import nc.tile.ITile;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;

public abstract class TileBeefBase
extends TileEntity
implements ITile,
ITickable {
    public boolean isAdded;
    public boolean isMarkedDirty;
    private IRadiationSource radiation = new RadiationSource();

    public void func_73660_a() {
        if (!this.isAdded) {
            this.onAdded();
            this.isAdded = true;
        }
        if (this.isMarkedDirty) {
            this.func_70296_d();
            this.isMarkedDirty = false;
        }
    }

    public void onAdded() {
        if (this.field_145850_b.field_72995_K) {
            this.func_145831_w().func_175704_b(this.field_174879_c, this.field_174879_c);
            this.func_145831_w().func_175726_f(this.func_174877_v()).func_76630_e();
        }
        this.func_70296_d();
    }

    @Override
    public World getTileWorld() {
        return this.func_145831_w();
    }

    @Override
    public BlockPos getTilePos() {
        return this.func_174877_v();
    }

    @Override
    public void markTileDirty() {
        this.func_70296_d();
    }

    @Override
    public Block getTileBlockType() {
        return this.func_145838_q();
    }

    @Override
    public IRadiationSource getRadiationSource() {
        return this.radiation;
    }

    public boolean isUseableByPlayer(EntityPlayer entityplayer) {
        BlockPos position = this.func_174877_v();
        if (this.func_145831_w().func_175625_s(position) != this) {
            return false;
        }
        return entityplayer.func_70092_e((double)position.func_177958_n() + 0.5, (double)position.func_177956_o() + 0.5, (double)position.func_177952_p() + 0.5) <= 64.0;
    }

    @Override
    public void setState(boolean isActive) {
        if (this.func_145838_q() instanceof IActivatable) {
            ((IActivatable)this.func_145838_q()).setState(isActive, this.field_145850_b, this.field_174879_c);
        }
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing side) {
        if (capability == IRadiationSource.CAPABILITY_RADIATION_SOURCE) {
            return this.radiation != null;
        }
        return super.hasCapability(capability, side);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing side) {
        if (capability == IRadiationSource.CAPABILITY_RADIATION_SOURCE) {
            return (T)this.radiation;
        }
        return (T)super.getCapability(capability, side);
    }

    public boolean canOpenGui(World world, BlockPos posistion, IBlockState state) {
        return false;
    }

    public boolean openGui(Object mod, EntityPlayer player, int guiId) {
        player.openGui(mod, guiId, this.func_145831_w(), this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
        return true;
    }

    public Object getServerGuiElement(int guiId, EntityPlayer player) {
        return null;
    }

    public Object getClientGuiElement(int guiId, EntityPlayer player) {
        return null;
    }

    public void readRadiation(NBTTagCompound data) {
        if (data.func_74764_b("radiationLevel")) {
            this.getRadiationSource().setRadiationLevel(data.func_74769_h("radiationLevel"));
        }
    }

    public NBTTagCompound writeRadiation(NBTTagCompound data) {
        data.func_74780_a("radiationLevel", this.getRadiationSource().getRadiationLevel());
        return data;
    }

    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.syncDataFrom(data, SyncReason.FullSync);
        this.readAll(data);
    }

    public void readAll(NBTTagCompound data) {
        if (this.shouldSaveRadiation()) {
            this.readRadiation(data);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound data) {
        super.func_189515_b(data);
        this.syncDataTo(super.func_189515_b(data), SyncReason.FullSync);
        this.writeAll(data);
        return data;
    }

    public NBTTagCompound writeAll(NBTTagCompound data) {
        if (this.shouldSaveRadiation()) {
            this.writeRadiation(data);
        }
        return data;
    }

    public void handleUpdateTag(NBTTagCompound data) {
        super.handleUpdateTag(data);
        this.syncDataFrom(data, SyncReason.NetworkUpdate);
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound data = super.func_189517_E_();
        this.writeAll(data);
        this.syncDataTo(data, SyncReason.NetworkUpdate);
        return data;
    }

    public final void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.readAll(packet.func_148857_g());
        this.syncDataFrom(packet.func_148857_g(), SyncReason.NetworkUpdate);
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound data = new NBTTagCompound();
        this.writeAll(data);
        int metadata = this.func_145832_p();
        this.syncDataTo(data, SyncReason.NetworkUpdate);
        return new SPacketUpdateTileEntity(this.func_174877_v(), metadata, data);
    }

    protected abstract void syncDataFrom(NBTTagCompound var1, SyncReason var2);

    protected abstract void syncDataTo(NBTTagCompound var1, SyncReason var2);

    public void onChunkUnload() {
        if (!this.field_145846_f) {
            this.func_145843_s();
        }
    }

    public void markChunkDirty() {
        this.func_145831_w().func_175646_b(this.func_174877_v(), (TileEntity)this);
    }

    public void callNeighborBlockChange() {
        this.func_145831_w().func_175685_c(this.func_174877_v(), this.func_145838_q(), true);
    }

    @Deprecated
    public void callNeighborTileChange() {
    }

    public void notifyBlockUpdate() {
        WorldHelper.notifyBlockUpdate(this.func_145831_w(), this.func_174877_v(), null, null);
    }

    public void notifyBlockUpdate(IBlockState oldState, IBlockState newState) {
        WorldHelper.notifyBlockUpdate(this.func_145831_w(), this.func_174877_v(), oldState, newState);
    }

    public void nofityTileEntityUpdate() {
        this.func_70296_d();
        WorldHelper.notifyBlockUpdate(this.func_145831_w(), this.func_174877_v(), null, null);
    }

    public static enum SyncReason {
        FullSync,
        NetworkUpdate;

    }
}

