/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock.network;

import io.netty.buffer.ByteBuf;
import nc.multiblock.network.MultiblockUpdatePacket;
import nc.multiblock.saltFission.SaltFissionReactor;
import nc.multiblock.saltFission.tile.TileSaltFissionController;
import net.minecraft.util.math.BlockPos;

public class SaltFissionUpdatePacket
extends MultiblockUpdatePacket {
    protected boolean isReactorOn;
    protected double cooling;
    protected double heating;
    protected double efficiency;
    protected double heatMult;
    protected double coolingRate;
    protected long capacity;
    protected long heat;

    public SaltFissionUpdatePacket() {
        this.messageValid = false;
    }

    public SaltFissionUpdatePacket(BlockPos pos, boolean isReactorOn, double cooling, double heating, double efficiency, double heatMult, double coolingRate, long capacity, long heat) {
        this.pos = pos;
        this.isReactorOn = isReactorOn;
        this.cooling = cooling;
        this.heating = heating;
        this.efficiency = efficiency;
        this.heatMult = heatMult;
        this.coolingRate = coolingRate;
        this.capacity = capacity;
        this.heat = heat;
        this.messageValid = true;
    }

    @Override
    public void readMessage(ByteBuf buf) {
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.isReactorOn = buf.readBoolean();
        this.cooling = buf.readDouble();
        this.heating = buf.readDouble();
        this.efficiency = buf.readDouble();
        this.heatMult = buf.readDouble();
        this.coolingRate = buf.readDouble();
        this.capacity = buf.readLong();
        this.heat = buf.readLong();
    }

    @Override
    public void writeMessage(ByteBuf buf) {
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        buf.writeBoolean(this.isReactorOn);
        buf.writeDouble(this.cooling);
        buf.writeDouble(this.heating);
        buf.writeDouble(this.efficiency);
        buf.writeDouble(this.heatMult);
        buf.writeDouble(this.coolingRate);
        buf.writeLong(this.capacity);
        buf.writeLong(this.heat);
    }

    public static class Handler
    extends MultiblockUpdatePacket.Handler<SaltFissionUpdatePacket, SaltFissionReactor, TileSaltFissionController> {
        public Handler() {
            super(TileSaltFissionController.class);
        }

        @Override
        protected void onPacket(SaltFissionUpdatePacket message, SaltFissionReactor reactor) {
            reactor.onPacket(message.isReactorOn, message.cooling, message.heating, message.efficiency, message.heatMult, message.coolingRate, message.capacity, message.heat);
        }
    }
}

