/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock.saltFission;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import nc.config.NCConfig;
import nc.handler.SoundHandler;
import nc.multiblock.IMultiblockPart;
import nc.multiblock.MultiblockBase;
import nc.multiblock.TileBeefBase;
import nc.multiblock.container.ContainerSaltFissionController;
import nc.multiblock.cuboidal.CuboidalMultiblockBase;
import nc.multiblock.network.SaltFissionUpdatePacket;
import nc.multiblock.saltFission.tile.TileSaltFissionController;
import nc.multiblock.saltFission.tile.TileSaltFissionDistributor;
import nc.multiblock.saltFission.tile.TileSaltFissionHeater;
import nc.multiblock.saltFission.tile.TileSaltFissionModerator;
import nc.multiblock.saltFission.tile.TileSaltFissionRedstonePort;
import nc.multiblock.saltFission.tile.TileSaltFissionRetriever;
import nc.multiblock.saltFission.tile.TileSaltFissionVent;
import nc.multiblock.saltFission.tile.TileSaltFissionVessel;
import nc.multiblock.validation.IMultiblockValidator;
import nc.tile.internal.fluid.Tank;
import nc.tile.internal.heat.HeatBuffer;
import nc.util.RegistryHelper;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class SaltFissionReactor
extends CuboidalMultiblockBase<SaltFissionUpdatePacket> {
    private Set<TileSaltFissionController> controllers;
    private Set<TileSaltFissionVent> vents;
    private Set<TileSaltFissionVessel> vessels;
    private Set<TileSaltFissionHeater> heaters;
    private Set<TileSaltFissionModerator> moderators;
    private Set<TileSaltFissionDistributor> distributors;
    private Set<TileSaltFissionRetriever> retrievers;
    private Set<TileSaltFissionRedstonePort> redstonePorts;
    private TileSaltFissionController controller;
    private Random rand = new Random();
    public int comparatorSignal = 0;
    public boolean redstoneSignal;
    private int updateCount = 0;
    private int distributeCount = 0;
    public boolean isReactorOn;
    public double cooling;
    public double heating;
    public double efficiency;
    public double heatMult;
    public double coolingRate;
    public final HeatBuffer heatBuffer;
    private static final int BASE_MAX_HEAT = 25000;
    private static final ArrayList<String> STAGE_0_COOLANTS = Lists.newArrayList((Object[])new String[]{"nak", "redstone_nak", "quartz_nak", "glowstone_nak", "lapis_nak", "ender_nak", "cryotheum_nak", "emerald_nak", "magnesium_nak"});
    private static final ArrayList<String> STAGE_1_COOLANTS = Lists.newArrayList((Object[])new String[]{"gold_nak", "diamond_nak", "liquidhelium_nak", "copper_nak", "tin_nak"});
    private static final ArrayList<String> STAGE_2_COOLANTS = Lists.newArrayList((Object[])new String[]{"iron_nak"});

    public SaltFissionReactor(World world) {
        super(world);
        this.controllers = new HashSet<TileSaltFissionController>();
        this.vents = new HashSet<TileSaltFissionVent>();
        this.vessels = new HashSet<TileSaltFissionVessel>();
        this.heaters = new HashSet<TileSaltFissionHeater>();
        this.moderators = new HashSet<TileSaltFissionModerator>();
        this.distributors = new HashSet<TileSaltFissionDistributor>();
        this.retrievers = new HashSet<TileSaltFissionRetriever>();
        this.redstonePorts = new HashSet<TileSaltFissionRedstonePort>();
        this.heatBuffer = new HeatBuffer(25000L);
    }

    public Set<TileSaltFissionController> getControllers() {
        return this.controllers;
    }

    public Set<TileSaltFissionVent> getVents() {
        return this.vents;
    }

    public Set<TileSaltFissionVessel> getVessels() {
        return this.vessels;
    }

    public Set<TileSaltFissionHeater> getHeaters() {
        return this.heaters;
    }

    public Set<TileSaltFissionModerator> getModerators() {
        return this.moderators;
    }

    public Set<TileSaltFissionDistributor> getDistributors() {
        return this.distributors;
    }

    public Set<TileSaltFissionRetriever> getRetrievers() {
        return this.retrievers;
    }

    public Set<TileSaltFissionRedstonePort> getRedstonePorts() {
        return this.redstonePorts;
    }

    @Override
    protected int getMinimumInteriorLength() {
        return NCConfig.salt_fission_min_size;
    }

    @Override
    protected int getMaximumInteriorLength() {
        return NCConfig.salt_fission_max_size;
    }

    @Override
    public void onAttachedPartWithMultiblockData(IMultiblockPart part, NBTTagCompound data) {
        this.syncDataFrom(data, TileBeefBase.SyncReason.FullSync);
    }

    @Override
    protected void onBlockAdded(IMultiblockPart newPart) {
        if (newPart instanceof TileSaltFissionController) {
            this.controllers.add((TileSaltFissionController)newPart);
        } else if (newPart instanceof TileSaltFissionVent) {
            this.vents.add((TileSaltFissionVent)newPart);
        } else if (newPart instanceof TileSaltFissionVessel) {
            this.vessels.add((TileSaltFissionVessel)newPart);
        } else if (newPart instanceof TileSaltFissionHeater) {
            this.heaters.add((TileSaltFissionHeater)newPart);
        } else if (newPart instanceof TileSaltFissionModerator) {
            this.moderators.add((TileSaltFissionModerator)newPart);
        } else if (newPart instanceof TileSaltFissionDistributor) {
            this.distributors.add((TileSaltFissionDistributor)newPart);
        } else if (newPart instanceof TileSaltFissionRetriever) {
            this.retrievers.add((TileSaltFissionRetriever)newPart);
        } else if (newPart instanceof TileSaltFissionRedstonePort) {
            this.redstonePorts.add((TileSaltFissionRedstonePort)newPart);
        }
    }

    @Override
    protected void onBlockRemoved(IMultiblockPart oldPart) {
        if (oldPart instanceof TileSaltFissionController) {
            this.controllers.remove(oldPart);
        } else if (oldPart instanceof TileSaltFissionVent) {
            this.vents.remove(oldPart);
        } else if (oldPart instanceof TileSaltFissionVessel) {
            this.vessels.remove(oldPart);
        } else if (oldPart instanceof TileSaltFissionHeater) {
            this.heaters.remove(oldPart);
        } else if (oldPart instanceof TileSaltFissionModerator) {
            this.moderators.remove(oldPart);
        } else if (oldPart instanceof TileSaltFissionDistributor) {
            this.distributors.remove(oldPart);
        } else if (oldPart instanceof TileSaltFissionRetriever) {
            this.retrievers.remove(oldPart);
        } else if (oldPart instanceof TileSaltFissionRedstonePort) {
            this.redstonePorts.remove(oldPart);
        }
    }

    @Override
    protected void onMachineAssembled() {
        Iterator<TileSaltFissionController> iterator = this.controllers.iterator();
        while (iterator.hasNext()) {
            TileSaltFissionController contr;
            this.controller = contr = iterator.next();
        }
        this.calculateReactorStats();
    }

    @Override
    protected void onMachineRestored() {
        this.calculateReactorStats();
    }

    @Override
    protected void onMachinePaused() {
    }

    @Override
    protected void onMachineDisassembled() {
        this.isReactorOn = false;
    }

    @Override
    protected boolean isMachineWhole(IMultiblockValidator validatorCallback) {
        if (this.controllers.size() == 0) {
            validatorCallback.setLastError("nuclearcraft.multiblock_validation.no_controller", null, new Object[0]);
            return false;
        }
        if (this.controllers.size() > 1) {
            validatorCallback.setLastError("nuclearcraft.multiblock_validation.too_many_controllers", null, new Object[0]);
            return false;
        }
        return super.isMachineWhole(validatorCallback);
    }

    @Override
    protected void onAssimilate(MultiblockBase assimilated) {
        SaltFissionReactor newController = (SaltFissionReactor)assimilated;
        this.heatBuffer.mergeHeatBuffers(newController.heatBuffer);
    }

    @Override
    protected void onAssimilated(MultiblockBase assimilator) {
    }

    @Override
    protected boolean updateServer() {
        this.setIsReactorOn();
        if (this.shouldDistribute()) {
            this.distributeFuel();
        }
        if (this.shouldUpdate()) {
            this.calculateReactorStats();
            this.updateRedstonePorts();
        }
        if (this.heatBuffer.isFull() && NCConfig.salt_fission_overheat) {
            this.heatBuffer.setHeatStored(0L);
            this.doMeltdown();
            return true;
        }
        if (this.shouldUpdate()) {
            this.sendUpdateToListeningPlayers();
        }
        this.incrementUpdateCount();
        return true;
    }

    protected void setIsReactorOn() {
        boolean oldIsReactorOn = this.isReactorOn;
        boolean bl = this.isReactorOn = this.isRedstonePowered() && this.isAssembled();
        if (this.isReactorOn != oldIsReactorOn) {
            this.sendUpdateToAllPlayers();
        }
    }

    protected boolean isRedstonePowered() {
        if (this.controller.isRedstonePowered()) {
            return true;
        }
        for (TileSaltFissionRedstonePort redstonePort : this.redstonePorts) {
            if (!redstonePort.isRedstonePowered()) continue;
            return true;
        }
        return false;
    }

    protected void distributeFuel() {
        Tank vesselTank;
        int count;
        if (this.distributors.size() < 1 || this.vessels.size() < 1) {
            return;
        }
        for (TileSaltFissionVessel vessel : this.vessels) {
            vessel.distributedTo = false;
            vessel.retrievedFrom = false;
        }
        int rate = Math.max(1, NCConfig.salt_fission_max_distribution_rate / this.vessels.size());
        block1: for (TileSaltFissionDistributor distributor : this.distributors) {
            count = NCConfig.salt_fission_max_distribution_rate;
            Tank distributorTank = distributor.getTanks().get(0);
            for (TileSaltFissionVessel vessel : this.vessels) {
                if (count < 1 || distributorTank.isEmpty()) continue block1;
                if (vessel.distributedTo) continue;
                vesselTank = vessel.getTanks().get(0);
                distributorTank.drainInternal(vesselTank.fillInternal(distributorTank.drainInternal(rate, false), true), true);
                vessel.distributedTo = true;
                count -= rate;
            }
        }
        block3: for (TileSaltFissionRetriever retriever : this.retrievers) {
            count = NCConfig.salt_fission_max_distribution_rate;
            Tank retrieverTank = retriever.getTanks().get(0);
            for (TileSaltFissionVessel vessel : this.vessels) {
                if (count < 1 || retrieverTank.isFull()) continue block3;
                if (vessel.retrievedFrom) continue;
                vesselTank = vessel.getTanks().get(1);
                vesselTank.drainInternal(retrieverTank.fillInternal(vesselTank.drainInternal(rate, false), true), true);
                vessel.retrievedFrom = true;
                count -= rate;
            }
        }
    }

    protected void calculateReactorStats() {
        this.heatBuffer.setHeatCapacity(25000 * this.getNumConnectedBlocks());
        this.setVesselStats();
        this.doHeaterPlacementChecks();
        this.setCooling();
        this.heatBuffer.changeHeatStored((long)((double)this.updateTime() * this.getHeatChange(true)));
        this.setCoolingRate();
    }

    protected void updateRedstonePorts() {
        this.comparatorSignal = (int)MathHelper.func_151237_a((double)(1500.0 / (double)NCConfig.fission_comparator_max_heat * (double)this.heatBuffer.heatStored / (double)this.heatBuffer.heatCapacity), (double)0.0, (double)15.0);
        for (TileSaltFissionRedstonePort redstonePort : this.redstonePorts) {
            if (redstonePort.comparatorSignal == this.comparatorSignal) continue;
            redstonePort.comparatorSignal = this.comparatorSignal;
            this.WORLD.func_175666_e(redstonePort.func_174877_v(), null);
        }
    }

    protected void setVesselStats() {
        for (TileSaltFissionModerator moderator : this.moderators) {
            moderator.isInValidPosition = false;
            moderator.isInModerationLine = false;
        }
        if (this.vessels.size() < 1) {
            this.efficiency = 0.0;
            this.heatMult = 0.0;
            this.heating = 0.0;
        } else {
            double newEfficiency = 0.0;
            double newHeatMult = 0.0;
            double newHeating = 0.0;
            for (TileSaltFissionVessel vessel : this.vessels) {
                vessel.calculateEfficiency();
                newEfficiency += vessel.getEfficiency();
                newHeatMult += vessel.getHeatMultiplier();
                newHeating += vessel.getProcessHeat();
            }
            this.efficiency = newEfficiency / (double)this.vessels.size();
            this.heatMult = newHeatMult / (double)this.vessels.size();
            this.heating = newHeating;
            for (TileSaltFissionModerator moderator : this.moderators) {
                if (!moderator.contributeExtraHeat()) continue;
                this.heating += newHeating / (double)this.vessels.size();
            }
        }
    }

    protected void doHeaterPlacementChecks() {
        for (TileSaltFissionHeater heater : this.heaters) {
            heater.checked = false;
        }
        for (int i = 0; i <= 2; ++i) {
            for (TileSaltFissionHeater heater : this.heaters) {
                if (heater.checked) continue;
                heater.checkIsInValidPosition();
            }
        }
    }

    protected void setCooling() {
        double newCooling = 0.0;
        for (TileSaltFissionHeater heater : this.heaters) {
            if (!heater.isInValidPosition) continue;
            newCooling += heater.getProcessCooling();
        }
        this.cooling = newCooling;
    }

    public double getHeatChange(boolean checkIsReactorOn) {
        return this.isReactorOn || !checkIsReactorOn ? this.heating - this.cooling : -this.cooling;
    }

    protected void setCoolingRate() {
        if (this.vessels.size() <= 0 || this.cooling <= 0.0) {
            this.coolingRate = 0.0;
        } else {
            this.coolingRate = this.getHeatChange(false) >= 0.0 ? this.efficiency : this.efficiency * this.heating / this.cooling;
            for (TileSaltFissionHeater heater : this.heaters) {
                heater.reactorCoolingRate = !this.isReactorOn && this.coolingRate * (double)this.heatBuffer.heatStored < this.cooling ? this.coolingRate * (double)this.heatBuffer.heatStored / this.cooling : this.coolingRate;
            }
        }
    }

    protected void doMeltdown() {
        Iterator<TileSaltFissionVessel> vesselIterator = this.vessels.iterator();
        while (vesselIterator.hasNext()) {
            TileSaltFissionVessel vessel = vesselIterator.next();
            vesselIterator.remove();
            vessel.doMeltdown();
        }
        Iterator<TileSaltFissionController> controllerIterator = this.controllers.iterator();
        while (controllerIterator.hasNext()) {
            TileSaltFissionController controller = controllerIterator.next();
            controllerIterator.remove();
            controller.doMeltdown();
        }
        for (BlockPos blockPos : BlockPos.func_177975_b((BlockPos)this.getMinimumCoord(), (BlockPos)this.getMaximumCoord())) {
            Block corium;
            if (!(this.rand.nextDouble() < 0.18)) continue;
            if (this.WORLD.func_175625_s(blockPos) != null) {
                this.WORLD.func_175713_t(blockPos);
            }
            if ((corium = RegistryHelper.getBlock("nuclearcraft:fluid_corium")) == null) continue;
            this.WORLD.func_175656_a(blockPos, corium.func_176223_P());
        }
        this.checkIfMachineIsWhole();
    }

    private void incrementUpdateCount() {
        ++this.updateCount;
        this.updateCount %= this.updateTime();
        ++this.distributeCount;
        this.distributeCount %= this.distributeTime();
    }

    private int updateTime() {
        return NCConfig.machine_update_rate / 2;
    }

    private boolean shouldUpdate() {
        return this.updateCount == 0;
    }

    private int distributeTime() {
        return 20;
    }

    private boolean shouldDistribute() {
        return this.distributeCount == 0;
    }

    @Override
    protected void updateClient() {
        if (this.isReactorOn) {
            for (TileSaltFissionVessel vessel : this.vessels) {
                this.playFissionSound(vessel.func_174877_v());
            }
        }
    }

    protected void playFissionSound(BlockPos pos) {
        if (this.vessels.size() <= 0) {
            return;
        }
        double soundRate = Math.min(this.efficiency / (14.0 * (double)NCConfig.salt_fission_max_size * Math.sqrt(this.vessels.size())), 1.0 / (double)this.vessels.size());
        if (this.rand.nextDouble() < soundRate) {
            this.WORLD.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundHandler.geiger_tick, SoundCategory.BLOCKS, 1.6f, 1.0f + 0.12f * (this.rand.nextFloat() - 0.5f), false);
        }
    }

    @Override
    protected void syncDataTo(NBTTagCompound data, TileBeefBase.SyncReason syncReason) {
        this.heatBuffer.writeToNBT(data);
        data.func_74768_a("comparatorSignal", this.comparatorSignal);
        data.func_74757_a("redstoneSignal", this.redstoneSignal);
        data.func_74757_a("isReactorOn", this.isReactorOn);
        data.func_74780_a("cooling", this.cooling);
        data.func_74780_a("heating", this.heating);
        data.func_74780_a("efficiency", this.efficiency);
        data.func_74780_a("heatMult", this.heatMult);
        data.func_74780_a("coolingRate", this.coolingRate);
    }

    @Override
    protected void syncDataFrom(NBTTagCompound data, TileBeefBase.SyncReason syncReason) {
        this.heatBuffer.readFromNBT(data);
        this.comparatorSignal = data.func_74762_e("comparatorSignal");
        this.redstoneSignal = data.func_74767_n("redstoneSignal");
        this.isReactorOn = data.func_74767_n("isReactorOn");
        this.cooling = data.func_74769_h("cooling");
        this.heating = data.func_74769_h("heating");
        this.efficiency = data.func_74769_h("efficiency");
        this.heatMult = data.func_74769_h("heatMult");
        this.coolingRate = data.func_74769_h("coolingRate");
    }

    @Override
    protected SaltFissionUpdatePacket getUpdatePacket() {
        return new SaltFissionUpdatePacket(this.controller.func_174877_v(), this.isReactorOn, this.cooling, this.heating, this.efficiency, this.heatMult, this.coolingRate, this.heatBuffer.getHeatCapacity(), this.heatBuffer.getHeatStored());
    }

    public void onPacket(boolean isReactorOn, double cooling, double heating, double efficiency, double heatMult, double coolingRate, long capacity, long heat) {
        this.isReactorOn = isReactorOn;
        this.cooling = cooling;
        this.heating = heating;
        this.efficiency = efficiency;
        this.heatMult = heatMult;
        this.coolingRate = coolingRate;
        this.heatBuffer.setHeatCapacity(capacity);
        this.heatBuffer.setHeatStored(heat);
    }

    public Container getContainer(EntityPlayer player) {
        return new ContainerSaltFissionController(player, this.controller);
    }

    @Override
    protected boolean isBlockGoodForInterior(World world, int x, int y, int z, IMultiblockValidator validatorCallback) {
        return true;
    }
}

