/*
 * Decompiled with CFR 0.152.
 */
package nc.recipe;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import nc.recipe.AbstractRecipeHandler;
import nc.recipe.ProcessorRecipe;
import nc.recipe.ingredient.IFluidIngredient;
import nc.recipe.ingredient.IItemIngredient;
import nc.util.NCUtil;
import nc.util.RecipeHelper;

public abstract class ProcessorRecipeHandler
extends AbstractRecipeHandler<ProcessorRecipe> {
    public int itemInputSize;
    public int fluidInputSize;
    public int itemOutputSize;
    public int fluidOutputSize;
    public final boolean shapeless;
    private final String recipeName;

    public ProcessorRecipeHandler(String recipeName, int itemInputSize, int fluidInputSize, int itemOutputSize, int fluidOutputSize) {
        this(recipeName, itemInputSize, fluidInputSize, itemOutputSize, fluidOutputSize, true);
    }

    public ProcessorRecipeHandler(String recipeName, int itemInputSize, int fluidInputSize, int itemOutputSize, int fluidOutputSize, boolean shapeless) {
        this.itemInputSize = itemInputSize;
        this.fluidInputSize = fluidInputSize;
        this.itemOutputSize = itemOutputSize;
        this.fluidOutputSize = fluidOutputSize;
        this.shapeless = shapeless;
        this.recipeName = recipeName;
        this.addRecipes();
    }

    @Override
    public void addRecipe(Object ... objects) {
        ArrayList<Object> itemInputs = new ArrayList<Object>();
        ArrayList<Object> fluidInputs = new ArrayList<Object>();
        ArrayList<Object> itemOutputs = new ArrayList<Object>();
        ArrayList<Object> fluidOutputs = new ArrayList<Object>();
        ArrayList<Object> extras = new ArrayList<Object>();
        for (int i = 0; i < objects.length; ++i) {
            Object object = objects[i];
            if (i < this.itemInputSize) {
                itemInputs.add(object);
                continue;
            }
            if (i < this.itemInputSize + this.fluidInputSize) {
                fluidInputs.add(object);
                continue;
            }
            if (i < this.itemInputSize + this.fluidInputSize + this.itemOutputSize) {
                itemOutputs.add(object);
                continue;
            }
            if (i < this.itemInputSize + this.fluidInputSize + this.itemOutputSize + this.fluidOutputSize) {
                fluidOutputs.add(object);
                continue;
            }
            extras.add(object);
        }
        this.addRecipe(this.buildRecipe(itemInputs, fluidInputs, itemOutputs, fluidOutputs, extras, this.shapeless));
    }

    public void addRecipe(List itemInputList, List fluidInputList, List itemOutputList, List fluidOutputList, List extrasList, boolean shapeless) {
        this.addRecipe(this.buildRecipe(itemInputList, fluidInputList, itemOutputList, fluidOutputList, extrasList, shapeless));
    }

    @Nullable
    public ProcessorRecipe buildRecipe(List itemInputs, List fluidInputs, List itemOutputs, List fluidOutputs, List extras, boolean shapeless) {
        Object output;
        Object input;
        ArrayList<IItemIngredient> itemIngredients = new ArrayList<IItemIngredient>();
        ArrayList<IItemIngredient> itemProducts = new ArrayList<IItemIngredient>();
        ArrayList<IFluidIngredient> fluidIngredients = new ArrayList<IFluidIngredient>();
        ArrayList<IFluidIngredient> fluidProducts = new ArrayList<IFluidIngredient>();
        for (Object obj : itemInputs) {
            if (obj != null && this.isValidItemInputType(obj)) {
                input = this.buildItemIngredient(obj);
                if (input == null) {
                    return null;
                }
                itemIngredients.add((IItemIngredient)input);
                continue;
            }
            return null;
        }
        for (Object obj : fluidInputs) {
            if (obj != null && this.isValidFluidInputType(obj)) {
                input = this.buildFluidIngredient(obj);
                if (input == null) {
                    return null;
                }
                fluidIngredients.add((IFluidIngredient)input);
                continue;
            }
            return null;
        }
        for (Object obj : itemOutputs) {
            if (obj != null && this.isValidItemOutputType(obj)) {
                output = this.buildItemIngredient(obj);
                if (output == null) {
                    return null;
                }
                itemProducts.add((IItemIngredient)output);
                continue;
            }
            return null;
        }
        for (Object obj : fluidOutputs) {
            if (obj != null && this.isValidFluidOutputType(obj)) {
                output = this.buildFluidIngredient(obj);
                if (output == null) {
                    return null;
                }
                fluidProducts.add((IFluidIngredient)output);
                continue;
            }
            return null;
        }
        if (!this.isValidRecipe(itemIngredients, fluidIngredients, itemProducts, fluidProducts)) {
            NCUtil.getLogger().info(this.getRecipeName() + " - a recipe was removed: " + RecipeHelper.getRecipeString(itemIngredients, fluidIngredients, itemProducts, fluidProducts));
        }
        return new ProcessorRecipe(itemIngredients, fluidIngredients, itemProducts, fluidProducts, extras, shapeless);
    }

    public boolean isValidRecipe(List<IItemIngredient> itemIngredients, List<IFluidIngredient> fluidIngredients, List<IItemIngredient> itemProducts, List<IFluidIngredient> fluidProducts) {
        return itemIngredients.size() == this.itemInputSize && fluidIngredients.size() == this.fluidInputSize && itemProducts.size() == this.itemOutputSize && fluidProducts.size() == this.fluidOutputSize;
    }

    @Override
    public String getRecipeName() {
        return "nuclearcraft_" + this.recipeName;
    }
}

