/*
 * Decompiled with CFR 0.152.
 */
package nc.recipe.generator;

import nc.config.NCConfig;
import nc.recipe.ProcessorRecipeHandler;
import nc.util.Lang;
import nc.util.RegistryHelper;

public class FissionRecipes
extends ProcessorRecipeHandler {
    public FissionRecipes() {
        super("fission", 1, 0, 1, 0);
    }

    @Override
    public void addRecipes() {
        this.addFuelRodDepleteRecipes("TBU", NCConfig.fission_thorium_fuel_time, NCConfig.fission_thorium_power, NCConfig.fission_thorium_heat_generation, NCConfig.fission_thorium_radiation);
        this.addFuelRodDepleteRecipes("U", NCConfig.fission_uranium_fuel_time, NCConfig.fission_uranium_power, NCConfig.fission_uranium_heat_generation, NCConfig.fission_uranium_radiation, 233, 235);
        this.addFuelRodDepleteRecipes("N", NCConfig.fission_neptunium_fuel_time, NCConfig.fission_neptunium_power, NCConfig.fission_neptunium_heat_generation, NCConfig.fission_neptunium_radiation, 236);
        this.addFuelRodDepleteRecipes("P", NCConfig.fission_plutonium_fuel_time, NCConfig.fission_plutonium_power, NCConfig.fission_plutonium_heat_generation, NCConfig.fission_plutonium_radiation, 239, 241);
        this.addRecipe("fuelMOX239", "depletedFuelMOX239", NCConfig.fission_mox_fuel_time[0], NCConfig.fission_mox_power[0], NCConfig.fission_mox_heat_generation[0], FissionRecipes.localiseFuel("mox_239"), NCConfig.fission_mox_radiation[0] / 8.0);
        this.addRecipe("fuelMOX241", "depletedFuelMOX241", NCConfig.fission_mox_fuel_time[1], NCConfig.fission_mox_power[1], NCConfig.fission_mox_heat_generation[1], FissionRecipes.localiseFuel("mox_241"), NCConfig.fission_mox_radiation[1] / 8.0);
        this.addRecipe("fuelRodMOX239", "depletedFuelRodMOX239", NCConfig.fission_mox_fuel_time[0], NCConfig.fission_mox_power[0], NCConfig.fission_mox_heat_generation[0], FissionRecipes.localiseFuel("mox_239"), NCConfig.fission_mox_radiation[0] / 8.0);
        this.addRecipe("fuelRodMOX241", "depletedFuelRodMOX241", NCConfig.fission_mox_fuel_time[1], NCConfig.fission_mox_power[1], NCConfig.fission_mox_heat_generation[1], FissionRecipes.localiseFuel("mox_241"), NCConfig.fission_mox_radiation[1] / 8.0);
        this.addFuelRodDepleteRecipes("A", NCConfig.fission_americium_fuel_time, NCConfig.fission_americium_power, NCConfig.fission_americium_heat_generation, NCConfig.fission_americium_radiation, 242);
        this.addFuelRodDepleteRecipes("Cm", NCConfig.fission_curium_fuel_time, NCConfig.fission_curium_power, NCConfig.fission_curium_heat_generation, NCConfig.fission_curium_radiation, 243, 245, 247);
        this.addFuelRodDepleteRecipes("B", NCConfig.fission_berkelium_fuel_time, NCConfig.fission_berkelium_power, NCConfig.fission_berkelium_heat_generation, NCConfig.fission_berkelium_radiation, 248);
        this.addFuelRodDepleteRecipes("Cf", NCConfig.fission_californium_fuel_time, NCConfig.fission_californium_power, NCConfig.fission_californium_heat_generation, NCConfig.fission_californium_radiation, 249, 251);
        this.addRecipe(RegistryHelper.itemStackFromRegistry("ic2:nuclear:0", 1), "depletedFuelIC2U", NCConfig.fission_uranium_fuel_time[4] * 19.0 / 54.0, NCConfig.fission_uranium_power[4] * 18.0 / 19.0, NCConfig.fission_uranium_heat_generation[4] * 18.0 / 19.0, "IC2-LEU", 0.125 * NCConfig.fission_uranium_radiation[4] * 18.0 / 19.0);
        this.addRecipe(RegistryHelper.itemStackFromRegistry("ic2:nuclear:4", 1), "depletedFuelIC2MOX", NCConfig.fission_mox_fuel_time[0] * 7.0 / 3.0, NCConfig.fission_mox_power[0] * 9.0 / 7.0, NCConfig.fission_mox_heat_generation[0] * 9.0 / 7.0, "IC2-MOX", 0.125 * NCConfig.fission_mox_radiation[0] * 9.0 / 7.0);
        this.addRecipe("ingotYellorium", "ingotCyanite", NCConfig.fission_uranium_fuel_time[4] / 8.0, NCConfig.fission_uranium_power[4] * 8.0 / 9.0, NCConfig.fission_uranium_heat_generation[4] * 8.0 / 9.0, "YELLO", 0.125 * NCConfig.fission_uranium_radiation[4] * 8.0 / 9.0);
        this.addRecipe("ingotBlutonium", "ingotCyanite", NCConfig.fission_uranium_fuel_time[4] / 8.0, NCConfig.fission_uranium_power[4] * 8.0 / 9.0, NCConfig.fission_uranium_heat_generation[4] * 8.0 / 9.0, "BLUTO", 0.125 * NCConfig.fission_uranium_radiation[4] * 8.0 / 9.0);
    }

    public void addFuelRodDepleteRecipes(String fuel, double[] time, double[] power, double[] heat, double[] radiation) {
        this.addRecipe("fuel" + fuel, "depletedFuel" + fuel, time[0], power[0], heat[0], FissionRecipes.localiseFuel(fuel.toLowerCase()), radiation[0] / 8.0);
        this.addRecipe("fuel" + fuel + "Oxide", "depletedFuel" + fuel + "Oxide", time[1], power[1], heat[1], FissionRecipes.localiseFuel(fuel.toLowerCase()) + "-" + FissionRecipes.localiseFuel("oxide"), radiation[1] / 8.0);
        this.addRecipe("fuelRod" + fuel, "depletedFuelRod" + fuel, time[0], power[0], heat[0], FissionRecipes.localiseFuel(fuel.toLowerCase()), radiation[0] / 8.0);
        this.addRecipe("fuelRod" + fuel + "Oxide", "depletedFuelRod" + fuel + "Oxide", time[1], power[1], heat[1], FissionRecipes.localiseFuel(fuel.toLowerCase()) + "-" + FissionRecipes.localiseFuel("oxide"), radiation[1] / 8.0);
    }

    public void addFuelRodDepleteRecipes(String fuel, double[] time, double[] power, double[] heat, double[] radiation, int ... types) {
        int count = 0;
        for (int type : types) {
            this.addFuelRodDepleteRecipes("LE" + fuel, type, count, time, power, heat, radiation);
            this.addFuelRodDepleteRecipes("HE" + fuel, type, count + 2, time, power, heat, radiation);
            count += 4;
        }
    }

    public void addFuelRodDepleteRecipes(String fuel, int type, int meta, double[] time, double[] power, double[] heat, double[] radiation) {
        this.addRecipe("fuel" + fuel + type, "depletedFuel" + fuel + type, time[meta], power[meta], heat[meta], FissionRecipes.localiseFuel(fuel.toLowerCase()) + "-" + type, radiation[meta] / 8.0);
        this.addRecipe("fuel" + fuel + type + "Oxide", "depletedFuel" + fuel + type + "Oxide", time[meta + 1], power[meta + 1], heat[meta + 1], FissionRecipes.localiseFuel(fuel.toLowerCase()) + "-" + type + "-" + FissionRecipes.localiseFuel("oxide"), radiation[meta + 1] / 8.0);
        this.addRecipe("fuelRod" + fuel + type, "depletedFuelRod" + fuel + type, time[meta], power[meta], heat[meta], FissionRecipes.localiseFuel(fuel.toLowerCase()) + "-" + type, radiation[meta] / 8.0);
        this.addRecipe("fuelRod" + fuel + type + "Oxide", "depletedFuelRod" + fuel + type + "Oxide", time[meta + 1], power[meta + 1], heat[meta + 1], FissionRecipes.localiseFuel(fuel.toLowerCase()) + "-" + type + "-" + FissionRecipes.localiseFuel("oxide"), radiation[meta + 1] / 8.0);
    }

    private static String localiseFuel(String string) {
        return Lang.localise("gui.container.fission_controller." + string);
    }
}

