/*
 * Decompiled with CFR 0.152.
 */
package nc.recipe.processor;

import nc.recipe.ProcessorRecipeHandler;

public class ElectrolyserRecipes
extends ProcessorRecipeHandler {
    public ElectrolyserRecipes() {
        super("electrolyser", 0, 1, 0, 4);
    }

    @Override
    public void addRecipes() {
        this.addRecipe(this.fluidStack("water", 1000), this.fluidStack("hydrogen", 950), this.fluidStack("deuterium", 50), this.fluidStack("oxygen", 500), this.emptyFluidStack(), 1.5, 1.0);
        this.addRecipe(this.fluidStack("hydrofluoric_acid", 1000), this.fluidStack("hydrogen", 500), this.fluidStack("fluorine", 500), this.emptyFluidStack(), this.emptyFluidStack(), 1.0, 0.5);
        this.addRecipe(this.fluidStack("naoh", 666), this.fluidStack("sodium", 144), this.fluidStack("water", 1000), this.fluidStack("oxygen", 500), this.emptyFluidStack(), 1.5, 1.5);
        this.addRecipe(this.fluidStack("koh", 666), this.fluidStack("potassium", 144), this.fluidStack("water", 1000), this.fluidStack("oxygen", 500), this.emptyFluidStack(), 1.5, 1.5);
        this.addRecipe(this.fluidStack("heavywater", 1000), this.fluidStack("deuterium", 950), this.fluidStack("tritium", 50), this.fluidStack("oxygen", 500), this.emptyFluidStack(), 1.5, 1.0);
        this.addElementFluorideRecipes("thorium", "uranium", "plutonium");
        this.addIsotopeFluorideRecipes("thorium", 230);
        this.addIsotopeFluorideRecipes("uranium", 233, 235, 238);
        this.addIsotopeFluorideRecipes("neptunium", 236, 237);
        this.addIsotopeFluorideRecipes("plutonium", 238, 239, 241, 242);
        this.addIsotopeFluorideRecipes("americium", 241, 242, 243);
        this.addIsotopeFluorideRecipes("curium", 243, 245, 246, 247);
        this.addIsotopeFluorideRecipes("berkelium", 247, 248);
        this.addIsotopeFluorideRecipes("californium", 249, 250, 251, 252);
        this.addRecipe(this.fluidStack("fuel_tbu_fluoride", 144), this.fluidStack("fuel_tbu", 144), this.fluidStack("fluorine", 1000), this.emptyFluidStack(), this.emptyFluidStack(), 0.5, 1.0);
        this.addRecipe(this.fluidStack("depleted_fuel_tbu_fluoride", 144), this.fluidStack("depleted_fuel_tbu", 144), this.fluidStack("fluorine", 1000), this.emptyFluidStack(), this.emptyFluidStack(), 0.5, 1.0);
        this.addFissionFuelFluorideRecipes("eu", 233, 235);
        this.addFissionFuelFluorideRecipes("en", 236);
        this.addFissionFuelFluorideRecipes("ep", 239, 241);
        this.addFissionFuelFluorideRecipes("ea", 242);
        this.addFissionFuelFluorideRecipes("ecm", 243, 245, 247);
        this.addFissionFuelFluorideRecipes("eb", 248);
        this.addFissionFuelFluorideRecipes("ecf", 249, 251);
    }

    public void addElementFluorideRecipes(String ... elements) {
        for (String element : elements) {
            this.addRecipe(this.fluidStack(element + "_fluoride", 144), this.fluidStack(element, 144), this.fluidStack("fluorine", 1000), this.emptyFluidStack(), this.emptyFluidStack(), 0.5, 1.0);
        }
    }

    public void addIsotopeFluorideRecipes(String element, int ... types) {
        for (int type : types) {
            this.addRecipe(this.fluidStack(element + "_" + type + "_fluoride", 144), this.fluidStack(element + "_" + type, 144), this.fluidStack("fluorine", 1000), this.emptyFluidStack(), this.emptyFluidStack(), 0.5, 1.0);
        }
    }

    public void addFissionFuelFluorideRecipes(String suffix, int ... types) {
        for (int type : types) {
            for (String form : new String[]{"fuel_l", "fuel_h", "depleted_fuel_l", "depleted_fuel_h"}) {
                this.addRecipe(this.fluidStack(form + suffix + "_" + type + "_fluoride", 144), this.fluidStack(form + suffix + "_" + type, 144), this.fluidStack("fluorine", 1000), this.emptyFluidStack(), this.emptyFluidStack(), 0.5, 1.0);
            }
        }
    }
}

