/*
 * Decompiled with CFR 0.152.
 */
package nc.recipe.processor;

import com.google.common.collect.Lists;
import nc.recipe.ProcessorRecipeHandler;

public class SaltMixerRecipes
extends ProcessorRecipeHandler {
    public SaltMixerRecipes() {
        super("salt_mixer", 0, 2, 0, 1);
    }

    @Override
    public void addRecipes() {
        this.addRecipe(this.fluidStack("lif", 288), this.fluidStack("bef2", 144), this.fluidStack("flibe", 144), 1.0, 1.0);
        this.addRecipe(this.fluidStack("sodium", 72), this.fluidStack("potassium", 288), this.fluidStack("nak", 144), 1.0, 1.0);
        this.addRecipe(this.fluidStack("boron11", 144), this.fluidStack("boron10", 48), this.fluidStack("boron", 144), 1.0, 1.0);
        this.addRecipe(this.fluidStack("lithium7", 144), this.fluidStack("lithium6", 48), this.fluidStack("lithium", 144), 1.0, 1.0);
        this.addRecipe(this.fluidStack("steel", 72), this.fluidStackList(Lists.newArrayList((Object[])new String[]{"boron", "boron10", "boron11"}), 72), this.fluidStack("ferroboron", 144), 1.0, 1.0);
        this.addRecipe(this.fluidStack("ferroboron", 72), this.fluidStackList(Lists.newArrayList((Object[])new String[]{"lithium", "lithium6", "lithium7"}), 72), this.fluidStack("tough", 144), 1.0, 1.0);
        this.addRecipe(this.fluidStack("coal", 100), this.fluidStack("diamond", 333), this.fluidStack("hardCarbon", 144), 1.0, 1.0);
        this.addRecipe(this.fluidStack("chocolate_liquor", 144), this.fluidStack("cocoa_butter", 144), this.fluidStack("unsweetened_chocolate", 288), 1.0, 0.5);
        this.addRecipe(this.fluidStack("unsweetened_chocolate", 144), this.fluidStack("sugar", 72), this.fluidStack("dark_chocolate", 144), 1.0, 0.5);
        this.addRecipe(this.fluidStack("dark_chocolate", 144), this.fluidStack("milk", 250), this.fluidStack("milk_chocolate", 288), 0.5, 0.5);
        this.addRecipe(this.fluidStack("gelatin", 144), this.fluidStack("water", 500), this.fluidStack("hydrated_gelatin", 144), 1.0, 0.5);
        this.addRecipe(this.fluidStack("hydrated_gelatin", 144), this.fluidStack("sugar", 72), this.fluidStack("marshmallow", 144), 1.0, 0.5);
        this.addCoolantNAKRecipe("redstone", 1000);
        this.addCoolantNAKRecipe("quartz", 4662);
        this.addCoolantNAKRecipe("gold", 576);
        this.addCoolantNAKRecipe("glowstone", 1750);
        this.addCoolantNAKRecipe("lapis", 5994);
        this.addCoolantNAKRecipe("diamond", 2664);
        this.addCoolantNAKRecipe("liquidhelium", 500);
        this.addCoolantNAKRecipe("ender", 1000);
        this.addCoolantNAKRecipe("cryotheum", 1000);
        this.addCoolantNAKRecipe("iron", 576);
        this.addCoolantNAKRecipe("emerald", 1998);
        this.addCoolantNAKRecipe("copper", 576);
        this.addCoolantNAKRecipe("tin", 576);
        this.addCoolantNAKRecipe("magnesium", 576);
        this.addFuelIsotopeRecipes("eu", "uranium", 238, 233, 235);
        this.addFuelIsotopeRecipes("en", "neptunium", 237, 236);
        this.addFuelIsotopeRecipes("ep", "plutonium", 242, 239, 241);
        this.addFuelIsotopeRecipes("ea", "americium", 243, 242);
        this.addFuelIsotopeRecipes("ecm", "curium", 246, 243, 245, 247);
        this.addFuelIsotopeRecipes("eb", "berkelium", 247, 248);
        this.addFuelIsotopeRecipes("ecf", "californium", 252, 249, 251);
        this.addElementFLIBERecipes("thorium", "uranium", "plutonium");
        this.addRecipe(this.fluidStack("fuel_tbu", 144), this.fluidStack("thorium_230", 16), this.fluidStack("thorium", 144), 1.0, 1.0);
        this.addRecipe(this.fluidStack("fuel_tbu_fluoride", 144), this.fluidStack("thorium_230_fluoride", 16), this.fluidStack("thorium_fluoride", 144), 1.0, 1.0);
        this.addRecipe(this.fluidStack("fuel_tbu_fluoride_flibe", 144), this.fluidStack("thorium_230_fluoride_flibe", 16), this.fluidStack("thorium_fluoride_flibe", 144), 1.0, 1.0);
        this.addIsotopeFLIBERecipes("thorium", 230);
        this.addIsotopeFLIBERecipes("uranium", 233, 235, 238);
        this.addIsotopeFLIBERecipes("neptunium", 236, 237);
        this.addIsotopeFLIBERecipes("plutonium", 238, 239, 241, 242);
        this.addIsotopeFLIBERecipes("americium", 241, 242, 243);
        this.addIsotopeFLIBERecipes("curium", 243, 245, 246, 247);
        this.addIsotopeFLIBERecipes("berkelium", 247, 248);
        this.addIsotopeFLIBERecipes("californium", 249, 250, 251, 252);
        this.addRecipe(this.fluidStack("fuel_tbu_fluoride", 144), this.fluidStack("flibe", 144), this.fluidStack("fuel_tbu_fluoride_flibe", 288), 1.0, 1.0);
        this.addRecipe(this.fluidStack("depleted_fuel_tbu_fluoride", 144), this.fluidStack("flibe", 144), this.fluidStack("depleted_fuel_tbu_fluoride_flibe", 288), 1.0, 1.0);
        this.addFissionFuelFLIBERecipes("eu", 233, 235);
        this.addFissionFuelFLIBERecipes("en", 236);
        this.addFissionFuelFLIBERecipes("ep", 239, 241);
        this.addFissionFuelFLIBERecipes("ea", 242);
        this.addFissionFuelFLIBERecipes("ecm", 243, 245, 247);
        this.addFissionFuelFLIBERecipes("eb", 248);
        this.addFissionFuelFLIBERecipes("ecf", 249, 251);
    }

    public void addCoolantNAKRecipe(String name, int amount) {
        this.addRecipe(this.fluidStack(name, amount), this.fluidStack("nak", 576), this.fluidStack(name + "_nak", 576), 1.5, 1.5);
    }

    public void addFuelIsotopeRecipes(String suffix, String element, int fertile, int ... fissiles) {
        for (String type : new String[]{"", "_fluoride", "_fluoride_flibe"}) {
            for (int fissile : fissiles) {
                this.addRecipe(this.fluidStack(element + "_" + fertile + type, 128), this.fluidStack(element + "_" + fissile + type, 16), this.fluidStack("fuel_l" + suffix + "_" + fissile + type, 144), 1.0, 1.0);
                this.addRecipe(this.fluidStack("fuel_l" + suffix + "_" + fissile + type, 80), this.fluidStack(element + "_" + fissile + type, 48), this.fluidStack("fuel_h" + suffix + "_" + fissile + type, 128), 0.5, 1.0);
            }
        }
    }

    public void addElementFLIBERecipes(String ... elements) {
        for (String element : elements) {
            this.addRecipe(this.fluidStack(element + "_fluoride", 144), this.fluidStack("flibe", 144), this.fluidStack(element + "_fluoride_flibe", 288), 1.0, 1.0);
        }
    }

    public void addIsotopeMixRecipes(String element, int major, int minor) {
        this.addRecipe(this.fluidStack(element + "_" + major, 144), this.fluidStack(element + "_" + minor, 16), this.fluidStack(element, 144), 1.0, 1.0);
        this.addRecipe(this.fluidStack(element + "_" + major + "_fluoride", 144), this.fluidStack(element + "_" + minor + "_fluoride", 16), this.fluidStack(element + "_fluoride", 144), 1.0, 1.0);
        this.addRecipe(this.fluidStack(element + "_" + major + "_fluoride_flibe", 144), this.fluidStack(element + "_" + minor + "_fluoride_flibe", 16), this.fluidStack(element + "_fluoride_flibe", 144), 1.0, 1.0);
    }

    public void addIsotopeFLIBERecipes(String element, int ... types) {
        for (int type : types) {
            this.addRecipe(this.fluidStack(element + "_" + type + "_fluoride", 144), this.fluidStack("flibe", 144), this.fluidStack(element + "_" + type + "_fluoride_flibe", 288), 1.0, 1.0);
        }
    }

    public void addFissionFuelFLIBERecipes(String suffix, int ... types) {
        for (int type : types) {
            for (String form : new String[]{"fuel_l", "fuel_h", "depleted_fuel_l", "depleted_fuel_h"}) {
                this.addRecipe(this.fluidStack(form + suffix + "_" + type + "_fluoride", 144), this.fluidStack("flibe", 144), this.fluidStack(form + suffix + "_" + type + "_fluoride_flibe", 288), 1.0, 1.0);
            }
        }
    }
}

