/*
 * Decompiled with CFR 0.152.
 */
package nc.tile.generator;

import nc.config.NCConfig;
import nc.tile.generator.TilePassiveGenerator;

public class TileRTG
extends TilePassiveGenerator {
    public TileRTG(int power, double radiation) {
        super(power);
        this.getRadiationSource().setRadiationLevel(radiation);
    }

    @Override
    public int getGenerated() {
        return this.power;
    }

    @Override
    public boolean shouldSaveRadiation() {
        return false;
    }

    public static class Californium
    extends TileRTG {
        public Californium() {
            super(NCConfig.rtg_power[3], 0.019125);
        }
    }

    public static class Americium
    extends TileRTG {
        public Americium() {
            super(NCConfig.rtg_power[2], 5.875E-4);
        }
    }

    public static class Plutonium
    extends TileRTG {
        public Plutonium() {
            super(NCConfig.rtg_power[1], 0.002875);
        }
    }

    public static class Uranium
    extends TileRTG {
        public Uranium() {
            super(NCConfig.rtg_power[0], 5.625E-11);
        }
    }
}

