/*
 * Decompiled with CFR 0.152.
 */
package nc.tile.internal.fluid;

import java.util.List;
import javax.annotation.Nonnull;
import nc.tile.internal.fluid.TankSorption;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.FluidTankPropertiesWrapper;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class Tank
extends FluidTank
implements INBTSerializable<NBTTagCompound> {
    private int maxTransfer;
    private List<String> allowedFluids;

    public Tank(int capacity, @Nonnull TankSorption sorption, List<String> allowedFluids) {
        this(capacity, capacity, sorption, allowedFluids);
    }

    public Tank(int capacity, int maxTransfer, @Nonnull TankSorption sorption, List<String> allowedFluids) {
        super(capacity);
        this.maxTransfer = maxTransfer;
        this.allowedFluids = allowedFluids;
        this.canFill = sorption.canFill();
        this.canDrain = sorption.canDrain();
    }

    public boolean canFillFluidType(FluidStack fluid) {
        if (fluid != null && this.allowedFluids != null && !this.allowedFluids.contains(fluid.getFluid().getName())) {
            return false;
        }
        return this.canFill();
    }

    public boolean canFillFluidType(Fluid fluid) {
        if (fluid != null && this.allowedFluids != null && !this.allowedFluids.contains(fluid.getName())) {
            return false;
        }
        return this.canFill();
    }

    public void changeFluidStored(Fluid fluid, int amount) {
        int newAmount = this.getFluidAmount() + amount;
        if (fluid == null || newAmount <= 0) {
            this.fluid = null;
            return;
        }
        if (newAmount > this.capacity) {
            newAmount = this.capacity;
        }
        this.fluid = new FluidStack(fluid, newAmount);
    }

    public void changeFluidAmount(int amount) {
        int newAmount = this.getFluidAmount() + amount;
        if (this.fluid == null || newAmount <= 0) {
            this.fluid = null;
            return;
        }
        if (newAmount > this.capacity) {
            newAmount = this.capacity;
        }
        this.fluid = new FluidStack(this.fluid, newAmount);
    }

    public void setFluidStored(Fluid fluid, int amount) {
        if (amount <= 0) {
            this.fluid = null;
            return;
        }
        this.fluid = new FluidStack(fluid, amount);
        if (this.getFluidAmount() > this.capacity) {
            this.fluid = new FluidStack(this.fluid, this.capacity);
        } else if (this.getFluidAmount() < 0) {
            this.fluid = null;
        }
    }

    public void setFluidStored(FluidStack stack) {
        if (stack == null || stack.amount <= 0) {
            this.fluid = null;
            return;
        }
        if (stack.amount > this.capacity) {
            stack.amount = this.capacity;
        }
        this.fluid = stack;
    }

    public void setFluidAmount(int amount) {
        if (this.fluid == null) {
            return;
        }
        if (amount <= 0) {
            this.fluid = null;
            return;
        }
        if (amount > this.capacity) {
            amount = this.capacity;
        }
        this.fluid.amount = amount;
    }

    public void setTankCapacity(int newCapacity) {
        if (newCapacity == this.capacity || newCapacity <= 0) {
            return;
        }
        this.capacity = newCapacity;
        if (newCapacity < this.getFluidAmount()) {
            this.setFluidAmount(newCapacity);
        }
    }

    public void mergeTank(Tank other) {
        if (this.fluid == null) {
            this.fluid = other.fluid;
        } else if (!this.fluid.isFluidEqual(other.getFluid())) {
            this.setFluidStored(null);
            return;
        }
        this.setFluidAmount(this.getFluidAmount() + other.getFluidAmount());
        this.setTankCapacity(this.capacity + other.capacity);
    }

    public void setMaxTransfer(int newMaxTransfer) {
        if (newMaxTransfer < 0) {
            return;
        }
        if (newMaxTransfer != this.maxTransfer) {
            this.maxTransfer = newMaxTransfer;
        }
    }

    public boolean isEmpty() {
        return this.getFluidAmount() == 0;
    }

    public boolean isFull() {
        return this.getFluidAmount() >= this.capacity;
    }

    public boolean canDistribute() {
        return this.canFill || this.canDrain;
    }

    public IFluidTankProperties getFluidTankProperties() {
        return new FluidTankPropertiesWrapper((FluidTank)this);
    }

    public String getFluidName() {
        if (this.fluid == null || this.fluid.getFluid() == null) {
            return "nullFluid";
        }
        return FluidRegistry.getFluidName((FluidStack)this.getFluid());
    }

    public String getFluidLocalizedName() {
        if (this.fluid == null || this.fluid.getFluid() == null) {
            return "";
        }
        return this.fluid.getLocalizedName();
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound fluidTag = new NBTTagCompound();
        this.writeToNBT(fluidTag);
        NBTTagCompound tankTag = new NBTTagCompound();
        tankTag.func_74782_a("fluidStorage", (NBTBase)fluidTag);
        return tankTag;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("fluidStorage")) {
            this.readFromNBT(nbt.func_74775_l("fluidStorage"));
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        if (this.getFluidAmount() < 0) {
            this.fluid = null;
        }
        nbt.func_74768_a("FluidAmount", this.getFluidAmount());
        nbt.func_74778_a("FluidName", this.getFluidName());
        return nbt;
    }

    public Tank readFromNBT(NBTTagCompound nbt) {
        this.fluid = nbt.func_74779_i("FluidName") == "nullFluid" || nbt.func_74762_e("FluidAmount") == 0 ? null : new FluidStack(FluidRegistry.getFluid((String)nbt.func_74779_i("FluidName")), nbt.func_74762_e("FluidAmount"));
        if (this.getFluidAmount() > this.capacity) {
            this.fluid.amount = this.capacity;
        }
        return this;
    }
}

