/*
 * Decompiled with CFR 0.152.
 */
package me.time6628.clag.sponge.commands;

import java.util.Collections;
import java.util.Optional;
import me.time6628.clag.sponge.CatClearLag;
import me.time6628.clag.sponge.Messages;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.command.spec.CommandSpec;
import org.spongepowered.api.data.type.HandTypes;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;

public class WhiteListItemCommand
implements CommandExecutor {
    private final CatClearLag plugin = CatClearLag.instance;

    public static CommandSpec getCommand() {
        return CommandSpec.builder().description((Text)Text.of((String)"Add an itemtype to the clearlag whitelist")).permission("catclearlag.command.whitelistitem").executor((CommandExecutor)new WhiteListItemCommand()).arguments(GenericArguments.optional((CommandElement)GenericArguments.catalogedElement((Text)Text.of((String)"item"), ItemType.class))).build();
    }

    public CommandResult execute(CommandSource src, CommandContext args) {
        if (!(src instanceof Player)) {
            return CommandResult.empty();
        }
        Optional otype = args.getOne((Text)Text.of((String)"item"));
        if (otype.isPresent()) {
            src.sendMessage(Messages.addToWhileList.apply(Collections.singletonMap("item", this.addItemToWhitelist((ItemType)otype.get()))).build());
        } else if (((Player)src).getItemInHand(HandTypes.MAIN_HAND).isPresent()) {
            ItemStack si = (ItemStack)((Player)src).getItemInHand(HandTypes.MAIN_HAND).get();
            src.sendMessage(Messages.addToWhileList.apply(Collections.singletonMap("item", this.addItemToWhitelist(si.getType()))).build());
        } else {
            src.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "Could not add item to whitelist."}));
        }
        return CommandResult.success();
    }

    private String addItemToWhitelist(ItemType item) {
        this.plugin.addIDToWhiteList(item.getId());
        return item.getId();
    }
}

