/*
 * Decompiled with CFR 0.152.
 */
package tinker_io.handler;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.util.RecipeMatch;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.smeltery.CastingRecipe;
import slimeknights.tconstruct.library.smeltery.ICastingRecipe;
import slimeknights.tconstruct.library.utils.ListUtil;

public class SmartOutputRecipeHandler {
    public static List<CastingRecipe> fluidStackTableCastingRecipe = Lists.newLinkedList();

    public static ICastingRecipe findTableCastingRecipe(ItemStack cast, FluidStack fluidStack) {
        ICastingRecipe recipe = null;
        if (fluidStack != null && (recipe = TinkerRegistry.getTableCasting((ItemStack)cast, (Fluid)fluidStack.getFluid())) == null) {
            recipe = SmartOutputRecipeHandler.getFluidStackTableCasting(cast, fluidStack);
        }
        return recipe;
    }

    public static ICastingRecipe findBasinCastingRecipe(ItemStack cast, FluidStack fluidStack) {
        if (fluidStack == null) {
            return null;
        }
        return TinkerRegistry.getBasinCasting((ItemStack)cast, (Fluid)fluidStack.getFluid());
    }

    public static void registerSmartOutputCasting(ItemStack output, ItemStack cast, FluidStack fluid) {
        if (!cast.func_190926_b() && !output.func_190926_b()) {
            SmartOutputRecipeHandler.registerFluidStackCastingRecipe(new CastingRecipe(output, RecipeMatch.of((ItemStack)cast), fluid, false, true));
        }
    }

    public static void registerFluidStackCastingRecipe(CastingRecipe recipe) {
        fluidStackTableCastingRecipe.add(recipe);
    }

    public static CastingRecipe getFluidStackTableCasting(ItemStack cast, FluidStack fluidstack) {
        for (CastingRecipe recipe : fluidStackTableCastingRecipe) {
            if (!SmartOutputRecipeHandler.matches(cast, fluidstack, recipe)) continue;
            return recipe;
        }
        return null;
    }

    public static boolean matches(ItemStack cast, FluidStack fluidStack, CastingRecipe recipe) {
        if (cast == null && recipe.cast == null || recipe.cast != null && recipe.cast.matches(ListUtil.getListFrom((Object[])new ItemStack[]{cast})) != null) {
            return recipe.getFluid().isFluidEqual(fluidStack);
        }
        return false;
    }

    public static List<CastingRecipe> getFluidStackTableCastingRecipe() {
        return fluidStackTableCastingRecipe;
    }
}

