/*
 * Decompiled with CFR 0.152.
 */
package com.chocohead.gravisuite.items;

import com.chocohead.gravisuite.Gravisuite;
import ic2.api.item.ElectricItem;
import ic2.core.IC2;
import ic2.core.init.BlocksItems;
import ic2.core.init.Localization;
import ic2.core.item.tool.ItemElectricTool;
import ic2.core.ref.ItemName;
import ic2.core.util.StackUtil;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketBlockChange;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemVajra
extends ItemElectricTool {
    protected static final String NAME = "vajra";
    public static boolean accurateEnabled = true;

    public ItemVajra() {
        super(null, 3333, ItemElectricTool.HarvestLevel.Iridium, EnumSet.of(ItemElectricTool.ToolClass.Pickaxe, ItemElectricTool.ToolClass.Shovel, ItemElectricTool.ToolClass.Axe));
        ((ItemVajra)BlocksItems.registerItem((Item)this, (ResourceLocation)new ResourceLocation("gravisuite", NAME))).func_77655_b(NAME);
        this.maxCharge = 10000000;
        this.transferLimit = 60000;
        this.tier = 3;
        this.field_77864_a = 20000.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels(ItemName name) {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation("gravisuite:vajra", null));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        if (StackUtil.getOrCreateNbtData((ItemStack)stack).func_74767_n("accurate")) {
            tooltip.add(TextFormatting.GOLD + Localization.translate((String)"gravisuite.vajra.silkTouch", (Object[])new Object[]{TextFormatting.DARK_GREEN + Localization.translate((String)"gravisuite.message.on")}));
        } else {
            tooltip.add(TextFormatting.GOLD + Localization.translate((String)"gravisuite.vajra.silkTouch", (Object[])new Object[]{TextFormatting.DARK_RED + Localization.translate((String)"gravisuite.message.off")}));
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (!world.field_72995_K && IC2.keyboard.isModeSwitchKeyDown(player)) {
            ItemStack stack = StackUtil.get((EntityPlayer)player, (EnumHand)hand);
            NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)stack);
            if (nbt.func_74767_n("accurate")) {
                nbt.func_74757_a("accurate", false);
                Gravisuite.messagePlayer(player, "gravisuite.vajra.silkTouch", TextFormatting.DARK_RED, Localization.translate((String)"gravisuite.message.off"));
            } else if (accurateEnabled) {
                nbt.func_74757_a("accurate", true);
                Gravisuite.messagePlayer(player, "gravisuite.vajra.silkTouch", TextFormatting.DARK_GREEN, Localization.translate((String)"gravisuite.message.on"));
            } else {
                Gravisuite.messagePlayer(player, "gravisuite.vajra.silkTouchDisabled", TextFormatting.DARK_RED, new Object[0]);
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return super.func_77659_a(world, player, hand);
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, EntityPlayer player) {
        if (accurateEnabled && StackUtil.getOrCreateNbtData((ItemStack)stack).func_74767_n("accurate")) {
            World world = player.field_70170_p;
            if (!world.field_72995_K && ElectricItem.manager.canUse(stack, this.operationEnergyCost)) {
                stack.func_77966_a(Enchantments.field_185306_r, 10);
                IBlockState state = world.func_180495_p(pos);
                Block block = state.func_177230_c();
                boolean didHarvest = false;
                if (!block.isAir(state, (IBlockAccess)world, pos) && block.canHarvestBlock((IBlockAccess)world, pos, player)) {
                    int experience;
                    didHarvest = true;
                    if (player instanceof EntityPlayerMP) {
                        experience = ForgeHooks.onBlockBreakEvent((World)world, (GameType)((EntityPlayerMP)player).field_71134_c.func_73081_b(), (EntityPlayerMP)((EntityPlayerMP)player), (BlockPos)pos);
                        if (experience < 0) {
                            didHarvest = false;
                        }
                    } else {
                        experience = 0;
                    }
                    if (didHarvest) {
                        block.func_176208_a(world, pos, state, player);
                        if (player.func_184812_l_()) {
                            if (block.removedByPlayer(state, world, pos, player, false)) {
                                block.func_176206_d(world, pos, state);
                            }
                        } else {
                            if (block.removedByPlayer(state, world, pos, player, true)) {
                                block.func_176206_d(world, pos, state);
                                block.func_180657_a(world, player, pos, state, world.func_175625_s(pos), stack);
                                if (experience > 0) {
                                    block.func_180637_b(world, pos, experience);
                                }
                            }
                            stack.func_179548_a(world, state, pos, player);
                        }
                    }
                    if (didHarvest) {
                        ElectricItem.manager.use(stack, this.operationEnergyCost, (EntityLivingBase)player);
                        world.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)state));
                        ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketBlockChange(world, pos));
                    }
                }
                Map enchants = EnchantmentHelper.func_82781_a((ItemStack)stack);
                enchants.remove(Enchantments.field_185306_r);
                EnchantmentHelper.func_82782_a((Map)enchants, (ItemStack)stack);
                return didHarvest;
            }
        }
        return super.onBlockStartBreak(stack, pos, player);
    }

    protected ItemStack getStack(IBlockState state) {
        Item item = Item.func_150898_a((Block)state.func_177230_c());
        if (item == null) {
            return null;
        }
        return new ItemStack(item, 1, item.func_77614_k() ? state.func_177230_c().func_176201_c(state) : 0);
    }

    public boolean canHarvestBlock(IBlockState state, ItemStack stack) {
        return state.func_177230_c() != Blocks.field_150357_h;
    }

    public boolean func_77644_a(ItemStack itemstack, EntityLivingBase target, EntityLivingBase attacker) {
        if (attacker instanceof EntityPlayer) {
            if (ElectricItem.manager.use(itemstack, this.operationEnergyCost * 2.0, attacker)) {
                target.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)attacker)), 25.0f);
            } else {
                target.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)attacker)), 1.0f);
            }
        }
        return true;
    }

    public String func_77658_a() {
        return "gravisuite." + super.func_77658_a().substring(4);
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.EPIC;
    }
}

