/*
 * Decompiled with CFR 0.152.
 */
package openmods.sync;

import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import openmods.sync.ISyncableValueProvider;
import openmods.sync.SyncableObjectBase;
import openmods.utils.NbtUtils;

public class SyncableBlock
extends SyncableObjectBase
implements ISyncableValueProvider<Block> {
    private Block block;

    @Override
    public void readFromStream(PacketBuffer stream) {
        int blockId = stream.func_150792_a();
        this.block = Block.func_149729_e((int)blockId);
    }

    @Override
    public void writeToStream(PacketBuffer stream) {
        int blockId = Block.func_149682_b((Block)this.block);
        if (blockId < 0) {
            blockId = 0;
        }
        stream.func_150787_b(blockId);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, String name) {
        ResourceLocation location = (ResourceLocation)Block.field_149771_c.func_177774_c((Object)this.block);
        if (location != null) {
            NBTTagCompound entry = NbtUtils.store(location);
            nbt.func_74782_a(name, (NBTBase)entry);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, String name) {
        if (nbt.func_150297_b(name, 8)) {
            String blockName = nbt.func_74779_i(name);
            if (!Strings.isNullOrEmpty((String)blockName)) {
                ResourceLocation blockLocation = new ResourceLocation(blockName);
                this.block = (Block)Block.field_149771_c.func_82594_a((Object)blockLocation);
            }
        } else if (nbt.func_150297_b(name, 10)) {
            NBTTagCompound entry = nbt.func_74775_l(name);
            ResourceLocation blockLocation = NbtUtils.readResourceLocation(entry);
            this.block = (Block)Block.field_149771_c.func_82594_a((Object)blockLocation);
        } else {
            this.block = null;
        }
    }

    @Override
    public Block getValue() {
        return (Block)MoreObjects.firstNonNull((Object)this.block, (Object)Blocks.field_150350_a);
    }

    public void setValue(Block block) {
        if (this.block != block) {
            this.block = (Block)MoreObjects.firstNonNull((Object)block, (Object)Blocks.field_150350_a);
            this.markDirty();
        }
    }

    public boolean containsValidBlock() {
        return this.block != null && this.block != Blocks.field_150350_a;
    }
}

