/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.ae2wtlib.init;

import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLEventChannel;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import p455w0rd.ae2wtlib.api.WTNetworkHandler;
import p455w0rd.ae2wtlib.api.networking.WTPacket;
import p455w0rd.ae2wtlib.sync.network.IPacketHandler;
import p455w0rd.ae2wtlib.sync.network.WTClientPacketHandler;
import p455w0rd.ae2wtlib.sync.network.WTServerPacketHandler;
import p455w0rd.ae2wtlib.sync.packets.PacketEmptyTrash;
import p455w0rd.ae2wtlib.sync.packets.PacketSetAutoConsumeBoosters;
import p455w0rd.ae2wtlib.sync.packets.PacketSyncInfinityEnergy;

public class LibNetworking
extends WTNetworkHandler {
    private static final LibNetworking INSTANCE = new LibNetworking();
    private static final String CHANNEL_NAME = "ae2wtlib";
    private static final FMLEventChannel CHANNEL = NetworkRegistry.INSTANCE.newEventDrivenChannel("ae2wtlib");
    private static final IPacketHandler clientHandler = WTClientPacketHandler.instance();
    private static final IPacketHandler serverHandler = WTServerPacketHandler.instance();

    private LibNetworking() {
    }

    public static void preInit() {
        MinecraftForge.EVENT_BUS.register((Object)LibNetworking.instance());
        LibNetworking.getEventChannel().register((Object)LibNetworking.instance());
    }

    public static void postInit() {
    }

    public static LibNetworking instance() {
        return INSTANCE;
    }

    public static FMLEventChannel getEventChannel() {
        return CHANNEL;
    }

    public IPacketHandler getClientHandler() {
        return clientHandler;
    }

    public IPacketHandler getServerHandler() {
        return serverHandler;
    }

    public String getChannel() {
        return CHANNEL_NAME;
    }

    @Override
    public void sendToAll(WTPacket message) {
        LibNetworking.getEventChannel().sendToAll(message.getProxy());
    }

    @Override
    public void sendTo(WTPacket message, EntityPlayerMP player) {
        LibNetworking.getEventChannel().sendTo(message.getProxy(), player);
    }

    @Override
    public void sendToAllAround(WTPacket message, NetworkRegistry.TargetPoint point) {
        LibNetworking.getEventChannel().sendToAllAround(message.getProxy(), point);
    }

    @Override
    public void sendToDimension(WTPacket message, int dimensionId) {
        LibNetworking.getEventChannel().sendToDimension(message.getProxy(), dimensionId);
    }

    @Override
    public void sendToServer(WTPacket message) {
        LibNetworking.getEventChannel().sendToServer(message.getProxy());
    }

    @SubscribeEvent
    public void serverPacket(FMLNetworkEvent.ServerCustomPacketEvent ev) {
        NetHandlerPlayServer srv = (NetHandlerPlayServer)ev.getPacket().handler();
        WTServerPacketHandler.instance().onPacketData(null, ev.getHandler(), ev.getPacket(), (EntityPlayer)srv.field_147369_b);
    }

    @SubscribeEvent
    public void clientPacket(FMLNetworkEvent.ClientCustomPacketEvent ev) {
        WTClientPacketHandler.instance().onPacketData(null, ev.getHandler(), ev.getPacket(), null);
    }

    @Override
    public WTPacket createAutoConsumeBoosterPacket(boolean value) {
        return new PacketSetAutoConsumeBoosters(value);
    }

    @Override
    public WTPacket createEmptyTrashPacket() {
        return new PacketEmptyTrash();
    }

    @Override
    public WTPacket createInfinityEnergySyncPacket(int energy, UUID playerID, boolean isBauble, int slot) {
        return new PacketSyncInfinityEnergy(energy, playerID, isBauble, slot);
    }
}

