/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.block;

import com.flowpowered.math.vector.Vector3i;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import org.apache.logging.log4j.Level;
import org.spongepowered.api.CatalogType;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.tileentity.TileEntityArchetype;
import org.spongepowered.api.block.tileentity.TileEntityType;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.Property;
import org.spongepowered.api.data.Queries;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.manipulator.ImmutableDataManipulator;
import org.spongepowered.api.data.merge.MergeFunction;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.extent.Extent;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.block.SpongeBlockSnapshotBuilder;
import org.spongepowered.common.data.persistence.NbtTranslator;
import org.spongepowered.common.data.util.DataQueries;
import org.spongepowered.common.data.util.DataUtil;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.block.BlockPhase;
import org.spongepowered.common.interfaces.block.IMixinBlock;
import org.spongepowered.common.interfaces.world.IMixinWorldServer;
import org.spongepowered.common.registry.type.block.TileEntityTypeRegistryModule;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.BlockChange;
import org.spongepowered.common.world.SpongeBlockChangeFlag;

public class SpongeBlockSnapshot
implements BlockSnapshot {
    private final BlockState blockState;
    private final BlockState extendedState;
    private final UUID worldUniqueId;
    private final Vector3i pos;
    private final ImmutableList<ImmutableDataManipulator<?, ?>> extraData;
    private ImmutableMap<Key<?>, ImmutableValue<?>> keyValueMap;
    private ImmutableSet<ImmutableValue<?>> valueSet;
    private ImmutableList<ImmutableDataManipulator<?, ?>> blockData;
    private ImmutableMap<Key<?>, ImmutableValue<?>> blockKeyValueMap;
    private ImmutableSet<ImmutableValue<?>> blockValueSet;
    @Nullable
    final NBTTagCompound compound;
    @Nullable
    final UUID creatorUniqueId;
    @Nullable
    final UUID notifierUniqueId;
    private final BlockPos blockPos;
    private SpongeBlockChangeFlag changeFlag;
    public BlockChange blockChange;
    private Set<Key<?>> keys;
    private ImmutableSet<ImmutableValue<?>> values;

    public SpongeBlockSnapshot(SpongeBlockSnapshotBuilder builder) {
        this.blockState = (BlockState)Preconditions.checkNotNull((Object)builder.blockState, (Object)"The block state was null!");
        this.extendedState = builder.extendedState;
        this.worldUniqueId = (UUID)Preconditions.checkNotNull((Object)builder.worldUuid, (Object)"The world UUID was null");
        this.creatorUniqueId = builder.creatorUuid;
        this.notifierUniqueId = builder.notifierUuid;
        this.pos = (Vector3i)Preconditions.checkNotNull((Object)builder.coords);
        this.blockPos = VecHelper.toBlockPos(this.pos);
        ImmutableMap.Builder tileBuilder = ImmutableMap.builder();
        this.extraData = builder.manipulators == null ? ImmutableList.of() : ImmutableList.copyOf(builder.manipulators);
        for (ImmutableDataManipulator manipulator : this.extraData) {
            for (ImmutableValue<?> value : manipulator.getValues()) {
                tileBuilder.put(value.getKey(), value);
            }
        }
        this.keyValueMap = tileBuilder.build();
        this.valueSet = this.keyValueMap.isEmpty() ? ImmutableSet.of() : ImmutableSet.copyOf((Collection)this.keyValueMap.values());
        this.compound = builder.compound;
        this.changeFlag = builder.flag;
    }

    @Override
    public BlockState getState() {
        return this.blockState;
    }

    @Override
    public BlockState getExtendedState() {
        return this.extendedState;
    }

    @Override
    public BlockSnapshot withState(BlockState blockState) {
        return this.createBuilder().blockState(blockState).build();
    }

    @Override
    public BlockSnapshot withLocation(Location<World> location) {
        return this.createBuilder().position(location.getBlockPosition()).worldId(location.getExtent().getUniqueId()).build();
    }

    @Override
    public BlockSnapshot withContainer(DataContainer container) {
        return (BlockSnapshot)new SpongeBlockSnapshotBuilder().build(container).get();
    }

    @Override
    public UUID getWorldUniqueId() {
        return this.worldUniqueId;
    }

    @Override
    public Vector3i getPosition() {
        return this.pos;
    }

    @Override
    public boolean restore(boolean force, BlockChangeFlag flag) {
        Optional<World> optionalWorld = SpongeImpl.getGame().getServer().getWorld(this.worldUniqueId);
        if (!optionalWorld.isPresent()) {
            return false;
        }
        WorldServer world = (WorldServer)optionalWorld.get();
        IMixinWorldServer mixinWorldServer = (IMixinWorldServer)world;
        try (Object context = BlockPhase.State.RESTORING_BLOCKS.createPhaseContext();){
            ((PhaseContext)context).buildAndSwitch();
            BlockPos pos = VecHelper.toBlockPos(this.pos);
            if (!world.func_175701_a(pos)) {
                boolean bl = false;
                return bl;
            }
            IBlockState current = world.func_180495_p(pos);
            IBlockState replaced = (IBlockState)this.blockState;
            if (!(force || current.func_177230_c() == replaced.func_177230_c() && current.func_177230_c().func_176201_c(current) == replaced.func_177230_c().func_176201_c(replaced))) {
                boolean bl = false;
                return bl;
            }
            world.func_175713_t(pos);
            PhaseTracker.getInstance().setBlockState(mixinWorldServer, pos, replaced, flag);
            world.func_184164_w().func_180244_a(pos);
            if (this.compound != null) {
                TileEntity te = world.func_175625_s(pos);
                if (te != null) {
                    te.func_145839_a(this.compound);
                }
                if (te == null) {
                    try {
                        te = TileEntity.func_190200_a((net.minecraft.world.World)world, (NBTTagCompound)this.compound);
                        if (te != null) {
                            world.func_175726_f(pos).func_150813_a(te);
                        }
                    }
                    catch (Exception e) {
                        PrettyPrinter printer = new PrettyPrinter(60).add("Unable to restore").centre().hr().add("A mod is not correctly deserializing a TileEntity that is being restored. ").addWrapped(60, "Note that this is not the fault of Sponge. Sponge is understanding that a block is supposed to have a TileEntity, but the mod is breaking the contracton how to re-create the tile entity. Please open an issue with the offending mod.", new Object[0]).add("Here's the provided compound:");
                        printer.add();
                        try {
                            printer.addWrapped(80, "%s : %s", "This compound", this.compound);
                        }
                        catch (Throwable error) {
                            printer.addWrapped(80, "Unable to get the string of this compound. Printing out some of the entries to better assist", new Object[0]);
                        }
                        printer.add().add("Desired World: " + this.worldUniqueId).add("Position: " + this.pos).add("Desired BlockState: " + this.blockState);
                        printer.add();
                        printer.log(SpongeImpl.getLogger(), Level.ERROR);
                        boolean bl = true;
                        if (context != null) {
                            if (var7_7 != null) {
                                try {
                                    ((PhaseContext)context).close();
                                }
                                catch (Throwable throwable) {
                                    var7_7.addSuppressed(throwable);
                                }
                            } else {
                                ((PhaseContext)context).close();
                            }
                        }
                        return bl;
                    }
                }
                if (te != null) {
                    te.func_70296_d();
                }
            }
            boolean bl = true;
            return bl;
        }
    }

    @Override
    public Optional<UUID> getCreator() {
        return Optional.ofNullable(this.creatorUniqueId);
    }

    @Override
    public Optional<UUID> getNotifier() {
        return Optional.ofNullable(this.notifierUniqueId);
    }

    @Override
    public Optional<Location<World>> getLocation() {
        Optional<World> worldOptional = SpongeImpl.getGame().getServer().getWorld(this.worldUniqueId);
        if (worldOptional.isPresent()) {
            return Optional.of(new Location<Extent>((Extent)worldOptional.get(), this.getPosition()));
        }
        return Optional.empty();
    }

    @Override
    public List<ImmutableDataManipulator<?, ?>> getManipulators() {
        return ImmutableList.builder().addAll(this.getBlockManipulators()).addAll(this.extraData).build();
    }

    @Override
    public int getContentVersion() {
        return 1;
    }

    @Override
    public DataContainer toContainer() {
        List<DataView> dataList;
        DataContainer container = DataContainer.createNew().set(Queries.CONTENT_VERSION, (Object)this.getContentVersion()).set(Queries.WORLD_ID, (Object)this.worldUniqueId.toString()).createView(DataQueries.SNAPSHOT_WORLD_POSITION).set(Queries.POSITION_X, (Object)this.pos.getX()).set(Queries.POSITION_Y, (Object)this.pos.getY()).set(Queries.POSITION_Z, (Object)this.pos.getZ()).getContainer().set(DataQueries.BLOCK_STATE, (Object)this.blockState);
        if (this.blockState != this.extendedState) {
            container.set(DataQueries.BLOCK_EXTENDED_STATE, (Object)this.extendedState);
        }
        if (this.compound != null) {
            container.set(DataQueries.UNSAFE_NBT, (Object)NbtTranslator.getInstance().translateFrom(this.compound));
        }
        if (!(dataList = DataUtil.getSerializedImmutableManipulatorList(this.extraData)).isEmpty()) {
            container.set(DataQueries.SNAPSHOT_TILE_DATA, dataList);
        }
        return container;
    }

    @Override
    public <T extends ImmutableDataManipulator<?, ?>> Optional<T> get(Class<T> containerClass) {
        Optional<T> optional = this.blockState.get(containerClass);
        if (optional.isPresent()) {
            return optional;
        }
        for (ImmutableDataManipulator dataManipulator : this.extraData) {
            if (!containerClass.isInstance(dataManipulator)) continue;
            return Optional.of(dataManipulator);
        }
        return Optional.empty();
    }

    @Override
    public <T extends ImmutableDataManipulator<?, ?>> Optional<T> getOrCreate(Class<T> containerClass) {
        return this.get(containerClass);
    }

    @Override
    public boolean supports(Class<? extends ImmutableDataManipulator<?, ?>> containerClass) {
        return this.blockState.supports(containerClass);
    }

    @Override
    public <E> Optional<BlockSnapshot> transform(Key<? extends BaseValue<E>> key, Function<E, E> function) {
        return Optional.empty();
    }

    @Override
    public <E> Optional<BlockSnapshot> with(Key<? extends BaseValue<E>> key, E value) {
        Optional optional = this.blockState.with(key, value);
        if (optional.isPresent()) {
            return Optional.of(this.withState((BlockState)optional.get()));
        }
        return Optional.empty();
    }

    @Override
    public Optional<BlockSnapshot> with(BaseValue<?> value) {
        return this.with(value.getKey(), value.get());
    }

    @Override
    public Optional<BlockSnapshot> with(ImmutableDataManipulator<?, ?> valueContainer) {
        if (((IMixinBlock)((Object)this.blockState.getType())).supports(valueContainer.getClass())) {
            BlockState newState;
            boolean changeState = false;
            if (this.blockState.supports(valueContainer.getClass())) {
                newState = (BlockState)this.blockState.with(valueContainer).get();
                changeState = true;
            } else {
                newState = this.blockState;
            }
            if (changeState) {
                return Optional.of(this.createBuilder().blockState(newState).build());
            }
            SpongeBlockSnapshotBuilder builder = this.createBuilder();
            builder.add((ImmutableDataManipulator)valueContainer);
            return Optional.of(builder.build());
        }
        return Optional.of(((SpongeBlockSnapshotBuilder)this.createBuilder().add((ImmutableDataManipulator)valueContainer)).build());
    }

    @Override
    public Optional<BlockSnapshot> with(Iterable<ImmutableDataManipulator<?, ?>> valueContainers) {
        BlockSnapshot snapshot = this;
        for (ImmutableDataManipulator<?, ?> manipulator : valueContainers) {
            Optional optional = snapshot.with(manipulator);
            if (!optional.isPresent()) {
                return Optional.empty();
            }
            snapshot = (BlockSnapshot)optional.get();
        }
        return Optional.of(snapshot);
    }

    @Override
    public Optional<BlockSnapshot> without(Class<? extends ImmutableDataManipulator<?, ?>> containerClass) {
        return Optional.empty();
    }

    @Override
    public BlockSnapshot merge(BlockSnapshot that) {
        return this.merge(that, MergeFunction.FORCE_NOTHING);
    }

    @Override
    public BlockSnapshot merge(BlockSnapshot that, MergeFunction function) {
        BlockSnapshot merged = this;
        merged = merged.withState(function.merge(this.blockState, that.getState()));
        for (ImmutableDataManipulator manipulator : that.getContainers()) {
            Optional optional = merged.with(function.merge(this.get(manipulator.getClass()).orElse(null), manipulator));
            if (!optional.isPresent()) continue;
            merged = (BlockSnapshot)optional.get();
        }
        return merged;
    }

    @Override
    public List<ImmutableDataManipulator<?, ?>> getContainers() {
        return this.getManipulators();
    }

    @Override
    public <E> Optional<E> get(Key<? extends BaseValue<E>> key) {
        if (this.keyValueMap.containsKey(key)) {
            return Optional.of(((ImmutableValue)this.keyValueMap.get(key)).get());
        }
        if (this.getKeyValueMap().containsKey(key)) {
            return Optional.of(((ImmutableValue)this.blockKeyValueMap.get(key)).get());
        }
        return Optional.empty();
    }

    private ImmutableMap<Key<?>, ImmutableValue<?>> getKeyValueMap() {
        if (this.blockKeyValueMap == null) {
            ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
            for (ImmutableValue<?> value : this.blockState.getValues()) {
                mapBuilder.put(value.getKey(), value);
            }
            this.blockKeyValueMap = mapBuilder.build();
        }
        return this.blockKeyValueMap;
    }

    private ImmutableSet<ImmutableValue<?>> getValueSet() {
        if (this.blockValueSet == null) {
            this.blockValueSet = ImmutableSet.copyOf((Collection)this.getKeyValueMap().values());
        }
        return this.blockValueSet;
    }

    private ImmutableSet<ImmutableValue<?>> getTileValueSet() {
        if (this.valueSet == null) {
            this.valueSet = ImmutableSet.copyOf((Collection)this.getTileMap().values());
        }
        return this.valueSet;
    }

    private ImmutableMap<Key<?>, ImmutableValue<?>> getTileMap() {
        if (this.keyValueMap == null) {
            ImmutableMap.Builder tileBuilder = ImmutableMap.builder();
            for (ImmutableDataManipulator manipulator : this.extraData) {
                for (ImmutableValue<?> value : manipulator.getValues()) {
                    tileBuilder.put(value.getKey(), value);
                }
            }
            this.keyValueMap = tileBuilder.build();
        }
        return this.keyValueMap;
    }

    private ImmutableList<ImmutableDataManipulator<?, ?>> getBlockManipulators() {
        if (this.blockData == null) {
            this.blockData = ImmutableList.copyOf(this.blockState.getContainers());
        }
        return this.blockData;
    }

    @Override
    public <E, V extends BaseValue<E>> Optional<V> getValue(Key<V> key) {
        if (this.keyValueMap.containsKey(key)) {
            return Optional.of(((ImmutableValue)this.keyValueMap.get(key)).asMutable());
        }
        if (this.getKeyValueMap().containsKey(key)) {
            return Optional.of(((ImmutableValue)this.blockKeyValueMap.get(key)).asMutable());
        }
        return Optional.empty();
    }

    @Override
    public boolean supports(Key<?> key) {
        Preconditions.checkNotNull(key, (Object)"Key");
        return this.keyValueMap.containsKey(key) || this.getKeyValueMap().containsKey(key);
    }

    @Override
    public BlockSnapshot copy() {
        return this;
    }

    @Override
    public Set<Key<?>> getKeys() {
        if (this.keys == null) {
            this.keys = ImmutableSet.builder().addAll((Iterable)this.getKeyValueMap().keySet()).addAll((Iterable)this.getKeyValueMap().keySet()).build();
        }
        return this.keys;
    }

    @Override
    public Set<ImmutableValue<?>> getValues() {
        if (this.values == null) {
            this.values = ImmutableSet.builder().addAll(this.getTileValueSet()).addAll(this.getValueSet()).build();
        }
        return this.values;
    }

    public Optional<NBTTagCompound> getCompound() {
        return this.compound == null ? Optional.empty() : Optional.of(this.compound.func_74737_b());
    }

    public SpongeBlockSnapshotBuilder createBuilder() {
        SpongeBlockSnapshotBuilder builder = new SpongeBlockSnapshotBuilder();
        builder.blockState(this.blockState).extendedState(this.extendedState).position(this.pos).worldId(this.worldUniqueId);
        for (ImmutableDataManipulator manipulator : this.extraData) {
            builder.add(manipulator);
        }
        if (this.compound != null) {
            builder.unsafeNbt(this.compound);
        }
        return builder;
    }

    public SpongeBlockChangeFlag getChangeFlag() {
        return this.changeFlag;
    }

    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("worldUniqueId", (Object)this.worldUniqueId).add("position", (Object)this.pos).add("blockState", (Object)this.blockState).add("extendedState", (Object)this.extendedState).toString();
    }

    @Override
    public <T extends Property<?, ?>> Optional<T> getProperty(Class<T> propertyClass) {
        return this.blockState.getProperty(propertyClass);
    }

    @Override
    public Collection<Property<?, ?>> getApplicableProperties() {
        return this.blockState.getApplicableProperties();
    }

    @Override
    public Optional<TileEntityArchetype> createArchetype() {
        BlockType type = this.blockState.getType();
        if (!(type instanceof ITileEntityProvider)) {
            return Optional.empty();
        }
        if (this.compound == null) {
            return Optional.empty();
        }
        String tileId = this.compound.func_74779_i("id");
        Class tileClass = (Class)TileEntity.field_190562_f.func_82594_a((Object)new ResourceLocation(tileId));
        if (tileClass == null) {
            return Optional.empty();
        }
        CatalogType tileType = TileEntityTypeRegistryModule.getInstance().getForClass(tileClass);
        TileEntityArchetype archetype = TileEntityArchetype.builder().tile((TileEntityType)tileType).state(this.blockState).tileData(NbtTranslator.getInstance().translate(this.compound)).build();
        return Optional.of(archetype);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpongeBlockSnapshot that = (SpongeBlockSnapshot)o;
        return this.changeFlag == that.changeFlag && Objects.equal((Object)this.extendedState, (Object)that.extendedState) && Objects.equal((Object)this.worldUniqueId, (Object)that.worldUniqueId) && Objects.equal((Object)this.pos, (Object)that.pos) && Objects.equal(this.extraData, that.extraData) && Objects.equal((Object)this.compound, (Object)that.compound);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.extendedState, this.worldUniqueId, this.pos, this.extraData, this.changeFlag, this.compound});
    }
}

