/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.manipulator.immutable.common;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.Set;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.manipulator.ImmutableDataManipulator;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.common.data.manipulator.immutable.common.AbstractImmutableData;

public abstract class AbstractImmutableSingleData<T, I extends ImmutableDataManipulator<I, M>, M extends DataManipulator<M, I>>
extends AbstractImmutableData<I, M> {
    protected final Key<? extends BaseValue<T>> usedKey;
    protected final T value;

    protected AbstractImmutableSingleData(Class<I> immutableClass, T value, Key<? extends BaseValue<T>> usedKey) {
        super(immutableClass);
        this.value = Preconditions.checkNotNull(value);
        this.usedKey = (Key)Preconditions.checkNotNull(usedKey, (Object)"Hey, the key provided is null! Please make sure it is registered!");
        this.registerGetters();
    }

    protected abstract ImmutableValue<?> getValueGetter();

    public T getValue() {
        return this.value;
    }

    @Override
    public abstract M asMutable();

    @Override
    protected void registerGetters() {
        this.registerFieldGetter(this.usedKey, this::getValue);
        this.registerKeyValue(this.usedKey, this::getValueGetter);
    }

    @Override
    public <E> Optional<E> get(Key<? extends BaseValue<E>> key) {
        return ((Key)Preconditions.checkNotNull(key)).equals(this.usedKey) ? Optional.of(this.value) : Optional.empty();
    }

    @Override
    public boolean supports(Key<?> key) {
        return Preconditions.checkNotNull(key) == this.usedKey;
    }

    @Override
    public Set<Key<?>> getKeys() {
        return ImmutableSet.of(this.usedKey);
    }

    @Override
    public DataContainer toContainer() {
        return super.toContainer().set(this.usedKey, (Object)this.getValue());
    }
}

