/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.nbt;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.manipulator.DataManipulatorBuilder;
import org.spongepowered.api.data.persistence.DataBuilder;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.data.SpongeDataManager;
import org.spongepowered.common.data.persistence.NbtTranslator;
import org.spongepowered.common.data.persistence.SerializedDataTransaction;
import org.spongepowered.common.data.util.DataQueries;
import org.spongepowered.common.data.util.DataUtil;
import org.spongepowered.common.interfaces.data.IMixinCustomDataHolder;

public class CustomDataNbtUtil {
    public static DataTransactionResult apply(NBTTagCompound compound, DataManipulator<?, ?> manipulator) {
        NBTTagList list;
        NBTTagCompound spongeTag;
        NBTTagCompound forgeCompound;
        if (!compound.func_150297_b("ForgeData", 10)) {
            compound.func_74782_a("ForgeData", (NBTBase)new NBTTagCompound());
        }
        if (!(forgeCompound = compound.func_74775_l("ForgeData")).func_150297_b("SpongeData", 10)) {
            forgeCompound.func_74782_a("SpongeData", (NBTBase)new NBTTagCompound());
        }
        if ((spongeTag = forgeCompound.func_74775_l("SpongeData")).func_150297_b("CustomManipulators", 9)) {
            list = spongeTag.func_150295_c("CustomManipulators", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound dataCompound = list.func_150305_b(i);
                String clazzName = dataCompound.func_74779_i("DataClass");
                if (!manipulator.getClass().getName().equals(clazzName)) continue;
                NBTTagCompound current = dataCompound.func_74775_l("ManipulatorData");
                DataContainer currentView = NbtTranslator.getInstance().translate(current);
                DataManipulator<?, ?> existing = CustomDataNbtUtil.deserialize(clazzName, currentView);
                boolean isReplacing = existing != null;
                DataContainer container = manipulator.toContainer();
                NBTTagCompound newCompound = NbtTranslator.getInstance().translateData(container);
                dataCompound.func_74782_a("DataClass", (NBTBase)newCompound);
                if (isReplacing) {
                    return DataTransactionResult.successReplaceResult(manipulator.getValues(), existing.getValues());
                }
                return DataTransactionResult.successReplaceResult(manipulator.getValues(), ImmutableList.of());
            }
        } else {
            list = new NBTTagList();
            spongeTag.func_74782_a("CustomManipulators", (NBTBase)list);
        }
        NBTTagCompound newCompound = new NBTTagCompound();
        newCompound.func_74778_a("DataClass", manipulator.getClass().getName());
        DataContainer dataContainer = manipulator.toContainer();
        NBTTagCompound dataCompound = NbtTranslator.getInstance().translateData(dataContainer);
        newCompound.func_74782_a("ManipulatorData", (NBTBase)dataCompound);
        list.func_74742_a((NBTBase)newCompound);
        return DataTransactionResult.builder().result(DataTransactionResult.Type.SUCCESS).success(manipulator.getValues()).build();
    }

    public static DataTransactionResult apply(DataView view, DataManipulator<?, ?> manipulator) {
        List<Object> customData;
        DataView spongeTag;
        DataView forgeCompound;
        if (!view.contains(DataQueries.Compatibility.Forge.ROOT)) {
            view.set(DataQueries.Compatibility.Forge.ROOT, DataContainer.createNew());
        }
        if (!(forgeCompound = view.getView(DataQueries.Compatibility.Forge.ROOT).orElseThrow(DataUtil.dataNotFound())).contains(DataQueries.General.SPONGE_ROOT)) {
            forgeCompound.set(DataQueries.General.SPONGE_ROOT, DataContainer.createNew());
        }
        if ((spongeTag = forgeCompound.getView(DataQueries.General.SPONGE_ROOT).orElseThrow(DataUtil.dataNotFound())).contains(DataQueries.General.CUSTOM_MANIPULATOR_LIST)) {
            customData = spongeTag.getViewList(DataQueries.General.CUSTOM_MANIPULATOR_LIST).orElseThrow(DataUtil.dataNotFound());
            for (DataView dataView : customData) {
                String dataId = dataView.getString(DataQueries.DATA_ID).orElseThrow(DataUtil.dataNotFound());
                if (!DataUtil.getRegistrationFor(manipulator).getId().equals(dataId)) continue;
                DataView existingData = dataView.getView(DataQueries.INTERNAL_DATA).orElseThrow(DataUtil.dataNotFound());
                DataManipulator<?, ?> existing = CustomDataNbtUtil.deserialize(dataId, existingData);
                boolean isReplacing = existing != null;
                DataContainer container = manipulator.toContainer();
                dataView.set(DataQueries.INTERNAL_DATA, container);
                if (isReplacing) {
                    return DataTransactionResult.successReplaceResult(manipulator.getValues(), existing.getValues());
                }
                return DataTransactionResult.successReplaceResult(manipulator.getValues(), ImmutableList.of());
            }
        } else {
            customData = new ArrayList();
        }
        DataContainer container = DataContainer.createNew();
        container.set(DataQueries.DATA_ID, (Object)DataUtil.getRegistrationFor(manipulator).getId());
        container.set(DataQueries.INTERNAL_DATA, (Object)manipulator.toContainer());
        customData.add(container);
        spongeTag.set(DataQueries.General.CUSTOM_MANIPULATOR_LIST, customData);
        return DataTransactionResult.builder().result(DataTransactionResult.Type.SUCCESS).success(manipulator.getValues()).build();
    }

    public static DataTransactionResult remove(NBTTagCompound data, Class<? extends DataManipulator<?, ?>> containerClass) {
        if (!data.func_150297_b("ForgeData", 10)) {
            return DataTransactionResult.successNoData();
        }
        NBTTagCompound forgeTag = data.func_74775_l("ForgeData");
        if (!forgeTag.func_150297_b("SpongeData", 10)) {
            return DataTransactionResult.successNoData();
        }
        NBTTagCompound spongeData = forgeTag.func_74775_l("SpongeData");
        if (!spongeData.func_150297_b("CustomManipulators", 9)) {
            return DataTransactionResult.successNoData();
        }
        NBTTagList dataList = spongeData.func_150295_c("CustomManipulators", 10);
        if (dataList.func_74745_c() == 0) {
            return DataTransactionResult.successNoData();
        }
        for (int i = 0; i < dataList.func_74745_c(); ++i) {
            NBTTagCompound dataCompound = dataList.func_150305_b(i);
            String dataClass = dataCompound.func_74779_i("DataClass");
            if (!containerClass.getName().equals(dataClass)) continue;
            NBTTagCompound current = dataCompound.func_74775_l("ManipulatorData");
            DataContainer currentView = NbtTranslator.getInstance().translate(current);
            DataManipulator<?, ?> existing = CustomDataNbtUtil.deserialize(dataClass, currentView);
            boolean isRemoving = existing != null;
            dataList.func_74744_a(i);
            if (isRemoving) {
                return DataTransactionResult.successRemove(existing.getValues());
            }
            return DataTransactionResult.successNoData();
        }
        return DataTransactionResult.successNoData();
    }

    @Nullable
    private static DataManipulator<?, ?> deserialize(String dataClass, DataView view) {
        try {
            Optional manipulatorOptional;
            Class<?> clazz = Class.forName(dataClass);
            Optional<DataBuilder<?>> optional = SpongeDataManager.getInstance().getBuilder(clazz);
            if (optional.isPresent() && (manipulatorOptional = ((DataManipulatorBuilder)optional.get()).build(view)).isPresent()) {
                return (DataManipulator)manipulatorOptional.get();
            }
        }
        catch (Exception e) {
            new InvalidDataException("Could not translate " + dataClass + "! Don't worry though, we'll try to translate the rest of the data.", e).printStackTrace();
        }
        return null;
    }

    public static void readCustomData(NBTTagCompound compound, DataHolder dataHolder) {
        if (dataHolder instanceof IMixinCustomDataHolder) {
            ImmutableList<DataManipulator<?, ?>> manipulators;
            NBTTagCompound internal;
            ImmutableList.Builder builder;
            NBTTagList list;
            if (compound.func_150297_b("CustomManipulators", 9)) {
                list = compound.func_150295_c("CustomManipulators", 10);
                builder = ImmutableList.builder();
                if (list != null && list.func_74745_c() != 0) {
                    for (int i = 0; i < list.func_74745_c(); ++i) {
                        internal = list.func_150305_b(i);
                        builder.add((Object)NbtTranslator.getInstance().translateFrom(internal));
                    }
                }
                try {
                    SerializedDataTransaction transaction = DataUtil.deserializeManipulatorList((List<DataView>)builder.build());
                    manipulators = transaction.deserializedManipulators;
                    for (DataManipulator manipulator : manipulators) {
                        dataHolder.offer(manipulator);
                    }
                    if (!transaction.failedData.isEmpty()) {
                        ((IMixinCustomDataHolder)((Object)dataHolder)).addFailedData(transaction.failedData);
                    }
                }
                catch (InvalidDataException e) {
                    SpongeImpl.getLogger().error("Could not translate custom plugin data! ", (Throwable)e);
                }
            }
            if (compound.func_150297_b("FailedData", 9)) {
                list = compound.func_150295_c("FailedData", 10);
                builder = ImmutableList.builder();
                if (list != null && list.func_74745_c() != 0) {
                    for (int i = 0; i < list.func_74745_c(); ++i) {
                        internal = list.func_150305_b(i);
                        builder.add((Object)NbtTranslator.getInstance().translateFrom(internal));
                    }
                }
                compound.func_82580_o("FailedData");
                SerializedDataTransaction transaction = DataUtil.deserializeManipulatorList((List<DataView>)builder.build());
                manipulators = transaction.deserializedManipulators;
                ArrayList classesLoaded = new ArrayList();
                for (DataManipulator manipulator : manipulators) {
                    if (classesLoaded.contains(manipulator.getClass())) continue;
                    classesLoaded.add(manipulator.getClass());
                    if (((IMixinCustomDataHolder)((Object)dataHolder)).getCustom(manipulator.getClass()).isPresent()) continue;
                    dataHolder.offer(manipulator);
                }
                if (!transaction.failedData.isEmpty()) {
                    ((IMixinCustomDataHolder)((Object)dataHolder)).addFailedData(transaction.failedData);
                }
            }
        }
    }

    public static void writeCustomData(NBTTagCompound compound, DataHolder dataHolder) {
        if (dataHolder instanceof IMixinCustomDataHolder) {
            List<DataView> failedData;
            List<DataManipulator<?, ?>> manipulators = ((IMixinCustomDataHolder)((Object)dataHolder)).getCustomManipulators();
            if (!manipulators.isEmpty()) {
                List<DataView> manipulatorViews = DataUtil.getSerializedManipulatorList(manipulators);
                NBTTagList manipulatorTagList = new NBTTagList();
                for (DataView dataView : manipulatorViews) {
                    manipulatorTagList.func_74742_a((NBTBase)NbtTranslator.getInstance().translateData(dataView));
                }
                compound.func_74782_a("CustomManipulators", (NBTBase)manipulatorTagList);
            }
            if (!(failedData = ((IMixinCustomDataHolder)((Object)dataHolder)).getFailedData()).isEmpty()) {
                NBTTagList failedList = new NBTTagList();
                for (DataView failedDatum : failedData) {
                    failedList.func_74742_a((NBTBase)NbtTranslator.getInstance().translateData(failedDatum));
                }
                compound.func_74782_a("FailedData", (NBTBase)failedList);
            }
        }
    }
}

