/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.plugin;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.plugin.ListenerPhaseContext;
import org.spongepowered.common.event.tracking.phase.plugin.ListenerPhaseState;
import org.spongepowered.common.interfaces.IMixinChunk;

final class EventListenerPhaseState
extends ListenerPhaseState {
    private boolean hasPrintedEntities = false;

    EventListenerPhaseState() {
    }

    @Override
    public void unwind(ListenerPhaseContext phaseContext) {
        phaseContext.getCapturedBlockSupplier().acceptAndClearIfNotEmpty(blocks -> TrackingUtil.processBlockCaptures(blocks, this, phaseContext));
        phaseContext.getCapturedEntitySupplier().acceptAndClearIfNotEmpty(entities -> {
            if (!this.hasPrintedEntities) {
                SpongeImpl.getLogger().warn("Unexpected entities captured during a plugin listener. If this message pops up, please let sponge developers know");
                this.hasPrintedEntities = true;
            }
        });
    }

    @Override
    public void associateNeighborBlockNotifier(ListenerPhaseContext context, @Nullable BlockPos sourcePos, Block block, BlockPos notifyPos, WorldServer minecraftWorld, PlayerTracker.Type notifier) {
        context.getCapturedPlayer().ifPresent(player -> ((IMixinChunk)minecraftWorld.func_175726_f(notifyPos)).addTrackedBlockPosition(block, notifyPos, (User)player, PlayerTracker.Type.NOTIFIER));
    }

    @Override
    public void capturePlayerUsingStackToBreakBlock(@Nullable ItemStack stack, EntityPlayerMP playerMP, ListenerPhaseContext context) {
        context.getCapturedPlayerSupplier().addPlayer(playerMP);
    }
}

