/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.inventory.adapter.impl.comp;

import java.util.Optional;
import org.spongepowered.api.entity.ArmorEquipable;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.equipment.EquipmentInventory;
import org.spongepowered.api.item.inventory.equipment.EquipmentType;
import org.spongepowered.api.item.inventory.property.EquipmentSlotType;
import org.spongepowered.api.item.inventory.query.QueryOperationTypes;
import org.spongepowered.api.item.inventory.transaction.InventoryTransactionResult;
import org.spongepowered.common.item.inventory.adapter.impl.comp.OrderedInventoryAdapter;
import org.spongepowered.common.item.inventory.lens.Fabric;
import org.spongepowered.common.item.inventory.lens.comp.EquipmentInventoryLens;

public class EquipmentInventoryAdapter
extends OrderedInventoryAdapter
implements EquipmentInventory {
    private final ArmorEquipable carrier;
    private final EquipmentInventoryLens lens;

    public EquipmentInventoryAdapter(ArmorEquipable carrier, Fabric inventory, EquipmentInventoryLens root) {
        super(inventory, root);
        this.carrier = carrier;
        this.lens = root;
    }

    public EquipmentInventoryAdapter(ArmorEquipable carrier, Fabric inventory, EquipmentInventoryLens root, Inventory parent) {
        super(inventory, root, parent);
        this.carrier = carrier;
        this.lens = root;
    }

    @Override
    public Optional<ArmorEquipable> getCarrier() {
        return Optional.ofNullable(this.carrier);
    }

    @Override
    public Optional<ItemStack> poll(EquipmentSlotType equipmentType) {
        return this.query(QueryOperationTypes.INVENTORY_PROPERTY.of(equipmentType)).poll();
    }

    @Override
    public Optional<ItemStack> poll(EquipmentSlotType equipmentType, int limit) {
        return this.query(QueryOperationTypes.INVENTORY_PROPERTY.of(equipmentType)).poll(limit);
    }

    @Override
    public Optional<ItemStack> poll(EquipmentType equipmentType) {
        return this.poll(new EquipmentSlotType(equipmentType));
    }

    @Override
    public Optional<ItemStack> poll(EquipmentType equipmentType, int limit) {
        return this.poll(new EquipmentSlotType(equipmentType), limit);
    }

    @Override
    public Optional<ItemStack> peek(EquipmentSlotType equipmentType) {
        return this.query(QueryOperationTypes.INVENTORY_PROPERTY.of(equipmentType)).peek();
    }

    @Override
    public Optional<ItemStack> peek(EquipmentSlotType equipmentType, int limit) {
        return this.query(QueryOperationTypes.INVENTORY_PROPERTY.of(equipmentType)).peek(limit);
    }

    @Override
    public Optional<ItemStack> peek(EquipmentType equipmentType) {
        return this.peek(new EquipmentSlotType(equipmentType));
    }

    @Override
    public Optional<ItemStack> peek(EquipmentType equipmentType, int limit) {
        return this.peek(new EquipmentSlotType(equipmentType), limit);
    }

    @Override
    public InventoryTransactionResult set(EquipmentSlotType equipmentType, ItemStack stack) {
        return this.query(QueryOperationTypes.INVENTORY_PROPERTY.of(equipmentType)).set(stack);
    }

    @Override
    public InventoryTransactionResult set(EquipmentType equipmentType, ItemStack stack) {
        return this.set(new EquipmentSlotType(equipmentType), stack);
    }

    @Override
    public Optional<Slot> getSlot(EquipmentSlotType equipmentType) {
        Object slot = this.query(QueryOperationTypes.INVENTORY_PROPERTY.of(equipmentType));
        if (slot instanceof Slot) {
            return Optional.of((Slot)slot);
        }
        return Optional.empty();
    }

    @Override
    public Optional<Slot> getSlot(EquipmentType equipmentType) {
        return this.getSlot(new EquipmentSlotType(equipmentType));
    }
}

