/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.inventory.query.operation;

import com.google.common.collect.ImmutableSet;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.common.item.inventory.adapter.impl.slots.SlotAdapter;
import org.spongepowered.common.item.inventory.lens.Fabric;
import org.spongepowered.common.item.inventory.lens.Lens;
import org.spongepowered.common.item.inventory.query.SpongeQueryOperation;
import org.spongepowered.common.item.inventory.query.SpongeQueryOperationTypes;

public final class SlotLensQueryOperation
extends SpongeQueryOperation<ImmutableSet<Inventory>> {
    private final ImmutableSet<Inventory> inventories;

    public SlotLensQueryOperation(ImmutableSet<Inventory> inventories) {
        super(SpongeQueryOperationTypes.SLOT_LENS);
        this.inventories = inventories;
    }

    @Override
    public boolean matches(Lens lens, Lens parent, Fabric inventory) {
        for (Inventory inv : this.inventories) {
            for (Inventory slot : inv.slots()) {
                if (!((SlotAdapter)slot).getRootLens().equals(lens)) continue;
                return true;
            }
        }
        return false;
    }
}

