/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.item;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.data.Property;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.manipulator.mutable.DisplayNameData;
import org.spongepowered.api.data.manipulator.mutable.item.EnchantmentData;
import org.spongepowered.api.data.manipulator.mutable.item.LoreData;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.text.translation.Translation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.interfaces.item.IMixinItem;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;
import org.spongepowered.common.registry.SpongeGameDictionaryEntry;
import org.spongepowered.common.text.translation.SpongeTranslation;

@Mixin(value={Item.class})
public abstract class MixinItem
implements ItemType,
IMixinItem,
SpongeGameDictionaryEntry {
    public Optional<BlockType> blockType = Optional.empty();
    @Shadow
    private String field_77774_bZ;
    @Nullable
    private ItemStack propertyItemStack;

    @Shadow
    public abstract int func_77639_j();

    @Shadow
    public abstract String func_77658_a();

    @Override
    public String getId() {
        ResourceLocation resourceLocation = (ResourceLocation)Item.field_150901_e.func_177774_c((Object)((Item)this));
        Preconditions.checkState((resourceLocation != null ? 1 : 0) != 0, (Object)"Attempted to access the id before the Item is registered.");
        return resourceLocation.toString();
    }

    @Override
    public String getName() {
        return this.getId();
    }

    @Override
    public <T extends Property<?, ?>> Optional<T> getDefaultProperty(Class<T> propertyClass) {
        if (this.propertyItemStack == null) {
            this.propertyItemStack = ItemStackUtil.fromNative(new net.minecraft.item.ItemStack((Item)this));
        }
        return SpongeImpl.getPropertyRegistry().getStore(propertyClass).flatMap(store -> store.getFor(this.propertyItemStack));
    }

    @Override
    public Translation getTranslation() {
        return new SpongeTranslation(this.func_77658_a() + ".name");
    }

    @Override
    public int getMaxStackQuantity() {
        return this.func_77639_j();
    }

    @Override
    public Optional<BlockType> getBlock() {
        return this.blockType;
    }

    @Override
    public void getManipulatorsFor(net.minecraft.item.ItemStack itemStack, List<DataManipulator<?, ?>> list) {
        if (!itemStack.func_77942_o()) {
            return;
        }
        ItemStack spongeStack = (ItemStack)itemStack;
        if (itemStack.func_77948_v()) {
            list.add(this.getData(itemStack, EnchantmentData.class));
        }
        spongeStack.get(DisplayNameData.class).ifPresent(list::add);
        spongeStack.get(LoreData.class).ifPresent(list::add);
    }

    protected final <T extends DataManipulator<T, ?>> T getData(net.minecraft.item.ItemStack itemStack, Class<T> manipulatorClass) {
        return (T)((DataManipulator)((ItemStack)itemStack).get(manipulatorClass).get());
    }

    @Override
    public net.minecraft.item.ItemStack createDictionaryStack(int wildcardValue) {
        return new net.minecraft.item.ItemStack((Item)this, 1, wildcardValue);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("Name", (Object)this.field_77774_bZ).toString();
    }
}

