/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.server.management;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.authlib.Agent;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.ProfileLookupCallback;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.annotation.Nullable;
import net.minecraft.server.management.PlayerProfileCache;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.profile.GameProfileCache;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.interfaces.server.management.IMixinPlayerProfileCache;
import org.spongepowered.common.interfaces.server.management.IMixinPlayerProfileCacheEntry;
import org.spongepowered.common.profile.callback.MapProfileLookupCallback;
import org.spongepowered.common.profile.callback.SingleProfileLookupCallback;
import org.spongepowered.common.util.SpongeUsernameCache;

@Mixin(value={PlayerProfileCache.class})
public abstract class MixinPlayerProfileCache
implements IMixinPlayerProfileCache,
GameProfileCache {
    @Shadow
    @Final
    private Map<String, IMixinPlayerProfileCacheEntry> field_152661_c;
    @Shadow
    @Final
    private Map<UUID, IMixinPlayerProfileCacheEntry> field_152662_d;
    @Shadow
    @Final
    private Deque<GameProfile> field_152663_e;
    private Queue<GameProfile> profiles = new ConcurrentLinkedQueue<GameProfile>();
    private boolean canSave = false;

    @Nullable
    @Shadow
    public abstract GameProfile func_152652_a(UUID var1);

    @Shadow
    public abstract void func_152658_c();

    @Shadow
    private void func_152651_a(GameProfile profile, @Nullable Date expiry) {
    }

    @Inject(method={"addEntry(Lcom/mojang/authlib/GameProfile;Ljava/util/Date;)V"}, at={@At(value="RETURN")})
    public void onAddEntry(GameProfile profile, Date date, CallbackInfo ci) {
        SpongeUsernameCache.setUsername(profile.getId(), profile.getName());
    }

    @Redirect(method={"addEntry(Lcom/mojang/authlib/GameProfile;Ljava/util/Date;)V"}, at=@At(value="INVOKE", target="Ljava/util/Deque;remove(Ljava/lang/Object;)Z", remap=false))
    public boolean onAddEntryRemove(Deque<GameProfile> list, Object obj) {
        return this.profiles.remove(obj);
    }

    @Redirect(method={"addEntry(Lcom/mojang/authlib/GameProfile;Ljava/util/Date;)V"}, at=@At(value="INVOKE", target="Ljava/util/Deque;addFirst(Ljava/lang/Object;)V", remap=false))
    public void onAddEntryAdd(Deque<GameProfile> list, Object obj) {
        this.profiles.add((GameProfile)obj);
    }

    @Redirect(method={"getGameProfileForUsername"}, at=@At(value="INVOKE", target="Ljava/util/Deque;remove(Ljava/lang/Object;)Z", ordinal=0, remap=false))
    public boolean onGetGameProfileForUsernameRemove1(Deque<GameProfile> list, Object obj) {
        return this.profiles.remove(obj);
    }

    @Redirect(method={"getGameProfileForUsername"}, at=@At(value="INVOKE", target="Ljava/util/Deque;remove(Ljava/lang/Object;)Z", ordinal=1, remap=false))
    public boolean onGetGameProfileForUsernameRemove2(Deque<GameProfile> list, Object obj) {
        return this.profiles.remove(obj);
    }

    @Redirect(method={"getGameProfileForUsername"}, at=@At(value="INVOKE", target="Ljava/util/Deque;addFirst(Ljava/lang/Object;)V", remap=false))
    public void onGetGameProfileForUsernameAdd(Deque<GameProfile> list, Object obj) {
        this.profiles.add((GameProfile)obj);
    }

    @Redirect(method={"getByUUID"}, at=@At(value="INVOKE", target="Ljava/util/Deque;remove(Ljava/lang/Object;)Z", remap=false))
    public boolean onGetByUUIDRemove(Deque<GameProfile> list, Object obj) {
        return this.profiles.remove(obj);
    }

    @Redirect(method={"getByUUID"}, at=@At(value="INVOKE", target="Ljava/util/Deque;addFirst(Ljava/lang/Object;)V", remap=false))
    public void onGetByUUIDAdd(Deque<GameProfile> list, Object obj) {
        this.profiles.add((GameProfile)obj);
    }

    @Redirect(method={"getEntriesWithLimit"}, at=@At(value="INVOKE", target="Ljava/util/Deque;iterator()Ljava/util/Iterator;", remap=false))
    public Iterator<GameProfile> onGetEntriesWithLimit(Deque<GameProfile> list) {
        return this.profiles.iterator();
    }

    @Redirect(method={"load"}, at=@At(value="INVOKE", target="Ljava/util/Deque;clear()V", remap=false))
    public void onLoad(Deque<GameProfile> list) {
        this.profiles.clear();
    }

    @Redirect(method={"lookupProfile(Lcom/mojang/authlib/GameProfileRepository;Ljava/lang/String;)Lcom/mojang/authlib/GameProfile;"}, at=@At(value="INVOKE", target="Lcom/mojang/authlib/GameProfileRepository;findProfilesByNames([Ljava/lang/String;Lcom/mojang/authlib/Agent;Lcom/mojang/authlib/ProfileLookupCallback;)V", remap=false))
    private static void onGetGameProfile(GameProfileRepository repository, String[] names, Agent agent, ProfileLookupCallback callback) {
        GameProfileCache cache = null;
        try {
            cache = Sponge.getServer().getGameProfileManager().getCache();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (cache == null || cache instanceof PlayerProfileCache) {
            repository.findProfilesByNames(names, agent, callback);
        } else {
            callback.onProfileLookupSucceeded((GameProfile)cache.getOrLookupByName(names[0]).orElse(null));
        }
    }

    @Inject(method={"save"}, at={@At(value="HEAD")}, cancellable=true)
    public void onSave(CallbackInfo ci) {
        if (!this.canSave) {
            ci.cancel();
        }
    }

    @Override
    public boolean add(org.spongepowered.api.profile.GameProfile profile, boolean overwrite, @Nullable Instant expiry) {
        Preconditions.checkNotNull((Object)profile, (Object)"profile");
        if (this.field_152662_d.containsKey(profile.getUniqueId()) && !overwrite) {
            return false;
        }
        this.func_152651_a((GameProfile)profile, expiry == null ? null : new Date(expiry.toEpochMilli()));
        return true;
    }

    @Override
    public boolean remove(org.spongepowered.api.profile.GameProfile profile) {
        Preconditions.checkNotNull((Object)profile, (Object)"profile");
        UUID uniqueId = profile.getUniqueId();
        if (this.field_152662_d.containsKey(uniqueId)) {
            this.field_152662_d.remove(uniqueId);
            this.profiles.remove(profile);
            if (profile.getName().isPresent()) {
                this.field_152661_c.remove(profile.getName().get().toLowerCase(Locale.ROOT));
            }
            return true;
        }
        return false;
    }

    @Override
    public Collection<org.spongepowered.api.profile.GameProfile> remove(Iterable<org.spongepowered.api.profile.GameProfile> profiles) {
        Preconditions.checkNotNull(profiles, (Object)"profiles");
        ArrayList result = Lists.newArrayList();
        for (org.spongepowered.api.profile.GameProfile profile : profiles) {
            if (!this.remove(profile)) continue;
            result.add(profile);
        }
        return result;
    }

    @Override
    public void clear() {
        this.field_152662_d.clear();
        this.profiles.clear();
        this.field_152661_c.clear();
        this.func_152658_c();
    }

    @Override
    public Optional<org.spongepowered.api.profile.GameProfile> getById(UUID uniqueId) {
        return Optional.ofNullable((org.spongepowered.api.profile.GameProfile)this.func_152652_a((UUID)Preconditions.checkNotNull((Object)uniqueId, (Object)"unique id")));
    }

    @Override
    public Map<UUID, Optional<org.spongepowered.api.profile.GameProfile>> getByIds(Iterable<UUID> uniqueIds) {
        Preconditions.checkNotNull(uniqueIds, (Object)"unique ids");
        HashMap result = Maps.newHashMap();
        for (UUID uniqueId : uniqueIds) {
            result.put(uniqueId, Optional.ofNullable((org.spongepowered.api.profile.GameProfile)this.func_152652_a(uniqueId)));
        }
        return result.isEmpty() ? ImmutableMap.of() : ImmutableMap.copyOf((Map)result);
    }

    @Override
    public Optional<org.spongepowered.api.profile.GameProfile> lookupById(UUID uniqueId) {
        Preconditions.checkNotNull((Object)uniqueId, (Object)"unique id");
        GameProfile profile = SpongeImpl.getServer().func_147130_as().fillProfileProperties(new GameProfile(uniqueId, ""), true);
        if (profile != null && profile.getName() != null && !profile.getName().isEmpty()) {
            this.func_152651_a(profile, null);
            return Optional.of((org.spongepowered.api.profile.GameProfile)profile);
        }
        return Optional.empty();
    }

    @Override
    public Map<UUID, Optional<org.spongepowered.api.profile.GameProfile>> lookupByIds(Iterable<UUID> uniqueIds) {
        Preconditions.checkNotNull(uniqueIds, (Object)"unique ids");
        HashMap result = Maps.newHashMap();
        MinecraftSessionService service = SpongeImpl.getServer().func_147130_as();
        for (UUID uniqueId : uniqueIds) {
            GameProfile profile = service.fillProfileProperties(new GameProfile(uniqueId, ""), true);
            if (profile != null && profile.getName() != null && !profile.getName().isEmpty()) {
                this.func_152651_a(profile, null);
                result.put(uniqueId, Optional.of((org.spongepowered.api.profile.GameProfile)profile));
                continue;
            }
            this.func_152651_a(new GameProfile(uniqueId, "[sponge]"), null);
            result.put(uniqueId, Optional.empty());
        }
        return result.isEmpty() ? ImmutableMap.of() : ImmutableMap.copyOf((Map)result);
    }

    @Override
    public Optional<org.spongepowered.api.profile.GameProfile> getOrLookupById(UUID uniqueId) {
        Optional<org.spongepowered.api.profile.GameProfile> profile = this.getById(uniqueId);
        if (profile.isPresent()) {
            return profile;
        }
        return this.lookupById(uniqueId);
    }

    @Override
    public Map<UUID, Optional<org.spongepowered.api.profile.GameProfile>> getOrLookupByIds(Iterable<UUID> uniqueIds) {
        Preconditions.checkNotNull(uniqueIds, (Object)"unique ids");
        HashSet pending = Sets.newHashSet(uniqueIds);
        HashMap result = Maps.newHashMap();
        result.putAll(this.getByIds(pending));
        result.forEach((uniqueId, profile) -> {
            if (profile.isPresent()) {
                pending.remove(uniqueId);
            }
        });
        result.putAll(this.lookupByIds(pending));
        return ImmutableMap.copyOf((Map)result);
    }

    @Override
    public Optional<org.spongepowered.api.profile.GameProfile> getByName(String name) {
        return Optional.ofNullable((org.spongepowered.api.profile.GameProfile)this.getByNameNoLookup((String)Preconditions.checkNotNull((Object)name, (Object)"name")));
    }

    @Override
    public Map<String, Optional<org.spongepowered.api.profile.GameProfile>> getByNames(Iterable<String> names) {
        Preconditions.checkNotNull(names, (Object)"names");
        HashMap result = Maps.newHashMap();
        for (String name : names) {
            result.put(name, Optional.ofNullable((org.spongepowered.api.profile.GameProfile)this.getByNameNoLookup(name)));
        }
        return result.isEmpty() ? ImmutableMap.of() : ImmutableMap.copyOf((Map)result);
    }

    @Override
    public Optional<org.spongepowered.api.profile.GameProfile> lookupByName(String name) {
        SingleProfileLookupCallback callback = new SingleProfileLookupCallback();
        SpongeImpl.getServer().func_152359_aw().findProfilesByNames(new String[]{name}, Agent.MINECRAFT, (ProfileLookupCallback)callback);
        Optional<org.spongepowered.api.profile.GameProfile> profile = callback.getResult();
        if (profile.isPresent()) {
            this.func_152651_a((GameProfile)profile.get(), null);
        }
        return profile;
    }

    @Override
    public Map<String, Optional<org.spongepowered.api.profile.GameProfile>> lookupByNames(Iterable<String> names) {
        Preconditions.checkNotNull(names, (Object)"names");
        HashMap result = Maps.newHashMap();
        SpongeImpl.getServer().func_152359_aw().findProfilesByNames((String[])Iterables.toArray(names, String.class), Agent.MINECRAFT, (ProfileLookupCallback)new MapProfileLookupCallback(result));
        if (!result.isEmpty()) {
            for (Optional entry : result.values()) {
                if (!entry.isPresent()) continue;
                this.func_152651_a((GameProfile)entry.get(), null);
            }
            return ImmutableMap.copyOf((Map)result);
        }
        return ImmutableMap.of();
    }

    @Override
    public Optional<org.spongepowered.api.profile.GameProfile> getOrLookupByName(String name) {
        Optional<org.spongepowered.api.profile.GameProfile> profile = this.getByName(name);
        if (profile.isPresent()) {
            return profile;
        }
        return this.lookupByName(name);
    }

    @Override
    public Map<String, Optional<org.spongepowered.api.profile.GameProfile>> getOrLookupByNames(Iterable<String> names) {
        Preconditions.checkNotNull(names, (Object)"names");
        HashSet pending = Sets.newHashSet(names);
        HashMap result = Maps.newHashMap();
        result.putAll(this.getByNames(pending));
        result.forEach((name, profile) -> {
            if (profile.isPresent()) {
                pending.remove(name);
            }
        });
        pending.forEach(name -> result.put(name, this.lookupByName((String)name)));
        return ImmutableMap.copyOf((Map)result);
    }

    @Override
    public Optional<org.spongepowered.api.profile.GameProfile> fillProfile(org.spongepowered.api.profile.GameProfile profile, boolean signed) {
        Preconditions.checkNotNull((Object)profile, (Object)"profile");
        return Optional.ofNullable((org.spongepowered.api.profile.GameProfile)SpongeImpl.getServer().func_147130_as().fillProfileProperties((GameProfile)profile, signed));
    }

    @Override
    public Collection<org.spongepowered.api.profile.GameProfile> getProfiles() {
        return (Collection)this.field_152661_c.values().stream().map(entry -> (org.spongepowered.api.profile.GameProfile)entry.getGameProfile()).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    public Collection<org.spongepowered.api.profile.GameProfile> match(String name) {
        String search = ((String)Preconditions.checkNotNull((Object)name, (Object)"name")).toLowerCase(Locale.ROOT);
        return (Collection)this.getProfiles().stream().filter(profile -> profile.getName().isPresent()).filter(profile -> profile.getName().get().toLowerCase(Locale.ROOT).startsWith(search)).collect(ImmutableSet.toImmutableSet());
    }

    @Nullable
    public GameProfile getByNameNoLookup(String username) {
        GameProfile profile;
        IMixinPlayerProfileCacheEntry entry = this.field_152661_c.get(username.toLowerCase(Locale.ROOT));
        if (entry != null && System.currentTimeMillis() >= entry.getExpirationDate().getTime()) {
            profile = entry.getGameProfile();
            this.field_152662_d.remove(profile.getId());
            this.field_152661_c.remove(profile.getName().toLowerCase(Locale.ROOT));
            this.profiles.remove(profile);
            entry = null;
        }
        if (entry != null) {
            profile = entry.getGameProfile();
            this.profiles.remove(profile);
            this.profiles.add(profile);
        }
        return entry == null ? null : entry.getGameProfile();
    }

    @Override
    public boolean canSave() {
        return this.canSave;
    }

    @Override
    public void setCanSave(boolean flag) {
        this.canSave = flag;
    }
}

