/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world;

import com.flowpowered.math.GenericMath;
import com.flowpowered.math.vector.Vector2d;
import com.flowpowered.math.vector.Vector3d;
import com.flowpowered.math.vector.Vector3i;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraft.world.gen.IChunkGenerator;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.ScheduledBlockUpdate;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntitySnapshot;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.entity.CollideEntityEvent;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.util.AABB;
import org.spongepowered.api.util.Direction;
import org.spongepowered.api.util.PositionOutOfBoundsException;
import org.spongepowered.api.util.Tuple;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.api.world.BlockChangeFlags;
import org.spongepowered.api.world.Chunk;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.biome.BiomeType;
import org.spongepowered.api.world.extent.EntityUniverse;
import org.spongepowered.api.world.extent.Extent;
import org.spongepowered.api.world.extent.worker.MutableBiomeVolumeWorker;
import org.spongepowered.api.world.extent.worker.MutableBlockVolumeWorker;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.block.BlockUtil;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.PhaseData;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.generation.GenerationPhase;
import org.spongepowered.common.event.tracking.phase.generation.GenericGenerationContext;
import org.spongepowered.common.interfaces.IMixinCachable;
import org.spongepowered.common.interfaces.IMixinChunk;
import org.spongepowered.common.interfaces.block.tile.IMixinTileEntity;
import org.spongepowered.common.interfaces.entity.IMixinEntity;
import org.spongepowered.common.interfaces.server.management.IMixinPlayerChunkMapEntry;
import org.spongepowered.common.interfaces.world.IMixinWorld;
import org.spongepowered.common.interfaces.world.gen.IMixinChunkProviderServer;
import org.spongepowered.common.util.SpongeHooks;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.extent.ExtentViewDownsize;
import org.spongepowered.common.world.extent.worker.SpongeMutableBiomeVolumeWorker;
import org.spongepowered.common.world.extent.worker.SpongeMutableBlockVolumeWorker;
import org.spongepowered.common.world.gen.WorldGenConstants;
import org.spongepowered.common.world.storage.SpongeChunkLayout;

@NonnullByDefault
@Mixin(value={net.minecraft.world.chunk.Chunk.class})
public abstract class MixinChunk
implements Chunk,
IMixinChunk,
IMixinCachable {
    private World sponge_world;
    private UUID uuid;
    private long scheduledForUnload = -1L;
    private boolean persistedChunk = false;
    private boolean isSpawning = false;
    private net.minecraft.world.chunk.Chunk[] neighbors = new net.minecraft.world.chunk.Chunk[4];
    private long cacheKey;
    private static final Direction[] CARDINAL_DIRECTIONS = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST};
    private static final Vector3i BIOME_SIZE = new Vector3i(SpongeChunkLayout.CHUNK_SIZE.getX(), 1, SpongeChunkLayout.CHUNK_SIZE.getZ());
    private Vector3i chunkPos;
    private Vector3i blockMin;
    private Vector3i blockMax;
    private Vector3i biomeMin;
    private Vector3i biomeMax;
    @Shadow
    @Final
    private net.minecraft.world.World field_76637_e;
    @Shadow
    @Final
    public int field_76635_g;
    @Shadow
    @Final
    public int field_76647_h;
    @Shadow
    @Final
    private ExtendedBlockStorage[] field_76652_q;
    @Shadow
    @Final
    private int[] field_76638_b;
    @Shadow
    @Final
    private int[] field_76634_f;
    @Shadow
    @Final
    private ClassInheritanceMultiMap<net.minecraft.entity.Entity>[] field_76645_j;
    @Shadow
    @Final
    private Map<BlockPos, TileEntity> field_150816_i;
    @Shadow
    private long field_111204_q;
    @Shadow
    private boolean field_76636_d;
    @Shadow
    private boolean field_76646_k;
    @Shadow
    private boolean field_76643_l;
    @Shadow
    public boolean field_189550_d;

    @Shadow
    @Nullable
    public abstract TileEntity func_177424_a(BlockPos var1, Chunk.EnumCreateEntityType var2);

    @Shadow
    public abstract void func_76603_b();

    @Shadow
    public abstract int func_177413_a(EnumSkyBlock var1, BlockPos var2);

    @Shadow
    public abstract IBlockState func_177435_g(BlockPos var1);

    @Shadow
    public abstract IBlockState func_186032_a(int var1, int var2, int var3);

    @Shadow
    public abstract Biome func_177411_a(BlockPos var1, BiomeProvider var2);

    @Shadow
    public abstract byte[] func_76605_m();

    @Shadow
    public abstract void func_76616_a(byte[] var1);

    @Shadow
    public abstract void func_150809_p();

    @Shadow
    public abstract <T extends net.minecraft.entity.Entity> void func_177430_a(Class<? extends T> var1, AxisAlignedBB var2, List<T> var3, com.google.common.base.Predicate<? super T> var4);

    @Shadow
    private void func_76595_e(int x, int z) {
    }

    @Shadow
    private void func_76615_h(int x, int y, int z) {
    }

    @Shadow
    public abstract BlockPos func_177440_h(BlockPos var1);

    @Inject(method={"<init>(Lnet/minecraft/world/World;II)V"}, at={@At(value="RETURN")}, remap=false)
    public void onConstructed(net.minecraft.world.World world, int x, int z, CallbackInfo ci) {
        this.chunkPos = new Vector3i(x, 0, z);
        this.blockMin = SpongeChunkLayout.instance.forceToWorld(this.chunkPos);
        this.blockMax = this.blockMin.add(SpongeChunkLayout.CHUNK_SIZE).sub(1, 1, 1);
        this.biomeMin = new Vector3i(this.blockMin.getX(), 0, this.blockMin.getZ());
        this.biomeMax = new Vector3i(this.blockMax.getX(), 0, this.blockMax.getZ());
        this.sponge_world = (World)world;
        if (this.sponge_world.getUniqueId() != null) {
            this.uuid = new UUID(this.sponge_world.getUniqueId().getMostSignificantBits() ^ (long)(x * 2 + 1), this.sponge_world.getUniqueId().getLeastSignificantBits() ^ (long)(z * 2 + 1));
        }
        this.cacheKey = ChunkPos.func_77272_a((int)this.field_76635_g, (int)this.field_76647_h);
    }

    @Override
    public long getCacheKey() {
        return this.cacheKey;
    }

    @Override
    public void markChunkDirty() {
        this.field_76643_l = true;
    }

    @Override
    public boolean isChunkLoaded() {
        return this.field_76636_d;
    }

    @Override
    public boolean isQueuedForUnload() {
        return this.field_189550_d;
    }

    @Override
    public boolean isPersistedChunk() {
        return this.persistedChunk;
    }

    @Override
    public void setPersistedChunk(boolean flag) {
        this.persistedChunk = flag;
        for (TileEntity tileEntity : this.field_150816_i.values()) {
            ((IMixinTileEntity)tileEntity).setActiveChunk(this);
        }
        for (ClassInheritanceMultiMap<net.minecraft.entity.Entity> entityList : this.field_76645_j) {
            for (net.minecraft.entity.Entity entity : entityList) {
                ((IMixinEntity)entity).setActiveChunk(this);
            }
        }
    }

    @Override
    public boolean isSpawning() {
        return this.isSpawning;
    }

    @Override
    public void setIsSpawning(boolean spawning) {
        this.isSpawning = spawning;
    }

    @Inject(method={"addEntity"}, at={@At(value="RETURN")})
    private void onChunkAddEntity(net.minecraft.entity.Entity entityIn, CallbackInfo ci) {
        ((IMixinEntity)entityIn).setActiveChunk(this);
    }

    @Inject(method={"addTileEntity(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/tileentity/TileEntity;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/tileentity/TileEntity;validate()V")})
    private void onChunkAddTileEntity(BlockPos pos, TileEntity tileEntityIn, CallbackInfo ci) {
        ((IMixinTileEntity)tileEntityIn).setActiveChunk(this);
    }

    @Inject(method={"removeEntityAtIndex"}, at={@At(value="RETURN")})
    private void onChunkRemoveEntityAtIndex(net.minecraft.entity.Entity entityIn, int index, CallbackInfo ci) {
        ((IMixinEntity)entityIn).setActiveChunk(null);
    }

    @Redirect(method={"removeTileEntity"}, at=@At(value="INVOKE", target="Lnet/minecraft/tileentity/TileEntity;invalidate()V"))
    private void onChunkRemoveTileEntity(TileEntity tileEntityIn) {
        ((IMixinTileEntity)tileEntityIn).setActiveChunk(null);
        tileEntityIn.func_145843_s();
    }

    @Inject(method={"onLoad"}, at={@At(value="HEAD")}, cancellable=true)
    public void onLoadHead(CallbackInfo ci) {
        if (!this.field_76637_e.field_72995_K && PhaseTracker.getInstance().getCurrentState() == GenerationPhase.State.CHUNK_REGENERATING_LOAD_EXISTING) {
            ci.cancel();
        }
    }

    @Inject(method={"onLoad"}, at={@At(value="RETURN")})
    public void onLoadReturn(CallbackInfo ci) {
        for (Direction direction : CARDINAL_DIRECTIONS) {
            Vector3i neighborPosition = this.getPosition().add(direction.asBlockOffset());
            IMixinChunkProviderServer spongeChunkProvider = (IMixinChunkProviderServer)this.field_76637_e.func_72863_F();
            net.minecraft.world.chunk.Chunk neighbor = spongeChunkProvider.getLoadedChunkWithoutMarkingActive(neighborPosition.getX(), neighborPosition.getZ());
            if (neighbor == null) continue;
            int neighborIndex = MixinChunk.directionToIndex(direction);
            int oppositeNeighborIndex = MixinChunk.directionToIndex(direction.getOpposite());
            this.setNeighborChunk(neighborIndex, neighbor);
            ((IMixinChunk)neighbor).setNeighborChunk(oppositeNeighborIndex, (net.minecraft.world.chunk.Chunk)this);
        }
        if (ShouldFire.LOAD_CHUNK_EVENT) {
            SpongeImpl.postEvent(SpongeEventFactory.createLoadChunkEvent(Sponge.getCauseStackManager().getCurrentCause(), this));
        }
        if (!this.field_76637_e.field_72995_K) {
            SpongeHooks.logChunkLoad(this.field_76637_e, this.chunkPos);
        }
    }

    @Inject(method={"onUnload"}, at={@At(value="RETURN")})
    public void onUnload(CallbackInfo ci) {
        for (Direction direction : CARDINAL_DIRECTIONS) {
            Vector3i neighborPosition = this.getPosition().add(direction.asBlockOffset());
            IMixinChunkProviderServer spongeChunkProvider = (IMixinChunkProviderServer)this.field_76637_e.func_72863_F();
            net.minecraft.world.chunk.Chunk neighbor = spongeChunkProvider.getLoadedChunkWithoutMarkingActive(neighborPosition.getX(), neighborPosition.getZ());
            if (neighbor == null) continue;
            int neighborIndex = MixinChunk.directionToIndex(direction);
            int oppositeNeighborIndex = MixinChunk.directionToIndex(direction.getOpposite());
            this.setNeighborChunk(neighborIndex, null);
            ((IMixinChunk)neighbor).setNeighborChunk(oppositeNeighborIndex, null);
        }
        if (!this.field_76637_e.field_72995_K) {
            SpongeImpl.postEvent(SpongeEventFactory.createUnloadChunkEvent(Sponge.getCauseStackManager().getCurrentCause(), this));
            SpongeHooks.logChunkUnload(this.field_76637_e, this.chunkPos);
        }
    }

    @Override
    public UUID getUniqueId() {
        return this.uuid;
    }

    @Override
    public Vector3i getPosition() {
        return this.chunkPos;
    }

    @Override
    public boolean isLoaded() {
        return this.field_76636_d;
    }

    @Override
    public boolean loadChunk(boolean generate) {
        WorldServer worldserver = (WorldServer)this.field_76637_e;
        net.minecraft.world.chunk.Chunk chunk = null;
        if (worldserver.func_72863_F().func_73149_a(this.field_76635_g, this.field_76647_h) || generate) {
            chunk = worldserver.func_72863_F().func_186028_c(this.field_76635_g, this.field_76647_h);
        }
        return chunk != null;
    }

    @Override
    public int getInhabittedTime() {
        return (int)this.field_111204_q;
    }

    @Override
    public int getInhabitedTime() {
        return (int)this.field_111204_q;
    }

    @Override
    public double getRegionalDifficultyFactor() {
        boolean flag = this.field_76637_e.func_175659_aa() == EnumDifficulty.HARD;
        float moon = this.field_76637_e.func_130001_d();
        float f2 = MathHelper.func_76131_a((float)(((float)this.field_76637_e.func_72820_D() - 72000.0f) / 1440000.0f), (float)0.0f, (float)1.0f) * 0.25f;
        float f3 = 0.0f;
        f3 += MathHelper.func_76131_a((float)((float)this.field_111204_q / 3600000.0f), (float)0.0f, (float)1.0f) * (flag ? 1.0f : 0.75f);
        return f3 += MathHelper.func_76131_a((float)(moon * 0.25f), (float)0.0f, (float)f2);
    }

    @Override
    public double getRegionalDifficultyPercentage() {
        double region = this.getRegionalDifficultyFactor();
        if (region < 2.0) {
            return 0.0;
        }
        if (region > 4.0) {
            return 1.0;
        }
        return (region - 2.0) / 2.0;
    }

    @Override
    public World getWorld() {
        return this.sponge_world;
    }

    @Override
    public BiomeType getBiome(int x, int y, int z) {
        this.checkBiomeBounds(x, y, z);
        return (BiomeType)this.func_177411_a(new BlockPos(x, y, z), this.field_76637_e.func_72959_q());
    }

    @Override
    public void setBiome(int x, int y, int z, BiomeType biome) {
        PlayerChunkMapEntry entry;
        this.checkBiomeBounds(x, y, z);
        byte[] biomeArray = this.func_76605_m();
        int i = x & 0xF;
        int j = z & 0xF;
        biomeArray[j << 4 | i] = (byte)(Biome.func_185362_a((Biome)((Biome)biome)) & 0xFF);
        this.func_76616_a(biomeArray);
        if (this.field_76637_e instanceof WorldServer && (entry = ((WorldServer)this.field_76637_e).func_184164_w().func_187301_b(this.field_76635_g, this.field_76647_h)) != null) {
            ((IMixinPlayerChunkMapEntry)entry).markBiomesForUpdate();
        }
    }

    @Override
    public BlockState getBlock(int x, int y, int z) {
        this.checkBlockBounds(x, y, z);
        return (BlockState)this.func_177435_g(new BlockPos(x, y, z));
    }

    @Override
    public boolean setBlock(int x, int y, int z, BlockState block) {
        this.checkBlockBounds(x, y, z);
        return BlockUtil.setBlockState((net.minecraft.world.chunk.Chunk)this, x, y, z, block, false);
    }

    @Override
    public boolean setBlock(int x, int y, int z, BlockState block, BlockChangeFlag flag) {
        return BlockUtil.setBlockState((net.minecraft.world.chunk.Chunk)this, (this.field_76635_g << 4) + (x & 0xF), y, (this.field_76647_h << 4) + (z & 0xF), block, flag.updateNeighbors());
    }

    @Override
    public BlockType getBlockType(int x, int y, int z) {
        this.checkBlockBounds(x, y, z);
        return (BlockType)this.func_186032_a(x, y, z).func_177230_c();
    }

    @Override
    public BlockSnapshot createSnapshot(int x, int y, int z) {
        return this.sponge_world.createSnapshot((this.field_76635_g << 4) + (x & 0xF), y, (this.field_76647_h << 4) + (z & 0xF));
    }

    @Override
    public boolean restoreSnapshot(BlockSnapshot snapshot, boolean force, BlockChangeFlag flag) {
        return this.sponge_world.restoreSnapshot(snapshot, force, flag);
    }

    @Override
    public boolean restoreSnapshot(int x, int y, int z, BlockSnapshot snapshot, boolean force, BlockChangeFlag flag) {
        return this.sponge_world.restoreSnapshot((this.field_76635_g << 4) + (x & 0xF), y, (this.field_76647_h << 4) + (z & 0xF), snapshot, force, flag);
    }

    @Override
    public int getHighestYAt(int x, int z) {
        return this.sponge_world.getHighestYAt((this.field_76635_g << 4) + (x & 0xF), (this.field_76647_h << 4) + (z & 0xF));
    }

    @Override
    public int getPrecipitationLevelAt(int x, int z) {
        return this.func_177440_h(new BlockPos(x, 0, z)).func_177956_o();
    }

    @Override
    public Vector3i getBiomeMin() {
        return this.biomeMin;
    }

    @Override
    public Vector3i getBiomeMax() {
        return this.biomeMax;
    }

    @Override
    public Vector3i getBiomeSize() {
        return BIOME_SIZE;
    }

    @Override
    public Vector3i getBlockMin() {
        return this.blockMin;
    }

    @Override
    public Vector3i getBlockMax() {
        return this.blockMax;
    }

    @Override
    public Vector3i getBlockSize() {
        return SpongeChunkLayout.CHUNK_SIZE;
    }

    @Override
    public boolean containsBiome(int x, int y, int z) {
        return VecHelper.inBounds(x, y, z, this.biomeMin, this.biomeMax);
    }

    @Override
    public boolean containsBlock(int x, int y, int z) {
        return VecHelper.inBounds(x, y, z, this.blockMin, this.blockMax);
    }

    private void checkBiomeBounds(int x, int y, int z) {
        if (!this.containsBiome(x, y, z)) {
            throw new PositionOutOfBoundsException(new Vector3i(x, y, z), this.biomeMin, this.biomeMax);
        }
    }

    private void checkBlockBounds(int x, int y, int z) {
        if (!this.containsBlock(x, y, z)) {
            throw new PositionOutOfBoundsException(new Vector3i(x, y, z), this.blockMin, this.blockMax);
        }
    }

    @Override
    public Extent getExtentView(Vector3i newMin, Vector3i newMax) {
        this.checkBlockBounds(newMin.getX(), newMin.getY(), newMin.getZ());
        this.checkBlockBounds(newMax.getX(), newMax.getY(), newMax.getZ());
        return new ExtentViewDownsize(this, newMin, newMax);
    }

    @Override
    public MutableBiomeVolumeWorker<Chunk> getBiomeWorker() {
        return new SpongeMutableBiomeVolumeWorker<Chunk>(this);
    }

    @Override
    public MutableBlockVolumeWorker<Chunk> getBlockWorker() {
        return new SpongeMutableBlockVolumeWorker<Chunk>(this);
    }

    @Inject(method={"getEntitiesWithinAABBForEntity"}, at={@At(value="RETURN")})
    public void onGetEntitiesWithinAABBForEntity(net.minecraft.entity.Entity entityIn, AxisAlignedBB aabb, List<net.minecraft.entity.Entity> listToFill, com.google.common.base.Predicate<net.minecraft.entity.Entity> p_177414_4_, CallbackInfo ci) {
        if (this.field_76637_e.field_72995_K || PhaseTracker.getInstance().getCurrentPhaseData().state.ignoresEntityCollisions()) {
            return;
        }
        if (listToFill.size() == 0) {
            return;
        }
        if (!ShouldFire.COLLIDE_ENTITY_EVENT) {
            return;
        }
        CollideEntityEvent event = SpongeCommonEventFactory.callCollideEntityEvent(this.field_76637_e, entityIn, listToFill);
        PhaseData peek = PhaseTracker.getInstance().getCurrentPhaseData();
        if (event == null || event.isCancelled()) {
            if (event == null && !peek.state.isTicking()) {
                return;
            }
            listToFill.clear();
        }
    }

    @Inject(method={"getEntitiesOfTypeWithinAABB"}, at={@At(value="RETURN")})
    public void onGetEntitiesOfTypeWithinAAAB(Class<? extends net.minecraft.entity.Entity> entityClass, AxisAlignedBB aabb, List listToFill, com.google.common.base.Predicate<net.minecraft.entity.Entity> p_177430_4_, CallbackInfo ci) {
        if (this.field_76637_e.field_72995_K || PhaseTracker.getInstance().getCurrentPhaseData().state.ignoresEntityCollisions()) {
            return;
        }
        if (listToFill.size() == 0) {
            return;
        }
        CollideEntityEvent event = SpongeCommonEventFactory.callCollideEntityEvent(this.field_76637_e, null, listToFill);
        PhaseData peek = PhaseTracker.getInstance().getCurrentPhaseData();
        if (event == null || event.isCancelled()) {
            if (event == null && !peek.state.isTicking()) {
                return;
            }
            listToFill.clear();
        }
    }

    @Nullable
    @Overwrite
    public IBlockState func_177436_a(BlockPos pos, IBlockState state) {
        IBlockState iblockstate1 = this.func_177435_g(pos);
        return this.setBlockState(pos, state, iblockstate1, null, BlockChangeFlags.ALL);
    }

    @Override
    @Nullable
    public IBlockState setBlockState(BlockPos pos, IBlockState newState, IBlockState currentState, @Nullable BlockSnapshot originalBlockSnapshot) {
        return this.setBlockState(pos, newState, currentState, originalBlockSnapshot, BlockChangeFlags.ALL);
    }

    @Override
    @Nullable
    public IBlockState setBlockState(BlockPos pos, IBlockState newState, IBlockState currentState, @Nullable BlockSnapshot newBlockSnapshot, BlockChangeFlag flag) {
        TileEntity tileEntity;
        boolean requiresNewLightCalculations;
        int zPos;
        int combinedPos;
        int xPos = pos.func_177958_n() & 0xF;
        int yPos = pos.func_177956_o();
        if (yPos >= this.field_76638_b[combinedPos = (zPos = pos.func_177952_p() & 0xF) << 4 | xPos] - 1) {
            this.field_76638_b[combinedPos] = -999;
        }
        int currentHeight = this.field_76634_f[combinedPos];
        Block newBlock = newState.func_177230_c();
        Block currentBlock = currentState.func_177230_c();
        ExtendedBlockStorage extendedblockstorage = this.field_76652_q[yPos >> 4];
        int newBlockLightOpacity = SpongeImplHooks.getBlockLightOpacity(newState, (IBlockAccess)this.field_76637_e, pos);
        if (extendedblockstorage == net.minecraft.world.chunk.Chunk.field_186036_a) {
            if (newBlock == Blocks.field_150350_a) {
                return null;
            }
            ExtendedBlockStorage extendedBlockStorage = new ExtendedBlockStorage(yPos >> 4 << 4, this.field_76637_e.field_73011_w.func_191066_m());
            this.field_76652_q[yPos >> 4] = extendedBlockStorage;
            extendedblockstorage = extendedBlockStorage;
            requiresNewLightCalculations = yPos >= currentHeight;
        } else {
            requiresNewLightCalculations = false;
        }
        int modifiedY = yPos & 0xF;
        extendedblockstorage.func_177484_a(xPos, modifiedY, zPos, newState);
        if (!this.field_76637_e.field_72995_K) {
            TileEntity te;
            if (currentBlock != newBlock) {
                currentBlock.func_180663_b(this.field_76637_e, pos, currentState);
            }
            if ((te = this.func_177424_a(pos, Chunk.EnumCreateEntityType.CHECK)) != null && SpongeImplHooks.shouldRefresh(te, this.field_76637_e, pos, currentState, newState)) {
                this.field_76637_e.func_175713_t(pos);
            }
        } else if (SpongeImplHooks.hasBlockTileEntity(currentBlock, currentState) && (tileEntity = this.func_177424_a(pos, Chunk.EnumCreateEntityType.CHECK)) != null && SpongeImplHooks.shouldRefresh(tileEntity, this.field_76637_e, pos, currentState, newState)) {
            this.field_76637_e.func_175713_t(pos);
        }
        IBlockState blockAfterSet = extendedblockstorage.func_177485_a(xPos, modifiedY, zPos);
        if (blockAfterSet.func_177230_c() != newBlock) {
            return null;
        }
        if (requiresNewLightCalculations) {
            this.func_76603_b();
        } else {
            int postNewBlockLightOpacity = SpongeImplHooks.getBlockLightOpacity(newState, (IBlockAccess)this.field_76637_e, pos);
            if (newBlockLightOpacity > 0) {
                if (yPos >= currentHeight) {
                    this.func_76615_h(xPos, yPos + 1, zPos);
                }
            } else if (yPos == currentHeight - 1) {
                this.func_76615_h(xPos, yPos, zPos);
            }
            if (newBlockLightOpacity != postNewBlockLightOpacity && (newBlockLightOpacity < postNewBlockLightOpacity || this.func_177413_a(EnumSkyBlock.SKY, pos) > 0 || this.func_177413_a(EnumSkyBlock.BLOCK, pos) > 0)) {
                this.func_76595_e(xPos, zPos);
            }
        }
        if (!((IMixinWorld)this.field_76637_e).isFake() && currentBlock != newBlock) {
            PhaseData peek = PhaseTracker.getInstance().getCurrentPhaseData();
            boolean isBulkCapturing = peek.state.doesBulkBlockCapture(peek.context);
            if ((!isBulkCapturing || SpongeImplHooks.hasBlockTileEntity(newBlock, newState)) && flag.performBlockPhysics()) {
                newBlock.func_176213_c(this.field_76637_e, pos, newState);
            }
        }
        if (SpongeImplHooks.hasBlockTileEntity(newBlock, newState)) {
            TileEntity tileentity = this.func_177424_a(pos, Chunk.EnumCreateEntityType.CHECK);
            if (tileentity == null) {
                if (!((IMixinWorld)this.field_76637_e).isFake()) {
                    tileentity = SpongeImplHooks.createTileEntity(newBlock, this.field_76637_e, newState);
                    User owner = PhaseTracker.getInstance().getCurrentContext().getOwner().orElse(null);
                    if (owner != null) {
                        this.addTrackedBlockPosition(newBlock, pos, owner, PlayerTracker.Type.OWNER);
                    }
                }
                this.field_76637_e.func_175690_a(pos, tileentity);
            }
            if (tileentity != null) {
                tileentity.func_145836_u();
            }
        }
        this.field_76643_l = true;
        return currentState;
    }

    @Override
    public void addTrackedBlockPosition(Block block, BlockPos pos, User user, PlayerTracker.Type trackerType) {
    }

    @Override
    public Map<Integer, PlayerTracker> getTrackedIntPlayerPositions() {
        return Collections.emptyMap();
    }

    @Override
    public Map<Short, PlayerTracker> getTrackedShortPlayerPositions() {
        return Collections.emptyMap();
    }

    @Override
    public Optional<User> getBlockOwner(BlockPos pos) {
        return Optional.empty();
    }

    @Override
    public Optional<UUID> getBlockOwnerUUID(BlockPos pos) {
        return Optional.empty();
    }

    @Override
    public Optional<User> getBlockNotifier(BlockPos pos) {
        return Optional.empty();
    }

    @Override
    public Optional<UUID> getBlockNotifierUUID(BlockPos pos) {
        return Optional.empty();
    }

    @Override
    public void setBlockNotifier(BlockPos pos, @Nullable UUID uuid) {
    }

    @Override
    public void setBlockCreator(BlockPos pos, @Nullable UUID uuid) {
    }

    @Override
    public void setTrackedIntPlayerPositions(Map<Integer, PlayerTracker> trackedPositions) {
    }

    @Override
    public void setTrackedShortPlayerPositions(Map<Short, PlayerTracker> trackedPositions) {
    }

    @Override
    public Entity createEntity(EntityType type, Vector3d position) throws IllegalArgumentException, IllegalStateException {
        return this.sponge_world.createEntity(type, this.chunkPos.mul(16).toDouble().add(position.min(15.0f, this.blockMax.getY(), 15.0f)));
    }

    @Override
    public Optional<Entity> createEntity(DataContainer entityContainer) {
        return this.sponge_world.createEntity(entityContainer);
    }

    @Override
    public Optional<Entity> createEntity(DataContainer entityContainer, Vector3d position) {
        return this.sponge_world.createEntity(entityContainer, this.chunkPos.mul(16).toDouble().add(position.min(15.0f, this.blockMax.getY(), 15.0f)));
    }

    @Override
    public boolean spawnEntity(Entity entity) {
        return this.sponge_world.spawnEntity(entity);
    }

    @Override
    public Collection<Entity> getEntities() {
        HashSet entities = Sets.newHashSet();
        for (ClassInheritanceMultiMap<net.minecraft.entity.Entity> entityList : this.field_76645_j) {
            entities.addAll(entityList);
        }
        return entities;
    }

    @Override
    public Collection<Entity> getEntities(Predicate<Entity> filter) {
        HashSet entities = Sets.newHashSet();
        for (ClassInheritanceMultiMap<net.minecraft.entity.Entity> entityClassMap : this.field_76645_j) {
            for (Object entity : entityClassMap) {
                if (!filter.test((Entity)entity)) continue;
                entities.add((Entity)entity);
            }
        }
        return entities;
    }

    @Override
    public Collection<org.spongepowered.api.block.tileentity.TileEntity> getTileEntities() {
        return Sets.newHashSet(this.field_150816_i.values());
    }

    @Override
    public Collection<org.spongepowered.api.block.tileentity.TileEntity> getTileEntities(Predicate<org.spongepowered.api.block.tileentity.TileEntity> filter) {
        HashSet tiles = Sets.newHashSet();
        for (Map.Entry<BlockPos, TileEntity> entry : this.field_150816_i.entrySet()) {
            if (!filter.test((org.spongepowered.api.block.tileentity.TileEntity)entry.getValue())) continue;
            tiles.add((org.spongepowered.api.block.tileentity.TileEntity)entry.getValue());
        }
        return tiles;
    }

    @Override
    public Optional<org.spongepowered.api.block.tileentity.TileEntity> getTileEntity(int x, int y, int z) {
        return Optional.ofNullable((org.spongepowered.api.block.tileentity.TileEntity)this.func_177424_a(new BlockPos((this.field_76635_g << 4) + (x & 0xF), y, (this.field_76647_h << 4) + (z & 0xF)), Chunk.EnumCreateEntityType.CHECK));
    }

    @Override
    public Optional<Entity> restoreSnapshot(EntitySnapshot snapshot, Vector3d position) {
        return this.sponge_world.restoreSnapshot(snapshot, position);
    }

    @Override
    public Collection<ScheduledBlockUpdate> getScheduledUpdates(int x, int y, int z) {
        return this.sponge_world.getScheduledUpdates((this.field_76635_g << 4) + (x & 0xF), y, (this.field_76647_h << 4) + (z & 0xF));
    }

    @Override
    public ScheduledBlockUpdate addScheduledUpdate(int x, int y, int z, int priority, int ticks) {
        return this.sponge_world.addScheduledUpdate((this.field_76635_g << 4) + (x & 0xF), y, (this.field_76647_h << 4) + (z & 0xF), priority, ticks);
    }

    @Override
    public void removeScheduledUpdate(int x, int y, int z, ScheduledBlockUpdate update) {
        this.sponge_world.removeScheduledUpdate((this.field_76635_g << 4) + (x & 0xF), y, (this.field_76647_h << 4) + (z & 0xF), update);
    }

    @Override
    public boolean hitBlock(int x, int y, int z, Direction side, GameProfile profile) {
        return this.sponge_world.hitBlock((this.field_76635_g << 4) + (x & 0xF), y, (this.field_76647_h << 4) + (z & 0xF), side, profile);
    }

    @Override
    public boolean interactBlock(int x, int y, int z, Direction side, GameProfile profile) {
        return this.sponge_world.interactBlock((this.field_76635_g << 4) + (x & 0xF), y, (this.field_76647_h << 4) + (z & 0xF), side, profile);
    }

    @Override
    public boolean placeBlock(int x, int y, int z, BlockState block, Direction side, GameProfile profile) {
        return this.sponge_world.placeBlock((this.field_76635_g << 4) + (x & 0xF), y, (this.field_76647_h << 4) + (z & 0xF), block, side, profile);
    }

    @Override
    public boolean interactBlockWith(int x, int y, int z, ItemStack itemStack, Direction side, GameProfile profile) {
        return this.sponge_world.interactBlockWith((this.field_76635_g << 4) + (x & 0xF), y, (this.field_76647_h << 4) + (z & 0xF), itemStack, side, profile);
    }

    @Override
    public boolean digBlock(int x, int y, int z, GameProfile profile) {
        return this.sponge_world.digBlock((this.field_76635_g << 4) + (x & 0xF), y, (this.field_76647_h << 4) + (z & 0xF), profile);
    }

    @Override
    public boolean digBlockWith(int x, int y, int z, ItemStack itemStack, GameProfile profile) {
        return this.sponge_world.digBlockWith((this.field_76635_g << 4) + (x & 0xF), y, (this.field_76647_h << 4) + (z & 0xF), itemStack, profile);
    }

    @Override
    public int getBlockDigTimeWith(int x, int y, int z, ItemStack itemStack, GameProfile profile) {
        return this.sponge_world.getBlockDigTimeWith((this.field_76635_g << 4) + (x & 0xF), y, (this.field_76647_h << 4) + (z & 0xF), itemStack, profile);
    }

    @Redirect(method={"populate(Lnet/minecraft/world/chunk/IChunkProvider;Lnet/minecraft/world/gen/IChunkGenerator;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/chunk/IChunkProvider;getLoadedChunk(II)Lnet/minecraft/world/chunk/Chunk;"))
    public net.minecraft.world.chunk.Chunk onPopulateLoadChunk(IChunkProvider chunkProvider, int x, int z) {
        return ((IMixinChunkProviderServer)chunkProvider).getLoadedChunkWithoutMarkingActive(x, z);
    }

    @Inject(method={"populate(Lnet/minecraft/world/gen/IChunkGenerator;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/gen/IChunkGenerator;populate(II)V")})
    private void onPopulate(IChunkGenerator generator, CallbackInfo callbackInfo) {
        if (!this.field_76637_e.field_72995_K && !PhaseTracker.getInstance().getCurrentState().isRegeneration()) {
            ((GenericGenerationContext)GenerationPhase.State.TERRAIN_GENERATION.createPhaseContext().world(this.field_76637_e)).buildAndSwitch();
        }
    }

    @Inject(method={"populate(Lnet/minecraft/world/gen/IChunkGenerator;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/chunk/Chunk;markDirty()V")}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/world/gen/IChunkGenerator;populate(II)V"))})
    private void onPopulateFinish(IChunkGenerator generator, CallbackInfo info) {
        if (!this.field_76637_e.field_72995_K && !PhaseTracker.getInstance().getCurrentState().isRegeneration()) {
            PhaseTracker.getInstance().getCurrentContext().close();
        }
    }

    @Override
    public Optional<AABB> getBlockSelectionBox(int x, int y, int z) {
        this.checkBlockBounds(x, y, z);
        return this.sponge_world.getBlockSelectionBox((this.field_76635_g << 4) + (x & 0xF), y, (this.field_76647_h << 4) + (z & 0xF));
    }

    @Override
    public Set<Entity> getIntersectingEntities(AABB box, Predicate<Entity> filter) {
        Preconditions.checkNotNull((Object)box, (Object)"box");
        Preconditions.checkNotNull(filter, (Object)"filter");
        ArrayList entities = new ArrayList();
        this.func_177430_a(net.minecraft.entity.Entity.class, VecHelper.toMinecraftAABB(box), entities, entity -> filter.test((Entity)entity));
        return entities.stream().map(entity -> (Entity)entity).collect(Collectors.toSet());
    }

    @Override
    public Set<AABB> getIntersectingBlockCollisionBoxes(AABB box) {
        Vector3i max = this.blockMax.add(Vector3i.ONE);
        return this.sponge_world.getIntersectingBlockCollisionBoxes(box).stream().filter(aabb -> VecHelper.inBounds(aabb.getCenter(), this.blockMin, max)).collect(Collectors.toSet());
    }

    @Override
    public Set<AABB> getIntersectingCollisionBoxes(Entity owner, AABB box) {
        Vector3i max = this.blockMax.add(Vector3i.ONE);
        return this.sponge_world.getIntersectingCollisionBoxes(owner, box).stream().filter(aabb -> VecHelper.inBounds(aabb.getCenter(), this.blockMin, max)).collect(Collectors.toSet());
    }

    @Override
    public Set<EntityUniverse.EntityHit> getIntersectingEntities(Vector3d start, Vector3d end, Predicate<EntityUniverse.EntityHit> filter) {
        Preconditions.checkNotNull((Object)start, (Object)"start");
        Preconditions.checkNotNull((Object)end, (Object)"end");
        Preconditions.checkNotNull(filter, (Object)"filter");
        Vector3d diff = end.sub(start);
        return this.getIntersectingEntities(start, end, diff.normalize(), diff.length(), filter);
    }

    @Override
    public Set<EntityUniverse.EntityHit> getIntersectingEntities(Vector3d start, Vector3d direction, double distance, Predicate<EntityUniverse.EntityHit> filter) {
        Preconditions.checkNotNull((Object)start, (Object)"start");
        Preconditions.checkNotNull((Object)direction, (Object)"direction");
        Preconditions.checkNotNull(filter, (Object)"filter");
        direction = direction.normalize();
        return this.getIntersectingEntities(start, start.add(direction.mul(distance)), direction, distance, filter);
    }

    private Set<EntityUniverse.EntityHit> getIntersectingEntities(Vector3d start, Vector3d end, Vector3d direction, double distance, Predicate<EntityUniverse.EntityHit> filter) {
        Vector2d entryAndExitY = this.getEntryAndExitY(start, end, direction, distance);
        if (entryAndExitY == null) {
            return Collections.emptySet();
        }
        HashSet<EntityUniverse.EntityHit> intersections = new HashSet<EntityUniverse.EntityHit>();
        this.getIntersectingEntities(start, direction, distance, filter, entryAndExitY.getX(), entryAndExitY.getY(), intersections);
        return intersections;
    }

    @Nullable
    private Vector2d getEntryAndExitY(Vector3d start, Vector3d end, Vector3d direction, double distance) {
        double tMax;
        double tzMax;
        double tzMin;
        double txMax;
        double txMin;
        Vector3i min = this.getBlockMin().sub(2, 2, 2);
        Vector3i max = this.getBlockMax().add(3, 3, 3);
        if (Math.copySign(1.0, direction.getX()) > 0.0) {
            txMin = ((double)min.getX() - start.getX()) / direction.getX();
            txMax = ((double)max.getX() - start.getX()) / direction.getX();
        } else {
            txMin = ((double)max.getX() - start.getX()) / direction.getX();
            txMax = ((double)min.getX() - start.getX()) / direction.getX();
        }
        if (Math.copySign(1.0, direction.getZ()) > 0.0) {
            tzMin = ((double)min.getZ() - start.getZ()) / direction.getZ();
            tzMax = ((double)max.getZ() - start.getZ()) / direction.getZ();
        } else {
            tzMin = ((double)max.getZ() - start.getZ()) / direction.getZ();
            tzMax = ((double)min.getZ() - start.getZ()) / direction.getZ();
        }
        if (txMin > tzMax || txMax < tzMin) {
            return null;
        }
        double tMin = tzMin > txMin ? tzMin : txMin;
        double d = tMax = tzMax < txMax ? tzMax : txMax;
        if (tMax < 0.0) {
            return null;
        }
        double yEntry = tMin < 0.0 ? start.getY() : direction.getY() * tMin + start.getY();
        double yExit = tMax > distance ? end.getY() : direction.getY() * tMax + start.getY();
        return new Vector2d(yEntry, yExit);
    }

    @Override
    public void getIntersectingEntities(Vector3d start, Vector3d direction, double distance, Predicate<EntityUniverse.EntityHit> filter, double entryY, double exitY, Set<EntityUniverse.EntityHit> intersections) {
        double yMin = Math.min(entryY, exitY);
        double yMax = Math.max(entryY, exitY);
        int lowestSubChunk = GenericMath.clamp(GenericMath.floor((yMin - 2.0) / 16.0), 0, this.field_76645_j.length - 1);
        int highestSubChunk = GenericMath.clamp(GenericMath.floor((yMax + 2.0) / 16.0), 0, this.field_76645_j.length - 1);
        for (int i = lowestSubChunk; i <= highestSubChunk; ++i) {
            this.getIntersectingEntities((Collection<net.minecraft.entity.Entity>)this.field_76645_j[i], start, direction, distance, filter, intersections);
        }
    }

    private void getIntersectingEntities(Collection<net.minecraft.entity.Entity> entities, Vector3d start, Vector3d direction, double distance, Predicate<EntityUniverse.EntityHit> filter, Set<EntityUniverse.EntityHit> intersections) {
        for (net.minecraft.entity.Entity entity : entities) {
            EntityUniverse.EntityHit hit;
            Tuple<Vector3d, Vector3d> intersection;
            double distanceSquared;
            Optional<Tuple<Vector3d, Vector3d>> optionalIntersection;
            Entity spongeEntity = (Entity)entity;
            Optional<AABB> box = spongeEntity.getBoundingBox();
            if (!box.isPresent() || !(optionalIntersection = box.get().intersects(start, direction)).isPresent() || (distanceSquared = (intersection = optionalIntersection.get()).getFirst().sub(start).lengthSquared()) > distance * distance || !filter.test(hit = new EntityUniverse.EntityHit(spongeEntity, intersection.getFirst(), intersection.getSecond(), Math.sqrt(distanceSquared)))) continue;
            intersections.add(hit);
            net.minecraft.entity.Entity[] parts = entity.func_70021_al();
            if (parts == null || parts.length <= 0) continue;
            this.getIntersectingEntities(Arrays.asList(parts), start, direction, distance, filter, intersections);
        }
    }

    @Override
    public void setNeighborChunk(int index, @Nullable net.minecraft.world.chunk.Chunk chunk) {
        this.neighbors[index] = chunk;
    }

    @Override
    @Nullable
    public net.minecraft.world.chunk.Chunk getNeighborChunk(int index) {
        return this.neighbors[index];
    }

    @Override
    public List<net.minecraft.world.chunk.Chunk> getNeighbors() {
        ArrayList<net.minecraft.world.chunk.Chunk> neighborList = new ArrayList<net.minecraft.world.chunk.Chunk>();
        for (net.minecraft.world.chunk.Chunk neighbor : this.neighbors) {
            if (neighbor == null) continue;
            neighborList.add(neighbor);
        }
        return neighborList;
    }

    @Override
    public boolean areNeighborsLoaded() {
        for (int i = 0; i < 4; ++i) {
            if (this.neighbors[i] != null) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setNeighbor(Direction direction, @Nullable Chunk neighbor) {
        this.neighbors[MixinChunk.directionToIndex((Direction)direction)] = (net.minecraft.world.chunk.Chunk)neighbor;
    }

    @Override
    public Optional<Chunk> getNeighbor(Direction direction, boolean shouldLoad) {
        Preconditions.checkNotNull((Object)((Object)direction), (Object)"direction");
        Preconditions.checkArgument((!direction.isSecondaryOrdinal() ? 1 : 0) != 0, (Object)"Secondary cardinal directions can't be used here");
        if (direction.isUpright() || direction == Direction.NONE) {
            return Optional.of(this);
        }
        int index = MixinChunk.directionToIndex(direction);
        Direction secondary = MixinChunk.getSecondaryDirection(direction);
        Chunk neighbor = null;
        neighbor = (Chunk)this.neighbors[index];
        if (neighbor == null && shouldLoad) {
            Vector3i neighborPosition = this.getPosition().add(MixinChunk.getCardinalDirection(direction).asBlockOffset());
            Optional<Chunk> cardinal = this.getWorld().loadChunk(neighborPosition, true);
            if (cardinal.isPresent()) {
                neighbor = cardinal.get();
            }
        }
        if (neighbor != null && secondary != Direction.NONE) {
            return neighbor.getNeighbor(secondary, shouldLoad);
        }
        return Optional.ofNullable(neighbor);
    }

    private static int directionToIndex(Direction direction) {
        switch (direction) {
            case NORTH: 
            case NORTHEAST: 
            case NORTHWEST: {
                return 0;
            }
            case SOUTH: 
            case SOUTHEAST: 
            case SOUTHWEST: {
                return 1;
            }
            case EAST: {
                return 2;
            }
            case WEST: {
                return 3;
            }
        }
        throw new IllegalArgumentException("Unexpected direction");
    }

    private static Direction getCardinalDirection(Direction direction) {
        switch (direction) {
            case NORTH: 
            case NORTHEAST: 
            case NORTHWEST: {
                return Direction.NORTH;
            }
            case SOUTH: 
            case SOUTHEAST: 
            case SOUTHWEST: {
                return Direction.SOUTH;
            }
            case EAST: {
                return Direction.EAST;
            }
            case WEST: {
                return Direction.WEST;
            }
        }
        throw new IllegalArgumentException("Unexpected direction");
    }

    private static Direction getSecondaryDirection(Direction direction) {
        switch (direction) {
            case NORTHEAST: 
            case SOUTHEAST: {
                return Direction.EAST;
            }
            case NORTHWEST: 
            case SOUTHWEST: {
                return Direction.WEST;
            }
        }
        return Direction.NONE;
    }

    @Override
    public long getScheduledForUnload() {
        return this.scheduledForUnload;
    }

    @Override
    public void setScheduledForUnload(long scheduled) {
        this.scheduledForUnload = scheduled;
    }

    @Inject(method={"generateSkylightMap"}, at={@At(value="HEAD")}, cancellable=true)
    public void onGenerateSkylightMap(CallbackInfo ci) {
        if (!WorldGenConstants.lightingEnabled) {
            ci.cancel();
        }
    }

    @Override
    public void fill(ChunkPrimer primer) {
        boolean flag = this.field_76637_e.field_73011_w.func_191066_m();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = 0; y < 256; ++y) {
                    IBlockState block = primer.func_177856_a(x, y, z);
                    if (block.func_185904_a() == Material.field_151579_a) continue;
                    int section = y >> 4;
                    if (this.field_76652_q[section] == net.minecraft.world.chunk.Chunk.field_186036_a) {
                        this.field_76652_q[section] = new ExtendedBlockStorage(section << 4, flag);
                    }
                    this.field_76652_q[section].func_177484_a(x, y & 0xF, z, block);
                }
            }
        }
    }

    @Redirect(method={"addTileEntity(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/tileentity/TileEntity;)V"}, at=@At(target="Lnet/minecraft/tileentity/TileEntity;invalidate()V", value="INVOKE"))
    private void redirectInvalidate(TileEntity te) {
        SpongeImplHooks.onTileEntityInvalidate(te);
    }

    @Override
    public boolean isActive() {
        if (this.isPersistedChunk()) {
            return true;
        }
        return this.field_76636_d && !this.isQueuedForUnload() && this.getScheduledForUnload() == -1L;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("World", (Object)this.field_76637_e).add("Position", this.field_76635_g + this.field_76647_h).toString();
    }
}

