/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.gen.populators;

import com.flowpowered.math.vector.Vector3i;
import com.google.common.base.MoreObjects;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenCactus;
import org.spongepowered.api.util.weighted.VariableAmount;
import org.spongepowered.api.world.extent.Extent;
import org.spongepowered.api.world.gen.PopulatorType;
import org.spongepowered.api.world.gen.PopulatorTypes;
import org.spongepowered.api.world.gen.populator.Cactus;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={WorldGenCactus.class})
public abstract class MixinWorldGenCactus
implements Cactus {
    private VariableAmount cactiPerChunk;
    private VariableAmount height;

    @Inject(method={"<init>()V"}, at={@At(value="RETURN")})
    public void onConstructed(CallbackInfo ci) {
        this.cactiPerChunk = VariableAmount.fixed(10.0);
        this.height = VariableAmount.baseWithRandomAddition(1.0, VariableAmount.baseWithRandomAddition(1.0, 3.0));
    }

    @Override
    public PopulatorType getType() {
        return PopulatorTypes.CACTUS;
    }

    @Override
    public void populate(org.spongepowered.api.world.World worldIn, Extent extent, Random random) {
        Vector3i min = extent.getBlockMin();
        Vector3i size = extent.getBlockSize();
        World world = (World)worldIn;
        BlockPos chunkPos = new BlockPos(min.getX(), min.getY(), min.getZ());
        int n = this.cactiPerChunk.getFlooredAmount(random);
        for (int i = 0; i < n; ++i) {
            int x = random.nextInt(size.getX());
            int z = random.nextInt(size.getZ());
            this.func_180709_b(world, random, world.func_175672_r(chunkPos.func_177982_a(x, 0, z)));
        }
    }

    @Overwrite
    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        if (worldIn.func_175623_d(position)) {
            int height = this.height.getFlooredAmount(rand);
            for (int k = 0; k < height && Blocks.field_150434_aF.func_176586_d(worldIn, position); ++k) {
                worldIn.func_180501_a(position.func_177981_b(k), Blocks.field_150434_aF.func_176223_P(), 2);
            }
        }
        return true;
    }

    @Override
    public VariableAmount getCactiPerChunk() {
        return this.cactiPerChunk;
    }

    @Override
    public void setCactiPerChunk(VariableAmount count) {
        this.cactiPerChunk = count;
    }

    @Override
    public VariableAmount getHeight() {
        return this.height;
    }

    @Override
    public void setHeight(VariableAmount height) {
        this.height = height;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("Type", (Object)"Cactus").add("PerChunk", (Object)this.cactiPerChunk).add("Height", (Object)this.height).toString();
    }
}

