/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.gen.populators;

import com.flowpowered.math.vector.Vector3i;
import com.google.common.base.Preconditions;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.gen.NoiseGeneratorSimplex;
import net.minecraft.world.gen.feature.WorldGenEndIsland;
import net.minecraft.world.gen.feature.WorldGenerator;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.util.weighted.VariableAmount;
import org.spongepowered.api.world.extent.Extent;
import org.spongepowered.api.world.gen.PopulatorType;
import org.spongepowered.api.world.gen.PopulatorTypes;
import org.spongepowered.api.world.gen.populator.EndIsland;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={WorldGenEndIsland.class})
public abstract class MixinWorldGenEndIsland
extends WorldGenerator
implements EndIsland {
    private NoiseGeneratorSimplex noise;
    private long lastSeed = -1L;
    private VariableAmount initial;
    private VariableAmount decrement;
    private BlockState state;
    private int exclusion = 1024;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    public void onConstructed(CallbackInfo ci) {
        this.initial = VariableAmount.baseWithRandomAddition(4.0, 3.0);
        this.decrement = VariableAmount.baseWithRandomAddition(0.5, 2.0);
        this.state = BlockTypes.END_STONE.getDefaultState();
    }

    @Override
    public PopulatorType getType() {
        return PopulatorTypes.END_ISLAND;
    }

    @Override
    public VariableAmount getStartingRadius() {
        return this.initial;
    }

    @Override
    public void setStartingRadius(VariableAmount radius) {
        this.initial = (VariableAmount)Preconditions.checkNotNull((Object)radius);
    }

    @Override
    public VariableAmount getRadiusDecrement() {
        return this.decrement;
    }

    @Override
    public void setRadiusDecrement(VariableAmount decrement) {
        this.decrement = (VariableAmount)Preconditions.checkNotNull((Object)decrement);
    }

    @Override
    public BlockState getIslandBlock() {
        return this.state;
    }

    @Override
    public void setIslandBlock(BlockState state) {
        this.state = (BlockState)Preconditions.checkNotNull((Object)state);
    }

    @Override
    public int getExclusionRadius() {
        return this.exclusion;
    }

    @Override
    public void setExclusionRadius(int radius) {
        Preconditions.checkArgument((radius >= 0 ? 1 : 0) != 0);
        this.exclusion = radius;
    }

    @Override
    public void populate(org.spongepowered.api.world.World worldIn, Extent extent, Random rand) {
        float f;
        Vector3i min = extent.getBlockMin();
        Vector3i size = extent.getBlockSize();
        World world = (World)worldIn;
        if (this.noise == null || worldIn.getProperties().getSeed() != this.lastSeed) {
            this.lastSeed = worldIn.getProperties().getSeed();
            this.noise = new NoiseGeneratorSimplex(new Random(this.lastSeed));
        }
        BlockPos chunkPos = new BlockPos(min.getX(), min.getY(), min.getZ());
        int chunkX = min.getX() / 16;
        int chunkZ = min.getZ() / 16;
        if ((long)min.getX() * (long)min.getX() + (long)min.getZ() * (long)min.getZ() > (long)(this.exclusion * this.exclusion) && (f = this.func_185960_a(chunkX, chunkZ, 1, 1)) < -20.0f && rand.nextInt(14) == 0) {
            this.func_180709_b(world, rand, chunkPos.func_177982_a(rand.nextInt(size.getX()), 55 + rand.nextInt(16), rand.nextInt(size.getZ())));
            if (rand.nextInt(4) == 0) {
                this.func_180709_b((World)worldIn, rand, chunkPos.func_177982_a(rand.nextInt(size.getX()), 55 + rand.nextInt(16), rand.nextInt(size.getZ())));
            }
        }
    }

    @Overwrite
    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        double radius = this.initial.getFlooredAmount(rand);
        int y = 0;
        while (radius > 0.5) {
            for (int x = MathHelper.func_76128_c((double)(-radius)); x <= MathHelper.func_76143_f((double)radius); ++x) {
                for (int z = MathHelper.func_76128_c((double)(-radius)); z <= MathHelper.func_76143_f((double)radius); ++z) {
                    if (!((double)(x * x + z * z) <= (radius + 1.0) * (radius + 1.0))) continue;
                    this.func_175903_a(worldIn, position.func_177982_a(x, y, z), (IBlockState)this.state);
                }
            }
            radius = (float)(radius - this.decrement.getAmount(rand));
            --y;
        }
        return true;
    }

    private float func_185960_a(int p_185960_1_, int p_185960_2_, int p_185960_3_, int p_185960_4_) {
        float f = p_185960_1_ * 2 + p_185960_3_;
        float f1 = p_185960_2_ * 2 + p_185960_4_;
        float f2 = 100.0f - MathHelper.func_76129_c((float)(f * f + f1 * f1)) * 8.0f;
        if (f2 > 80.0f) {
            f2 = 80.0f;
        }
        if (f2 < -100.0f) {
            f2 = -100.0f;
        }
        for (int i = -12; i <= 12; ++i) {
            for (int j = -12; j <= 12; ++j) {
                long k = p_185960_1_ + i;
                long l = p_185960_2_ + j;
                if (k * k + l * l <= 4096L || !(this.noise.func_151605_a((double)k, (double)l) < (double)-0.9f)) continue;
                float f3 = (MathHelper.func_76135_e((float)k) * 3439.0f + MathHelper.func_76135_e((float)l) * 147.0f) % 13.0f + 9.0f;
                f = p_185960_3_ - i * 2;
                f1 = p_185960_4_ - j * 2;
                float f4 = 100.0f - MathHelper.func_76129_c((float)(f * f + f1 * f1)) * f3;
                if (f4 > 80.0f) {
                    f4 = 80.0f;
                }
                if (f4 < -100.0f) {
                    f4 = -100.0f;
                }
                if (!(f4 > f2)) continue;
                f2 = f4;
            }
        }
        return f2;
    }
}

