/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.optimization.mapoptimization;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.MapDecoration;
import net.minecraft.world.storage.WorldSavedData;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.world.World;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.interfaces.world.IMixinMapData;
import org.spongepowered.common.interfaces.world.IMixinMapInfo_MapOptimization;

@Mixin(value={MapData.class})
public abstract class MixinMapData_MapOptimization
extends WorldSavedData
implements IMixinMapData {
    @Shadow
    @Final
    @Mutable
    private Map<EntityPlayer, MapData.MapInfo> field_76202_j;
    @Shadow
    public Map<String, MapDecoration> field_76203_h;
    @Shadow
    public List<MapData.MapInfo> field_76196_g;
    @Shadow
    public boolean field_186210_e;
    @Shadow
    public byte field_76197_d;
    @Shadow
    public int field_76201_a;
    @Shadow
    public int field_76199_b;
    @Shadow
    public boolean field_191096_f;
    private Set<UUID> activeWorlds = new HashSet<UUID>();
    private ItemStack dummyItemStack = new ItemStack((Item)Items.field_151098_aY, 1, this.getMapId().intValue());
    private static Constructor<MapData.MapInfo> mapInfoConstructor;
    private static Field dimensionField;

    public MixinMapData_MapOptimization(String name) {
        super(name);
    }

    @Shadow
    protected abstract void func_191095_a(MapDecoration.Type var1, net.minecraft.world.World var2, String var3, double var4, double var6, double var8);

    private Integer getMapId() {
        return Integer.valueOf(this.field_76190_i.split("map_")[1]);
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    public void onInit(CallbackInfo ci) {
        this.field_76202_j = new LinkedHashMap<EntityPlayer, MapData.MapInfo>();
    }

    @Overwrite
    public void func_76191_a(EntityPlayer player, ItemStack mapStack) {
    }

    @Override
    public void tickMap() {
        ArrayList<IMixinMapInfo_MapOptimization> mapInfosToUpdate = new ArrayList<IMixinMapInfo_MapOptimization>(this.field_76202_j.size());
        try {
            Iterator<Map.Entry<EntityPlayer, MapData.MapInfo>> it = this.field_76202_j.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<EntityPlayer, MapData.MapInfo> entry = it.next();
                EntityPlayer player = entry.getKey();
                MapData.MapInfo mapInfo = entry.getValue();
                IMixinMapInfo_MapOptimization mixinMapInfo = (IMixinMapInfo_MapOptimization)mapInfo;
                if (player.field_70128_L) {
                    it.remove();
                    continue;
                }
                if (!mixinMapInfo.isValid()) {
                    this.field_76203_h.remove(player.func_70005_c_());
                    continue;
                }
                if (this.field_186210_e && dimensionField.get(this).equals(player.field_71093_bK)) {
                    this.func_191095_a(MapDecoration.Type.PLAYER, player.field_70170_p, player.func_70005_c_(), player.field_70165_t, player.field_70161_v, player.field_70177_z);
                }
                mapInfosToUpdate.add(mixinMapInfo);
            }
            this.updatePlayersInWorld();
            for (IMixinMapInfo_MapOptimization mapInfo : mapInfosToUpdate) {
                mapInfo.setValid(false);
            }
        }
        catch (Exception e) {
            SpongeImpl.getLogger().error("Exception ticking map data!", (Throwable)e);
        }
    }

    private void updatePlayersInWorld() {
        if (Sponge.getServer().getRunningTimeTicks() % 10 == 0) {
            for (World world : Sponge.getServer().getWorlds()) {
                if (!this.activeWorlds.contains(world.getUniqueId())) continue;
                for (Player player : world.getPlayers()) {
                    Packet packet;
                    EntityPlayerMP entityplayermp = (EntityPlayerMP)player;
                    IMixinMapInfo_MapOptimization mapInfo = (IMixinMapInfo_MapOptimization)this.field_76202_j.get(player);
                    if (mapInfo != null && mapInfo.isValid()) continue;
                    if (mapInfo == null) {
                        mapInfo = (IMixinMapInfo_MapOptimization)this.constructMapInfo((EntityPlayer)entityplayermp);
                        this.field_76202_j.put((EntityPlayer)entityplayermp, (MapData.MapInfo)mapInfo);
                    }
                    if ((packet = Items.field_151098_aY.func_150911_c(this.dummyItemStack, (net.minecraft.world.World)world, (EntityPlayer)entityplayermp)) == null) continue;
                    entityplayermp.field_71135_a.func_147359_a(packet);
                }
            }
        }
    }

    @Redirect(method={"updateMapData"}, at=@At(value="INVOKE", target="Ljava/util/List;iterator()Ljava/util/Iterator;"))
    public Iterator onGetMapInfoIterator(List this$0) {
        return this.field_76202_j.values().iterator();
    }

    private MapData.MapInfo constructMapInfo(EntityPlayer player) {
        try {
            return mapInfoConstructor.newInstance(this, player);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to construct MapInfo for player " + player, e);
        }
    }

    @Override
    public void updatePlayer(EntityPlayer player, ItemStack mapStack) {
        MapData.MapInfo info = this.field_76202_j.get(player);
        if (info == null) {
            info = this.constructMapInfo(player);
            this.field_76202_j.put(player, info);
        }
        ((IMixinMapInfo_MapOptimization)info).setValid(true);
        if (mapStack.func_77942_o() && mapStack.func_77978_p().func_150297_b("Decorations", 9)) {
            NBTTagList nbttaglist = mapStack.func_77978_p().func_150295_c("Decorations", 10);
            for (int j = 0; j < nbttaglist.func_74745_c(); ++j) {
                NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(j);
                if (this.field_76203_h.containsKey(nbttagcompound.func_74779_i("id"))) continue;
                this.func_191095_a(MapDecoration.Type.func_191159_a((byte)nbttagcompound.func_74771_c("type")), player.field_70170_p, nbttagcompound.func_74779_i("id"), nbttagcompound.func_74769_h("x"), nbttagcompound.func_74769_h("z"), nbttagcompound.func_74769_h("rot"));
            }
        }
    }

    @Override
    public void updateItemFrameDecoration(EntityItemFrame frame) {
        this.activeWorlds.add(((Entity)frame).getWorld().getUniqueId());
        if (this.field_186210_e) {
            BlockPos blockpos = frame.func_174857_n();
            if (blockpos == null || frame.field_174860_b == null) {
                return;
            }
            this.func_191095_a(MapDecoration.Type.FRAME, frame.field_70170_p, "frame-" + frame.func_145782_y(), blockpos.func_177958_n(), blockpos.func_177952_p(), frame.field_174860_b.func_176736_b() * 90);
        }
    }

    @Override
    public void removeItemFrame(EntityItemFrame frame) {
        this.activeWorlds.remove(((Entity)frame).getWorld().getUniqueId());
        this.field_76203_h.remove("frame-" + frame.func_145782_y());
    }

    static {
        try {
            mapInfoConstructor = MapData.MapInfo.class.getDeclaredConstructor(MapData.class, EntityPlayer.class);
            dimensionField = SpongeImplHooks.isDeobfuscatedEnvironment() ? MapData.class.getDeclaredField("dimension") : MapData.class.getDeclaredField("field_76200_c");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

