/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.world;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.registry.AdditionalCatalogRegistryModule;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.api.world.teleport.TeleportHelperFilter;
import org.spongepowered.api.world.teleport.TeleportHelperFilters;
import org.spongepowered.common.world.teleport.ConfigTeleportHelperFilter;
import org.spongepowered.common.world.teleport.DefaultTeleportHelperFilter;
import org.spongepowered.common.world.teleport.FlyingTeleportHelperFilter;
import org.spongepowered.common.world.teleport.NoPortalTeleportHelperFilter;
import org.spongepowered.common.world.teleport.SurfaceOnlyTeleportHelperFilter;

public class TeleportHelperFilterRegistryModule
implements AdditionalCatalogRegistryModule<TeleportHelperFilter> {
    @RegisterCatalog(value=TeleportHelperFilters.class)
    private final Map<String, TeleportHelperFilter> filterMap = Maps.newHashMap();
    private final Map<String, TeleportHelperFilter> idMap = Maps.newHashMap();

    @Override
    public Optional<TeleportHelperFilter> getById(String id) {
        return Optional.ofNullable(this.idMap.get(id.toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public Collection<TeleportHelperFilter> getAll() {
        return ImmutableList.copyOf(this.idMap.values());
    }

    @Override
    public void registerAdditionalCatalog(TeleportHelperFilter extraCatalog) {
        Preconditions.checkNotNull((Object)extraCatalog, (Object)"TeleportHelperFilter cannot be null!");
        Preconditions.checkState((!this.idMap.containsKey(extraCatalog.getId().toLowerCase(Locale.ENGLISH)) ? 1 : 0) != 0, (Object)"TeleportHelperFilter must have a unique id!");
        this.idMap.put(extraCatalog.getId(), extraCatalog);
    }

    @Override
    public void registerDefaults() {
        this.filterMap.put("config", new ConfigTeleportHelperFilter());
        this.filterMap.put("default", new DefaultTeleportHelperFilter());
        this.filterMap.put("flying", new FlyingTeleportHelperFilter());
        this.filterMap.put("no_portal", new NoPortalTeleportHelperFilter());
        this.filterMap.put("surface_only", new SurfaceOnlyTeleportHelperFilter());
        this.filterMap.forEach((key, value) -> this.idMap.put(value.getId().toLowerCase(Locale.ENGLISH), (TeleportHelperFilter)value));
    }
}

