/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.mod;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.spongepowered.api.MinecraftVersion;
import org.spongepowered.api.Platform;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.plugin.PluginManager;
import org.spongepowered.common.SpongePlatform;
import org.spongepowered.mod.SpongeMod;

@Singleton
public final class SpongeModPlatform
extends SpongePlatform {
    @Inject
    public SpongeModPlatform(PluginManager manager, MinecraftVersion minecraftVersion) {
        super(manager, (PluginContainer)((Object)SpongeMod.instance), minecraftVersion);
        this.platformMap.put("ForgeVersion", ForgeVersion.getVersion());
    }

    @Override
    public Platform.Type getType() {
        switch (FMLCommonHandler.instance().getSide()) {
            case CLIENT: {
                return Platform.Type.CLIENT;
            }
            case SERVER: {
                return Platform.Type.SERVER;
            }
        }
        return Platform.Type.UNKNOWN;
    }

    @Override
    public Platform.Type getExecutionType() {
        return SpongeModPlatform.staticGetExecutionType();
    }

    public static Platform.Type staticGetExecutionType() {
        String threadName = Thread.currentThread().getName();
        if (threadName.equals("Server thread") || threadName.startsWith("Netty Epoll Server IO #") || threadName.startsWith("Netty Server IO #") || threadName.startsWith("User Authenticator #")) {
            return Platform.Type.SERVER;
        }
        if (threadName.equals("Client thread") || threadName.startsWith("Netty Client IO #") || threadName.startsWith("Netty Epoll Client IO #") || threadName.startsWith("Netty Local Client IO ") || threadName.startsWith("Netty Local Server IO #")) {
            return Platform.Type.CLIENT;
        }
        if (threadName.equals("Server Infinisleeper") || threadName.equals("Server console handler") || threadName.equals("Server Shutdown Thread")) {
            return Platform.Type.SERVER;
        }
        if (threadName.startsWith("Server Pinger #") || threadName.startsWith("Chunk Batcher ") || threadName.equals("Client Shutdown Thread") || threadName.equals("Realms-connect-task") || threadName.startsWith("Texture Downloader #") || threadName.startsWith("Server Connector #") || threadName.equals("Timer hack thread") || threadName.equals("Twitch authenticator") || threadName.equals("Twitch shutdown hook") || threadName.equals("Sound Library Loader")) {
            return Platform.Type.CLIENT;
        }
        return Platform.Type.UNKNOWN;
    }
}

