/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.mod.mixin.core.item;

import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.interfaces.item.IMixinItem;
import org.spongepowered.common.registry.type.ItemTypeRegistryModule;

@Mixin(value={Item.class}, priority=1050)
public abstract class MixinItem
implements ItemType,
IMixinItem {
    @Shadow(remap=false)
    public abstract boolean hasCustomEntity(ItemStack var1);

    @Shadow(remap=false)
    @Nullable
    public abstract Entity createEntity(World var1, Entity var2, ItemStack var3);

    @Override
    public String getId() {
        ResourceLocation resourceLocation = ((Item)this).getRegistryName();
        Preconditions.checkState((resourceLocation != null ? 1 : 0) != 0, (Object)"Attempted to access the id before the registry name is set.");
        return resourceLocation.toString();
    }

    @Inject(method={"registerItem(ILnet/minecraft/util/ResourceLocation;Lnet/minecraft/item/Item;)V"}, at={@At(value="RETURN")})
    private static void registerMinecraftItem(int id, ResourceLocation name, Item item, CallbackInfo ci) {
        ResourceLocation nameForObject = (ResourceLocation)Item.field_150901_e.func_177774_c((Object)item);
        Item registered = nameForObject == null ? (Item)Preconditions.checkNotNull((Object)Item.field_150901_e.func_82594_a((Object)name), (Object)"Someone replaced a vanilla item with a null item!!!") : item;
        ItemTypeRegistryModule.getInstance().registerAdditionalCatalog((ItemType)registered);
    }

    @Override
    public Optional<Entity> getCustomEntityItem(World world, Entity location, ItemStack itemstack) {
        if (this.hasCustomEntity(itemstack)) {
            return Optional.ofNullable(this.createEntity(world, location, itemstack));
        }
        return Optional.empty();
    }
}

