/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile.reactor;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.IConfigurable;
import mekanism.api.IHeatTransfer;
import mekanism.api.Range4D;
import mekanism.api.TileNetworkList;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTankInfo;
import mekanism.api.gas.IGasHandler;
import mekanism.api.gas.ITubeConnection;
import mekanism.common.Mekanism;
import mekanism.common.MekanismFluids;
import mekanism.common.base.FluidHandlerWrapper;
import mekanism.common.base.IEnergyWrapper;
import mekanism.common.base.IFluidHandlerWrapper;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.util.CableUtils;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.HeatUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.PipeUtils;
import mekanism.generators.common.item.ItemHohlraum;
import mekanism.generators.common.tile.reactor.TileEntityReactorBlock;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class TileEntityReactorPort
extends TileEntityReactorBlock
implements IFluidHandlerWrapper,
IGasHandler,
ITubeConnection,
IHeatTransfer,
IConfigurable {
    public boolean fluidEject;

    public TileEntityReactorPort() {
        super("name", 1.0);
        this.inventory = NonNullList.func_191197_a((int)0, (Object)ItemStack.field_190927_a);
    }

    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.fluidEject = nbtTags.func_74767_n("fluidEject");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbtTags) {
        super.func_189515_b(nbtTags);
        nbtTags.func_74757_a("fluidEject", this.fluidEject);
        return nbtTags;
    }

    @Override
    public boolean isFrame() {
        return false;
    }

    @Override
    public void onUpdate() {
        if (this.changed) {
            this.field_145850_b.func_175685_c(this.func_174877_v(), this.func_145838_q(), true);
        }
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K) {
            CableUtils.emit((IEnergyWrapper)this);
            if (this.fluidEject && this.getReactor() != null && this.getReactor().getSteamTank().getFluid() != null) {
                FluidTank tank = this.getReactor().getSteamTank();
                for (EnumFacing side : EnumFacing.values()) {
                    IFluidHandler handler;
                    TileEntity tile = Coord4D.get((TileEntity)this).offset(side).getTileEntity((IBlockAccess)this.field_145850_b);
                    if (tile == null || tile instanceof TileEntityReactorPort || !CapabilityUtils.hasCapability((ICapabilityProvider)tile, (Capability)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, (EnumFacing)side.func_176734_d()) || !PipeUtils.canFill((IFluidHandler)(handler = (IFluidHandler)CapabilityUtils.getCapability((ICapabilityProvider)tile, (Capability)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, (EnumFacing)side.func_176734_d())), (FluidStack)tank.getFluid())) continue;
                    tank.drain(handler.fill(tank.getFluid(), true), true);
                }
            }
        }
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        if (resource.getFluid() == FluidRegistry.WATER && this.getReactor() != null && !this.fluidEject) {
            return this.getReactor().getWaterTank().fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        if (resource.getFluid() == FluidRegistry.getFluid((String)"steam") && this.getReactor() != null) {
            this.getReactor().getSteamTank().drain(resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        if (this.getReactor() != null) {
            return this.getReactor().getSteamTank().drain(maxDrain, doDrain);
        }
        return null;
    }

    public boolean canFill(EnumFacing from, FluidStack fluid) {
        return this.getReactor() != null && fluid.getFluid() == FluidRegistry.WATER && !this.fluidEject;
    }

    public boolean canDrain(EnumFacing from, @Nullable FluidStack fluid) {
        return this.getReactor() != null && (fluid == null || fluid.getFluid() == FluidRegistry.getFluid((String)"steam"));
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        if (this.getReactor() == null) {
            return PipeUtils.EMPTY;
        }
        return new FluidTankInfo[]{this.getReactor().getWaterTank().getInfo(), this.getReactor().getSteamTank().getInfo()};
    }

    public FluidTankInfo[] getAllTanks() {
        return this.getTankInfo(null);
    }

    public int receiveGas(EnumFacing side, GasStack stack, boolean doTransfer) {
        if (this.getReactor() != null) {
            if (stack.getGas() == MekanismFluids.Deuterium) {
                return this.getReactor().getDeuteriumTank().receive(stack, doTransfer);
            }
            if (stack.getGas() == MekanismFluids.Tritium) {
                return this.getReactor().getTritiumTank().receive(stack, doTransfer);
            }
            if (stack.getGas() == MekanismFluids.FusionFuel) {
                return this.getReactor().getFuelTank().receive(stack, doTransfer);
            }
        }
        return 0;
    }

    public GasStack drawGas(EnumFacing side, int amount, boolean doTransfer) {
        return null;
    }

    public boolean canReceiveGas(EnumFacing side, Gas type) {
        return type == MekanismFluids.Deuterium || type == MekanismFluids.Tritium || type == MekanismFluids.FusionFuel;
    }

    public boolean canDrawGas(EnumFacing side, Gas type) {
        return false;
    }

    @Nonnull
    public GasTankInfo[] getTankInfo() {
        GasTankInfo[] gasTankInfoArray;
        if (this.getReactor() != null) {
            GasTankInfo[] gasTankInfoArray2 = new GasTankInfo[3];
            gasTankInfoArray2[0] = this.getReactor().getDeuteriumTank();
            gasTankInfoArray2[1] = this.getReactor().getTritiumTank();
            gasTankInfoArray = gasTankInfoArray2;
            gasTankInfoArray2[2] = this.getReactor().getFuelTank();
        } else {
            gasTankInfoArray = IGasHandler.NONE;
        }
        return gasTankInfoArray;
    }

    public boolean canTubeConnect(EnumFacing side) {
        return this.getReactor() != null;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing side) {
        return capability == Capabilities.GAS_HANDLER_CAPABILITY || capability == Capabilities.TUBE_CONNECTION_CAPABILITY || capability == Capabilities.HEAT_TRANSFER_CAPABILITY || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || capability == Capabilities.CONFIGURABLE_CAPABILITY || super.hasCapability(capability, side);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (capability == Capabilities.GAS_HANDLER_CAPABILITY || capability == Capabilities.TUBE_CONNECTION_CAPABILITY || capability == Capabilities.HEAT_TRANSFER_CAPABILITY || capability == Capabilities.CONFIGURABLE_CAPABILITY) {
            return (T)((Object)this);
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)new FluidHandlerWrapper((IFluidHandlerWrapper)this, side);
        }
        return (T)super.getCapability(capability, side);
    }

    public boolean canOutputEnergy(EnumFacing side) {
        return true;
    }

    public double getEnergy() {
        if (this.getReactor() == null) {
            return 0.0;
        }
        return this.getReactor().getBufferedEnergy();
    }

    public void setEnergy(double energy) {
        if (this.getReactor() != null) {
            this.getReactor().setBufferedEnergy(energy);
        }
    }

    public double getMaxEnergy() {
        if (this.getReactor() == null) {
            return 0.0;
        }
        return this.getReactor().getBufferSize();
    }

    @Override
    public boolean sideIsOutput(EnumFacing side) {
        return true;
    }

    @Override
    public boolean sideIsConsumer(EnumFacing side) {
        return false;
    }

    public double getMaxOutput() {
        return 1.0E9;
    }

    public double getTemp() {
        if (this.getReactor() != null) {
            return this.getReactor().getTemp();
        }
        return 0.0;
    }

    public double getInverseConductionCoefficient() {
        return 5.0;
    }

    public double getInsulationCoefficient(EnumFacing side) {
        if (this.getReactor() != null) {
            return this.getReactor().getInsulationCoefficient(side);
        }
        return 0.0;
    }

    public void transferHeatTo(double heat) {
        if (this.getReactor() != null) {
            this.getReactor().transferHeatTo(heat);
        }
    }

    public double[] simulateHeat() {
        return HeatUtils.simulate((IHeatTransfer)this);
    }

    public double applyTemperatureChange() {
        if (this.getReactor() != null) {
            return this.getReactor().applyTemperatureChange();
        }
        return 0.0;
    }

    public boolean canConnectHeat(EnumFacing side) {
        return this.getReactor() != null;
    }

    public IHeatTransfer getAdjacent(EnumFacing side) {
        TileEntity adj = Coord4D.get((TileEntity)this).offset(side).getTileEntity((IBlockAccess)this.field_145850_b);
        if (CapabilityUtils.hasCapability((ICapabilityProvider)adj, (Capability)Capabilities.HEAT_TRANSFER_CAPABILITY, (EnumFacing)side.func_176734_d()) && !(adj instanceof TileEntityReactorBlock)) {
            return (IHeatTransfer)CapabilityUtils.getCapability((ICapabilityProvider)adj, (Capability)Capabilities.HEAT_TRANSFER_CAPABILITY, (EnumFacing)side.func_176734_d());
        }
        return null;
    }

    public ItemStack func_70301_a(int slotID) {
        return this.getReactor() != null && this.getReactor().isFormed() ? (ItemStack)this.getReactor().getInventory().get(slotID) : ItemStack.field_190927_a;
    }

    public int func_70302_i_() {
        return this.getReactor() != null && this.getReactor().isFormed() ? 1 : 0;
    }

    public void func_70299_a(int slotID, ItemStack itemstack) {
        if (this.getReactor() != null && this.getReactor().isFormed()) {
            this.getReactor().getInventory().set(slotID, (Object)itemstack);
            if (!itemstack.func_190926_b() && itemstack.func_190916_E() > this.func_70297_j_()) {
                itemstack.func_190920_e(this.func_70297_j_());
            }
        }
    }

    public int[] func_180463_a(EnumFacing side) {
        int[] nArray;
        if (this.getReactor() != null && this.getReactor().isFormed()) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 0;
        } else {
            nArray = InventoryUtils.EMPTY;
        }
        return nArray;
    }

    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        if (this.getReactor() != null && this.getReactor().isFormed() && itemstack.func_77973_b() instanceof ItemHohlraum) {
            ItemHohlraum hohlraum = (ItemHohlraum)itemstack.func_77973_b();
            return hohlraum.getGas(itemstack) != null && hohlraum.getGas((ItemStack)itemstack).amount == hohlraum.getMaxGas(itemstack);
        }
        return false;
    }

    public boolean func_180461_b(int slotID, ItemStack itemstack, EnumFacing side) {
        if (this.getReactor() != null && this.getReactor().isFormed() && itemstack.func_77973_b() instanceof ItemHohlraum) {
            ItemHohlraum hohlraum = (ItemHohlraum)itemstack.func_77973_b();
            return hohlraum.getGas(itemstack) == null;
        }
        return false;
    }

    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            boolean prevEject = this.fluidEject;
            this.fluidEject = dataStream.readBoolean();
            if (prevEject != this.fluidEject) {
                MekanismUtils.updateBlock((World)this.field_145850_b, (BlockPos)this.func_174877_v());
            }
        }
    }

    public TileNetworkList getNetworkedData(TileNetworkList data) {
        super.getNetworkedData(data);
        data.add((Object)this.fluidEject);
        return data;
    }

    public EnumActionResult onSneakRightClick(EntityPlayer player, EnumFacing side) {
        if (!this.field_145850_b.field_72995_K) {
            this.fluidEject = !this.fluidEject;
            String modeText = " " + (this.fluidEject ? EnumColor.DARK_RED : EnumColor.DARK_GREEN) + LangUtils.transOutputInput((boolean)this.fluidEject) + ".";
            player.func_145747_a((ITextComponent)new TextComponentString(EnumColor.DARK_BLUE + "[Mekanism] " + EnumColor.GREY + LangUtils.localize((String)"tooltip.configurator.reactorPortEject") + modeText));
            Mekanism.packetHandler.sendToReceivers((IMessage)new PacketTileEntity.TileEntityMessage(Coord4D.get((TileEntity)this), this.getNetworkedData(new TileNetworkList())), new Range4D(Coord4D.get((TileEntity)this)));
            this.func_70296_d();
        }
        return EnumActionResult.SUCCESS;
    }

    public EnumActionResult onRightClick(EntityPlayer player, EnumFacing side) {
        return EnumActionResult.PASS;
    }
}

